/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.viewpoint;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.PapyrusDocumentPrototype;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.RepresentationPackage;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.Activator;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.command.ICreateDocumentTemplateEditorCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.viewpoint.PapyrusDocumentTemplateViewPrototype;

public class CreatePapyrusDocumentTemplateViewTypeCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusRepresentationKind, PapyrusDocumentTemplateViewPrototype> cache;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)RepresentationPackage.eINSTANCE.getPapyrusDocumentPrototype());
    }

    public boolean isSupported(EObject view) {
        return view instanceof DocumentTemplate;
    }

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        if (!(kind instanceof PapyrusDocumentPrototype)) {
            return null;
        }
        PapyrusDocumentPrototype papyrusDocument = (PapyrusDocumentPrototype)kind;
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusRepresentationKind, PapyrusDocumentTemplateViewPrototype>();
        }
        if (this.cache.containsKey(papyrusDocument)) {
            return this.cache.get(papyrusDocument);
        }
        Class creationCommandClass = papyrusDocument.getCreationCommandClass();
        try {
            ICreateDocumentTemplateEditorCommand command = (ICreateDocumentTemplateEditorCommand)creationCommandClass.newInstance();
            PapyrusDocumentTemplateViewPrototype proto = new PapyrusDocumentTemplateViewPrototype(papyrusDocument, command);
            this.cache.put((PapyrusRepresentationKind)papyrusDocument, proto);
            return proto;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        PolicyChecker checker = PolicyChecker.getFor((EObject)view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        PapyrusDocumentPrototype repKind = (PapyrusDocumentPrototype)manager.getRepresentationKindById(((DocumentTemplate)view).getKindId());
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

