/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.architecture.migration;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler_1_3_0;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.ProfileUtils;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class SysMLDiagramReconciler_1_3_0
extends DiagramReconciler_1_3_0 {
    private static final String BLOCK_DEFINITION_DIAGRAM = "BlockDefinition";
    private static final String INTERNAL_BLOCK_DIAGRAM = "InternalBlock";
    private static final String PARAMETRIC_DIAGRAM = "Parametric";
    private static final String REQUIREMENT_DIAGRAM = "RequirementDiagram";

    protected PapyrusDiagram getDiagramKind(Diagram diagram, PapyrusViewStyle oldStyle) {
        org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram oldDiagramKind;
        if (oldStyle != null && (oldDiagramKind = (org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram)oldStyle.getConfiguration()) != null) {
            return this.getDiagramKind(oldDiagramKind.getName(), diagram);
        }
        if (BLOCK_DEFINITION_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Block Definition Diagram", diagram);
        }
        if (INTERNAL_BLOCK_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Internal Block Diagram", diagram);
        }
        if (PARAMETRIC_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Parametric Diagram", diagram);
        }
        if (REQUIREMENT_DIAGRAM.equals(diagram.getType())) {
            return this.getDiagramKind("Requirement Diagram", diagram);
        }
        return null;
    }

    protected PapyrusDiagram getDiagramKind(String name, Diagram diagram) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureDescriptionLanguage context = (MergedArchitectureDescriptionLanguage)manager.getArchitectureContextById("org.eclipse.papyrus.sysml.architecture.SysML");
        for (RepresentationKind pKind : context.getRepresentationKinds()) {
            PapyrusDiagram dKind;
            if (!pKind.getName().equals(name) || !((ModelRule)(dKind = (PapyrusDiagram)pKind).getModelRules().get(0)).getElement().isInstance((Object)diagram.getElement())) continue;
            boolean allStereotypesApplied = true;
            Collection appliedStereotypes = ProfileUtils.getProfileHelper().getAppliedStereotypes(diagram.getElement());
            for (EClass stereotype : ((ModelRule)dKind.getModelRules().get(0)).getStereotypes()) {
                if (appliedStereotypes.contains(stereotype)) continue;
                allStereotypesApplied = false;
            }
            if (!allStereotypesApplied) continue;
            return dKind;
        }
        return null;
    }
}

