/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.xmi;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.interoperability.rpy.xmi.EMF_XMI_ID_Helper;
import org.eclipse.papyrus.interoperability.rpy.xmi.XMI_ID_Helper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UML_XMI_ID_Helper {
    private static final String PROPERTY_OF_ASSOCIATION__OTHER_END = "-other-end";
    private static final String ASSOCIATION = "-association";
    private static final String CONNECTOR_END = "end";
    public static final String VALUE_SPECIFICATION__LOWER_VALUE = "multiplicity-lower-value";
    public static final String VALUE_SPECIFICATION__UPPER_VALUE = "multiplicity-upper-value";
    public static final String MODEL_ELEMENT_OWNED_COMMENT = "modelElement-ownedComment";
    public static final String OF = "of";

    public static final String calculateIdForUML(EObject element) {
        String result = null;
        if (element instanceof Element) {
            result = UML_XMI_ID_Helper.calculateIdForUML((Element)element);
        } else if (element instanceof EObject) {
            Element baseElement = UMLUtil.getBaseElement((EObject)element);
            result = baseElement != null ? UML_XMI_ID_Helper.calculateIDForStereotypeApplication(element, baseElement) : EMF_XMI_ID_Helper.calculateIdForEMF(element);
        }
        return result;
    }

    private static final String calculateIdForUML(Element element) {
        String returnedValue = null;
        if (element instanceof OpaqueExpression) {
            returnedValue = UML_XMI_ID_Helper.calculateId((OpaqueExpression)element);
        } else if (element instanceof InstanceValue) {
            returnedValue = UML_XMI_ID_Helper.calculateId((InstanceValue)element);
        } else if (element instanceof Comment) {
            returnedValue = UML_XMI_ID_Helper.calculateId((Comment)element);
        } else if (element instanceof Package) {
            returnedValue = UML_XMI_ID_Helper.calculateId((Package)element);
        } else if (element instanceof Property) {
            returnedValue = UML_XMI_ID_Helper.calculateId((Property)element);
        } else if (element instanceof Association) {
            returnedValue = UML_XMI_ID_Helper.calculateId((Association)element);
        } else if (element instanceof TemplateBinding) {
            returnedValue = UML_XMI_ID_Helper.calculateId((TemplateBinding)element);
        } else if (element instanceof TemplateParameterSubstitution) {
            returnedValue = UML_XMI_ID_Helper.calculateId((TemplateParameterSubstitution)element);
        } else if (element instanceof ConnectorEnd) {
            returnedValue = UML_XMI_ID_Helper.calculateId((ConnectorEnd)element);
        } else if (element instanceof ValueSpecification) {
            returnedValue = UML_XMI_ID_Helper.calculateId((ValueSpecification)element);
        } else if (element instanceof PackageImport) {
            returnedValue = UML_XMI_ID_Helper.calculateId((PackageImport)element);
        } else if (element instanceof ProfileApplication) {
            returnedValue = UML_XMI_ID_Helper.calculateId((ProfileApplication)element);
        }
        return returnedValue;
    }

    public static final String calculateId(Comment comment) {
        Element owner = comment.getOwner();
        String parentId = XMI_ID_Helper.getXMI_ID((EObject)owner);
        StringBuilder builder = new StringBuilder(parentId);
        builder.append("-");
        builder.append(MODEL_ELEMENT_OWNED_COMMENT);
        builder.append("-");
        builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)owner.getOwnedComments(), (EObject)comment));
        return builder.toString();
    }

    public static final String calculateId(Package pack) {
        Element parent = pack.getOwner();
        String parentID = XMI_ID_Helper.getXMI_ID((EObject)parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(pack.eClass().getName());
        builder.append("-");
        builder.append(pack.getQualifiedName());
        return builder.toString();
    }

    public static final String calculateId(Property property) {
        Association association = property.getAssociation();
        EList ends = association.getMemberEnds();
        StringBuilder builder = new StringBuilder();
        for (Property current : ends) {
            if (current == property) continue;
            builder.append(XMI_ID_Helper.getXMI_ID((EObject)current));
            builder.append(PROPERTY_OF_ASSOCIATION__OTHER_END);
            if (ends.size() <= 2) break;
            builder.append("-");
            builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)ends, (EObject)current));
            break;
        }
        return builder.toString();
    }

    public static final String calculateId(Association association) {
        EList ends = association.getMemberEnds();
        StringBuilder builder = new StringBuilder();
        for (Property current : ends) {
            if (current.eContainer() == association) continue;
            builder.append(XMI_ID_Helper.getXMI_ID((EObject)current));
            builder.append(ASSOCIATION);
            if (ends.size() <= 2) break;
            builder.append("-");
            builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)ends, (EObject)current));
            break;
        }
        return builder.toString();
    }

    public static final String calculateId(TemplateBinding templateBinding) {
        TemplateableElement parent = (TemplateableElement)templateBinding.getOwner();
        String parentID = XMI_ID_Helper.getXMI_ID((EObject)parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(templateBinding.eClass().getName());
        builder.append("-");
        builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)parent.getTemplateBindings(), (EObject)templateBinding));
        return builder.toString();
    }

    public static final String calculateId(TemplateParameterSubstitution templateBindingSubsitution) {
        TemplateBinding parent = templateBindingSubsitution.getTemplateBinding();
        String parentID = XMI_ID_Helper.getXMI_ID((EObject)parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(templateBindingSubsitution.eClass().getName());
        builder.append("-");
        builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)parent.getParameterSubstitutions(), (EObject)templateBindingSubsitution));
        return builder.toString();
    }

    public static final String calculateId(ConnectorEnd connectorEnd) {
        Connector owner = (Connector)connectorEnd.getOwner();
        String parentId = XMI_ID_Helper.getXMI_ID((EObject)owner);
        StringBuilder builder = new StringBuilder(parentId);
        builder.append("-");
        builder.append(CONNECTOR_END);
        builder.append("-");
        builder.append(UML_XMI_ID_Helper.getIndexToUseToBuildXMI_ID((List<? extends EObject>)owner.getEnds(), (EObject)connectorEnd));
        return builder.toString();
    }

    protected static final int getIndexToUseToBuildXMI_ID(List<? extends EObject> list, EObject anEObject) {
        return list.indexOf(anEObject) + 1;
    }

    public static final String calculateId(ValueSpecification valueSpec) {
        StringBuilder builder = new StringBuilder(XMI_ID_Helper.getXMI_ID(valueSpec.eContainer()));
        builder.append("-");
        if (valueSpec instanceof ValueSpecification && valueSpec.eContainingFeature() == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue()) {
            builder.append(VALUE_SPECIFICATION__LOWER_VALUE);
        } else if (valueSpec instanceof ValueSpecification && valueSpec.eContainingFeature() == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue()) {
            builder.append(VALUE_SPECIFICATION__UPPER_VALUE);
        } else {
            builder = new StringBuilder();
        }
        return builder.toString();
    }

    public static final String calculateId(PackageImport packageImport) {
        EObject parent = packageImport.eContainer();
        String parentID = XMI_ID_Helper.getXMI_ID(parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(packageImport.eClass().getName());
        builder.append("-");
        builder.append(packageImport.getImportedPackage().getQualifiedName());
        return builder.toString();
    }

    public static final String calculateId(ProfileApplication profileApplication) {
        EObject parent = profileApplication.eContainer();
        String parentID = XMI_ID_Helper.getXMI_ID(parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(profileApplication.eClass().getName());
        builder.append("-");
        builder.append(profileApplication.getAppliedProfile().getQualifiedName());
        return builder.toString();
    }

    private static final String calculateIDForStereotypeApplication(EObject stereotypeApplication, Element baseElement) {
        StringBuilder builder = new StringBuilder();
        String baseElementId = XMI_ID_Helper.getXMI_ID((EObject)baseElement);
        String eClassName = stereotypeApplication.eClass().getName();
        builder.append(eClassName);
        builder.append("-");
        builder.append(OF);
        builder.append("-");
        builder.append(baseElementId);
        return builder.toString();
    }

    private static final String calculateId(OpaqueExpression opaqueExpression) {
        EObject parent = opaqueExpression.eContainer();
        String parentID = XMI_ID_Helper.getXMI_ID(parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(opaqueExpression.eClass().getName());
        return builder.toString();
    }

    private static final String calculateId(InstanceValue instanceValue) {
        EObject parent = instanceValue.eContainer();
        String parentID = XMI_ID_Helper.getXMI_ID(parent);
        StringBuilder builder = new StringBuilder(parentID);
        builder.append("-");
        builder.append(instanceValue.eClass().getName());
        return builder.toString();
    }
}

