/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.transformations.notation;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class DiagramCreateUtils {
    public static View createGraphicalNode(EObject eObject, String graphicalType, View containerView) {
        return ViewService.getInstance().createView(Node.class, (IAdaptable)new EObjectAdapter(eObject), containerView, graphicalType, -1, true, DiagramCreateUtils.getPreferenceHint(containerView.getDiagram()));
    }

    public static View createStateMachingGraphicalNode(EObject semanticElement, View container) {
        String graphicalType = UMLVisualIDRegistry.getNodeVisualID((View)container, (EObject)semanticElement);
        View view = ViewService.getInstance().createView(Node.class, (IAdaptable)new SemanticElementAdapter(semanticElement, UMLElementTypes.getElementType((String)graphicalType)), container, graphicalType, -1, true, new PreferencesHint("org.eclipse.papyrus.uml.diagram.statemachine"));
        return view;
    }

    public static View createClassDiagramGraphicalEdge(EObject semanticElement, View sourceView, View targetView, Diagram diagram) {
        String graphicalType = UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)semanticElement);
        Edge edge = (Edge)ViewService.getInstance().createView(Edge.class, (IAdaptable)new SemanticElementAdapter(semanticElement, UMLElementTypes.getElementType((String)graphicalType)), (View)diagram, graphicalType, -1, true, new PreferencesHint("PapyrusUMLClassDiagram"));
        if (edge != null) {
            edge.setSource(sourceView);
            edge.setTarget(targetView);
        }
        return edge;
    }

    private static PreferencesHint getPreferenceHint(Diagram diagram) {
        PreferencesHint preferenceHint = null;
        if ("PapyrusUMLStateMachineDiagram".equals(diagram.getType())) {
            preferenceHint = new PreferencesHint("org.eclipse.papyrus.uml.diagram.statemachine");
        }
        return preferenceHint;
    }

    protected IElementType getClassDiagElementType(String graphicalType) {
        return UMLElementTypes.getElementType((String)graphicalType);
    }

    public static View createStateMachineDiagramGraphicalEdge(EObject semanticElement, View sourceView, View targetView, Diagram diagram) {
        String graphicalType = UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)semanticElement);
        Edge edge = (Edge)ViewService.getInstance().createView(Edge.class, (IAdaptable)new SemanticElementAdapter(semanticElement, UMLElementTypes.getElementType((String)graphicalType)), (View)diagram, graphicalType, -1, true, new PreferencesHint("org.eclipse.papyrus.uml.diagram.statemachine"));
        if (edge != null) {
            edge.setSource(sourceView);
            edge.setTarget(targetView);
        }
        return edge;
    }
}

