/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.transformations;

import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Trace;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.concurrent.ExecutorsPool;
import org.eclipse.papyrus.uml.m2m.qvto.common.concurrent.ResourceAccessHelper;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ImportTransformations {
    ResourceSetImpl resourceSet;
    protected final URI sourceURI;
    protected URI targetURI;
    protected ModelExtent outUML;
    protected ModelExtent outNotation;
    protected ModelExtent outSashModel;
    protected ModelExtent primitivesCTypesModel;
    protected ModelExtent inPapyrusProfiles;
    protected ModelExtent inRpyModel;
    protected ModelExtent inPapyrusLibraries;
    protected ModelExtent umlPrimitivesTypes;
    protected ModelExtent ansiCLibrary;
    protected ModelExtent sysML11Profile;
    protected Trace executionTrace;
    protected Job job;
    protected Resource umlResource;
    protected boolean complete = false;
    protected List<Diagram> diagramsToDelete = new LinkedList<Diagram>();
    protected static final ExecutorsPool executorsPool = new ExecutorsPool(2);
    protected static final Set<EPackage> sourceEPackages = new HashSet<EPackage>();
    protected static final Set<String> supportedDiagramIds = new HashSet<String>();

    static {
        supportedDiagramIds.addAll(Arrays.asList("Class", "Statechart"));
    }

    public ImportTransformations(URI sourceURI) {
        Assert.isNotNull((Object)sourceURI);
        this.sourceURI = sourceURI;
    }

    protected static IStatus createStatusFromDiagnostic(Diagnostic diagnostic) {
        return new Status(diagnostic.getSeverity(), diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException());
    }

    public IStatus run() {
        this.initResourceSet();
        List<ModelExtent> extents = this.getModelExtents();
        String statusMessage = String.format("Import %s", this.getModelName());
        MultiStatus generationStatus = new MultiStatus("org.eclipse.papyrus.interoperability.rpy", 0, statusMessage, null);
        ExecutionContext context = this.createExecutionContext(generationStatus);
        Collection<URI> transformations = this.getDiagramTransformationURIs();
        for (URI transformationURI : transformations) {
            TransformationExecutor executor = new TransformationExecutor(transformationURI);
            ExecutionDiagnostic resultTransdo = executor.execute(context, extents.toArray(new ModelExtent[0]));
            IStatus result = ImportTransformations.createStatusFromDiagnostic((Diagnostic)resultTransdo);
            System.out.print(resultTransdo.getMessage());
            generationStatus.add(result);
        }
        if (generationStatus.getSeverity() <= 2) {
            URI notationModelURI = null;
            URI sashModelURI = null;
            this.targetURI = this.convertToPapyrus(this.sourceURI, "uml");
            notationModelURI = this.convertToPapyrus(this.sourceURI, "notation");
            sashModelURI = this.convertToPapyrus(this.sourceURI, "di");
            this.umlResource = this.createUMLResource((ResourceSet)this.resourceSet, this.sourceURI, this.targetURI);
            List outUMLObjects = this.getInOutUMLModel().getContents();
            this.umlResource.getContents().addAll((Collection)outUMLObjects);
            GMFResource notationResource = new GMFResource(notationModelURI);
            this.resourceSet.getResources().add((Object)notationResource);
            List outNotationObjects = this.getInoutNotationModel().getContents();
            notationResource.getContents().addAll((Collection)outNotationObjects);
            XMIResourceImpl sashResource = new XMIResourceImpl(sashModelURI);
            this.resourceSet.getResources().add((Object)sashResource);
            List sashModelObjects = this.getOutSashModel().getContents();
            sashResource.getContents().addAll((Collection)sashModelObjects);
            this.configureResource((XMIResource)sashResource);
            this.configureResource((XMIResource)notationResource);
            this.configureResource((XMIResource)this.umlResource);
            HashSet<Object> resourcesToSave = new HashSet<Object>();
            resourcesToSave.add(this.umlResource);
            resourcesToSave.add(notationResource);
            resourcesToSave.add(sashResource);
            for (Resource resource : resourcesToSave) {
                try {
                    this.cleanMetadataAnnotations(resource);
                    ResourceAccessHelper.INSTANCE.saveResource(resource, null);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    generationStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.interoperability.rpy", "An exception occurred during save", (Throwable)ex));
                }
            }
        } else {
            System.out.print("can not execute transfo");
        }
        this.unloadResourceSet((ResourceSet)this.resourceSet);
        this.resourceSet = null;
        this.umlResource = null;
        this.primitivesCTypesModel = null;
        this.outUML = null;
        this.outSashModel = null;
        this.outNotation = null;
        return generationStatus;
    }

    protected void configureResource(XMIResource resource) {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        resource.setEncoding("UTF-8");
        resource.getDefaultSaveOptions().putAll(saveOptions);
    }

    public URI getTargetURI() {
        return this.targetURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)this.resourceSet);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
            try {
                this.resourceSet.getResource(this.sourceURI, true);
            }
            catch (Exception ex) {
                Activator.log.error("An error occurred while loading " + this.getModelName(), (Throwable)ex);
            }
            return;
        }
    }

    protected Diagnostic loadInPapyrusProfiles() {
        int code;
        String message;
        if (this.inPapyrusProfiles != null) {
            return Diagnostic.OK_INSTANCE;
        }
        LinkedList missingProfiles = new LinkedList();
        LinkedList allContents = new LinkedList();
        this.inPapyrusProfiles = new BasicModelExtent(allContents);
        if (missingProfiles.isEmpty()) {
            message = "OK";
            code = 0;
        } else {
            message = "The following Papyrus profiles cannot be found: " + ListHelper.deepToString(missingProfiles, (String)", ");
            code = 4;
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(code, "org.eclipse.papyrus.interoperability.rpy", code, message, null);
        return diagnostic;
    }

    protected Diagnostic loadInPapyrusLibraries() {
        int code;
        String message;
        if (this.inPapyrusLibraries != null) {
            return Diagnostic.OK_INSTANCE;
        }
        LinkedList<String> missingLibraries = new LinkedList<String>();
        LinkedList allContents = new LinkedList();
        try {
            URI ancyLib = URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml");
            Resource ancyLibRes = this.resourceSet.getResource(ancyLib, true);
            this.checkResource(ancyLibRes);
            allContents.addAll(ancyLibRes.getContents());
        }
        catch (WrappedException ex) {
            missingLibraries.add("Ancy C Library");
        }
        this.inPapyrusLibraries = new BasicModelExtent(allContents);
        if (missingLibraries.isEmpty()) {
            message = "OK";
            code = 0;
        } else {
            message = "The following Papyrus libraries cannot be found: " + ListHelper.deepToString(missingLibraries, (String)", ");
            code = 4;
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(code, "org.eclipse.papyrus.interoperability.rpy", code, message, null);
        return diagnostic;
    }

    protected void checkResource(Resource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isTrue((!resource.getContents().isEmpty() ? 1 : 0) != 0, (String)("The resource " + resource.getURI() + " is empty"));
        for (EObject rootElement : resource.getContents()) {
            Assert.isTrue((!rootElement.eIsProxy() ? 1 : 0) != 0);
        }
    }

    protected Resource createUMLResource(ResourceSet resourceSet, URI sourceResourceURI, URI targetResourceURI) {
        Resource resource = resourceSet.createResource(targetResourceURI, "org.eclipse.uml2.uml_5_0_0");
        return resource;
    }

    protected URI convertToPapyrus(URI rhpURI, String extension) {
        return rhpURI.trimFileExtension().appendFileExtension(extension);
    }

    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getInRpyModel());
        allExtents.add(this.getInoutNotationModel());
        allExtents.add(this.getInOutUMLModel());
        allExtents.add(this.getPrimitivesCUMLModel());
        allExtents.add(this.getSysML1_1Profile());
        allExtents.add(this.getInUMLPrimitivesTypes());
        return allExtents;
    }

    public ModelExtent getInUMLPrimitivesTypes() {
        URI umlPrimitivesTypesURI = URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
        Resource umlPrimitivesTypesResource = this.resourceSet.getResource(umlPrimitivesTypesURI, true);
        this.umlPrimitivesTypes = new BasicModelExtent((List)umlPrimitivesTypesResource.getContents());
        return this.umlPrimitivesTypes;
    }

    public ModelExtent getInRpyModel() {
        if (this.inRpyModel == null) {
            Resource resource = this.resourceSet.getResource(this.sourceURI, true);
            this.inRpyModel = new BasicModelExtent((List)resource.getContents());
        }
        return this.inRpyModel;
    }

    public ModelExtent getSysML1_1Profile() {
        URI sysMLProfile = URI.createURI((String)"pathmap://SysML_PROFILES/SysML.profile.uml");
        Resource sysProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.sysML11Profile = new BasicModelExtent((List)sysProfile.getContents());
        return this.sysML11Profile;
    }

    public ModelExtent getPrimitivesCUMLModel() {
        URI primitiveTypesURI = URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml");
        Resource primitiveTypes = this.resourceSet.getResource(primitiveTypesURI, true);
        this.primitivesCTypesModel = new BasicModelExtent((List)primitiveTypes.getContents());
        return this.primitivesCTypesModel;
    }

    public ModelExtent getInOutUMLModel() {
        if (this.outUML == null) {
            this.outUML = new BasicModelExtent();
        }
        return this.outUML;
    }

    public ModelExtent getInoutNotationModel() {
        if (this.outNotation == null) {
            this.outNotation = new BasicModelExtent();
        }
        return this.outNotation;
    }

    protected ModelExtent getOutSashModel() {
        if (this.outSashModel == null) {
            this.outSashModel = new BasicModelExtent();
        }
        return this.outSashModel;
    }

    protected Collection<URI> getSemanticTransformationURI() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("Rpy2PapyrusSemanticElements")});
    }

    protected Collection<URI> getDiagramTransformationURIs() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("Rpy2PapyrusNotation")});
    }

    protected URI getTransformationURI(String transformationName) {
        return URI.createPlatformPluginURI((String)String.format("%s/transform/%s.qvto", "org.eclipse.papyrus.interoperability.rpy", transformationName), (boolean)true);
    }

    public String getModelName() {
        return URI.decode((String)this.sourceURI.lastSegment());
    }

    protected ExecutionContext createExecutionContext(final MultiStatus generationStatus) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setLog((Log)new WriterLog(new OutputStreamWriter(System.out)){

            public void log(String message) {
                super.log(message);
            }

            public void log(String message, Object param) {
                super.log(message, param);
            }

            public void log(int level, String message) {
                super.log(level, message);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.interoperability.rpy", message));
                }
            }

            public void log(int level, String message, Object param) {
                super.log(level, message, param);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.interoperability.rpy", String.valueOf(message) + ", data:" + param));
                }
            }
        });
        return context;
    }

    protected void unloadResourceSet(ResourceSet resourceSet) {
        EMFHelper.unload((ResourceSet)resourceSet);
    }

    private void cleanMetadataAnnotations(Resource resource) {
        Iterator rootElementsIterator = resource.getContents().iterator();
        while (rootElementsIterator.hasNext()) {
            EAnnotation annotation;
            EObject root = (EObject)rootElementsIterator.next();
            if (!(root instanceof EAnnotation) || !"http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals((annotation = (EAnnotation)root).getSource())) continue;
            rootElementsIterator.remove();
        }
    }
}

