/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.importer.utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyFileHandler;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyUtil;
import org.eclipse.papyrus.interoperability.rpy.messages.Messages;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeature;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeatureValue;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFile;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNode;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNodeList;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyStringMap;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyStringMapEntry;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.SimpleValueList;

public class RpyProjectHandler {
    private RpyFileHandler projectFile;
    private RpyFileHandler fileTable = null;
    private Map<String, RpyFileHandler> uriToHandler = new HashMap<String, RpyFileHandler>();
    private Map<Resource, RpyFileHandler> resourceToHandlerMap = new HashMap<Resource, RpyFileHandler>();
    private Map<String, String> aliasToPathMap = new HashMap<String, String>();
    private Map<String, RpyNode> idToProxyNode = new HashMap<String, RpyNode>();
    private URI projectURI = null;
    private ResourceSet resSet;
    private URI rpyProjectFolderURI = null;
    private static final String RPY_SUFFIX = "_rpy";
    private static final String FILE_TABLE_NAME = "filesTable.dat";
    private static final String FILE_TABLE_FEATURE_NAME = "filesTable";
    private static final String OM_ROOT = "$OMROOT";

    public RpyFileHandler getProjectFile() {
        return this.projectFile;
    }

    public RpyProjectHandler(URI rpyFileURi) {
        this.initializeExtensions();
        this.resSet = new ResourceSetImpl();
        this.projectURI = rpyFileURi;
        this.projectFile = this.getRpyFileHandler(this.projectURI.toFileString());
        String rpyFolder = String.valueOf(this.projectURI.trimFileExtension().lastSegment()) + RPY_SUFFIX;
        this.rpyProjectFolderURI = this.projectURI.trimSegments(1).appendSegment(rpyFolder).appendSegment("");
        this.loadFileTable();
    }

    public RpyProjectHandler(String rpyPath) {
        this.initializeExtensions();
        this.resSet = new ResourceSetImpl();
        this.projectURI = this.getNormalizedURI(rpyPath);
        this.projectFile = this.getRpyFileHandler(this.projectURI.toFileString());
        String rpyFolder = String.valueOf(this.projectURI.trimFileExtension().lastSegment()) + RPY_SUFFIX;
        this.rpyProjectFolderURI = this.projectURI.trimSegments(1).appendSegment(rpyFolder).appendSegment("");
        this.loadFileTable();
    }

    private void initializeExtensions() {
    }

    private void loadFileTable() {
        URI fileTableURI = this.rpyProjectFolderURI.appendSegment(FILE_TABLE_NAME);
        Resource fileTableRes = this.getResource(fileTableURI);
        if (fileTableRes != null && !fileTableRes.getContents().isEmpty()) {
            RpyFeatureValue value;
            RpyFeature rootFeature;
            this.fileTable = new RpyFileHandler(fileTableRes, this);
            RpyFile rpyTableFile = this.fileTable.getRpyFile();
            if (rpyTableFile != null && !rpyTableFile.getContents().isEmpty() && rpyTableFile.getContents().get(0) instanceof RpyFeature && FILE_TABLE_FEATURE_NAME.equals((rootFeature = (RpyFeature)rpyTableFile.getContents().get(0)).getName()) && rootFeature.getValue() instanceof RpyNodeList && (value = RpyUtil.getFeatureValue(rootFeature)) instanceof RpyStringMap) {
                for (RpyStringMapEntry entry : ((RpyStringMap)value).getEntries()) {
                    if (entry.getValue().isEmpty()) continue;
                    String entryValue = entry.getValue();
                    this.aliasToPathMap.put(entryValue, entry.getKey());
                    if (!entryValue.contains(" ")) continue;
                    this.aliasToPathMap.put(entryValue.replaceAll(" ", "_"), entry.getKey());
                }
            }
        }
    }

    private Resource getResource(URI uri) {
        if (this.resSet.getURIConverter().exists(uri, null)) {
            return this.resSet.getResource(uri, true);
        }
        return null;
    }

    public void loadSubFiles() {
        File rpyProjectFolder = new File(this.rpyProjectFolderURI.toFileString());
        if (rpyProjectFolder.exists() && rpyProjectFolder.isDirectory()) {
            for (File subFile : FileUtils.listFiles((File)rpyProjectFolder, null, (boolean)true)) {
                URI subFileURI = this.getNormalizedURI(subFile.getAbsolutePath());
                if (RpyUtil.SUPPORTED_EXTENSIONS.contains(subFileURI.fileExtension())) {
                    if (FILE_TABLE_NAME.equals(subFileURI.lastSegment())) continue;
                    this.uriToHandler.put(subFileURI.toFileString(), this.getRpyFileHandler(subFileURI.toFileString()));
                    continue;
                }
                Activator.log.info(NLS.bind((String)Messages.RpyProjectHandler_IgnoredSubFile, (Object)subFileURI.toFileString()));
            }
        }
    }

    public URI copyRpyProjectToNewFolder(URI newPath) {
        URI uri = this.projectURI.trimSegments(1);
        File rpyProjectFolder = new File(uri.toFileString());
        ArrayList<File> duplicatedFile = new ArrayList<File>();
        if (rpyProjectFolder.exists() && rpyProjectFolder.isDirectory()) {
            File[] fileArray = rpyProjectFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                duplicatedFile.addAll(this.copyFile(subFile, newPath));
                ++n2;
            }
        }
        for (File current : duplicatedFile) {
            URI newURI = URI.createFileURI((String)current.getPath());
            if (!"rpy".equals(newURI.fileExtension())) continue;
            return newURI;
        }
        return null;
    }

    public List<File> copyFile(File src, URI target) {
        ArrayList<File> duplicatedFile = new ArrayList<File>();
        URI copiedFileURI = URI.createFileURI((String)target.devicePath());
        copiedFileURI = copiedFileURI.appendSegment(src.getName());
        if (src.isDirectory()) {
            File folder = new File(copiedFileURI.devicePath());
            folder.mkdir();
            File[] fileArray = src.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                duplicatedFile.addAll(this.copyFile(f, copiedFileURI));
                ++n2;
            }
        } else {
            File newFile = new File(copiedFileURI.devicePath());
            try {
                Files.copy((File)src, (File)newFile);
                duplicatedFile.add(newFile);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return duplicatedFile;
    }

    private URI getNormalizedURI(String fileString) {
        if (fileString.startsWith(OM_ROOT)) {
            return null;
        }
        fileString = fileString.replaceAll("\\\\\\\\", "\\\\");
        URI uri = URI.createFileURI((String)(fileString = fileString.replaceAll("//", "/")));
        if (uri.isRelative()) {
            uri = uri.resolve(this.rpyProjectFolderURI);
        }
        return this.resSet.getURIConverter().normalize(uri);
    }

    public List<RpyFileHandler> getFiles() {
        ArrayList<RpyFileHandler> ret = new ArrayList<RpyFileHandler>();
        ret.add(this.projectFile);
        ret.addAll(this.uriToHandler.values());
        return ret;
    }

    public RpyFileHandler getOwningFileHandler(RpyNode node) {
        Resource nodeResource = node.eResource();
        return this.resourceToHandlerMap.get(nodeResource);
    }

    public RpyNode getSimpleFeatureReferencedNode(RpyFeature feature) {
        if (RpyUtil.isDirectReference(feature)) {
            RpyFileHandler owningHandler;
            String id = RpyUtil.getStringValue((SimpleValueList)feature.getValue());
            RpyNode owningNode = (RpyNode)feature.eContainer();
            if (owningNode != null && (owningHandler = this.getOwningFileHandler(owningNode)) != null) {
                return owningHandler.getNodeById(id);
            }
        }
        return null;
    }

    public List<RpyNode> getNodes(RpyNodeList nodeList) {
        ArrayList<RpyNode> ret = new ArrayList<RpyNode>();
        for (RpyNode node : nodeList.getValues()) {
            RpyNode referencedNode;
            if (RpyUtil.RAW_CONTAINER_NAME.equals(node.getName())) {
                RpyFeatureValue value = RpyUtil.getNodeFeatureValue(node, "value");
                if (!(value instanceof RpyNodeList)) continue;
                ret.addAll(this.getNodes((RpyNodeList)value));
                continue;
            }
            if (RpyUtil.isRpyIHandle(node)) {
                referencedNode = this.getReferencedNodeFromIHandle(node);
                if (referencedNode == null) continue;
                ret.add(referencedNode);
                continue;
            }
            if (RpyUtil.isElementRef(node)) {
                referencedNode = this.getReferencedNodeFromElementRef(node);
                if (referencedNode == null) continue;
                ret.add(referencedNode);
                continue;
            }
            ret.add(node);
        }
        return ret;
    }

    private RpyNode getReferencedNodeFromElementRef(RpyNode node) {
        String referencedFileName = RpyUtil.getElementFileRef(node);
        if (referencedFileName != null) {
            RpyFileHandler handler;
            URI currentNodeURI;
            if (referencedFileName.isEmpty()) {
                return this.getReferencedNodeInFileHandler(node, this.resourceToHandlerMap.get(node.eResource()), true);
            }
            String persistAt = RpyUtil.getElementPersistAt(node);
            if (persistAt != null) {
                referencedFileName = String.valueOf(persistAt) + "/" + referencedFileName;
                if (!persistAt.startsWith(OM_ROOT)) {
                    currentNodeURI = node.eResource() == this.projectFile.getRpyFile().eResource() ? this.rpyProjectFolderURI : node.eResource().getURI();
                    currentNodeURI = currentNodeURI.trimSegments(1);
                    referencedFileName = String.valueOf(currentNodeURI.toFileString()) + "/" + referencedFileName;
                }
            } else {
                currentNodeURI = node.eResource().getURI();
                String resourceURIString = currentNodeURI.toFileString();
                if (!resourceURIString.startsWith(this.projectFile.getRpyFile().eResource().getURI().trimSegments(1).toFileString())) {
                    referencedFileName = String.valueOf(currentNodeURI.trimSegments(1).toFileString()) + File.separator + referencedFileName;
                }
            }
            if ((handler = this.getRpyFileHandler(referencedFileName)) == null) {
                if (!referencedFileName.startsWith(OM_ROOT)) {
                    String filePathWithWrongRef = node.eResource().getURI().toFileString();
                    Activator.log.error(NLS.bind((String)Messages.RpyProjectHandler_FileNotFoundElementReference, (Object[])new String[]{referencedFileName, RpyUtil.getNodeIndexInFile(node), filePathWithWrongRef}), null);
                }
            } else {
                return this.getReferencedNodeInFileHandler(node, handler, true);
            }
        }
        return null;
    }

    private RpyNode getReferencedNodeFromIHandle(RpyNode handlerNode) {
        String id = RpyUtil.getReferencedID(handlerNode);
        RpyNode proxy = this.idToProxyNode.get(id);
        if (proxy != null) {
            return proxy;
        }
        String filePath = RpyUtil.getIHandleFileRef(handlerNode);
        if (filePath == null) {
            filePath = "";
        }
        if (filePath.isEmpty()) {
            RpyNode localNode = this.getReferencedNodeInFileHandler(handlerNode, this.resourceToHandlerMap.get(handlerNode.eResource()), false);
            if (localNode != null) {
                return localNode;
            }
            localNode = this.getReferencedNodeInFileHandler(handlerNode, this.projectFile, false);
            if (localNode != null) {
                return localNode;
            }
        } else {
            RpyNode referencedNode;
            RpyFileHandler fileHandler = this.getRpyFileHandler(filePath);
            if (fileHandler != null && (referencedNode = this.getReferencedNodeInFileHandler(handlerNode, fileHandler, false)) != null) {
                return referencedNode;
            }
        }
        String referencedSubsystem = RpyUtil.getReferencedSubsystemFromHandle(handlerNode);
        String referencedClass = RpyUtil.getReferencedClassFromHandle(handlerNode);
        String referencedName = RpyUtil.getReferencedNameFromHandle(handlerNode);
        ArrayList<String> namesToTry = new ArrayList<String>();
        String referencedQN = "";
        if (referencedSubsystem != null) {
            namesToTry.add(referencedSubsystem);
            referencedQN = String.valueOf(referencedQN) + referencedSubsystem;
        }
        if (referencedClass != null) {
            if (referencedSubsystem == null) {
                namesToTry.add(referencedClass);
            } else {
                referencedQN = String.valueOf(referencedQN) + "::" + referencedClass;
                namesToTry.add(referencedQN);
            }
        }
        if (referencedName != null) {
            if (referencedQN.isEmpty()) {
                namesToTry.add(referencedName);
            } else {
                referencedQN = String.valueOf(referencedQN) + "::" + referencedName;
                namesToTry.add(referencedQN);
            }
        }
        for (String nameToTry : namesToTry) {
            filePath = this.aliasToPathMap.get(nameToTry);
            if (filePath == null) continue;
            RpyFileHandler fileHandler = this.getRpyFileHandler(filePath = "../" + filePath);
            if (fileHandler != null) {
                RpyNode result = this.getReferencedNodeInFileHandler(handlerNode, fileHandler, false);
                if (result == null) continue;
                return result;
            }
            this.logFileNodeFound(handlerNode, filePath);
        }
        proxy = RpyUtil.createProxyNodeFromHandler(handlerNode);
        if (proxy != null) {
            this.idToProxyNode.put(id, proxy);
        }
        return proxy;
    }

    private void logFileNodeFound(RpyNode node, String filePath) {
        String filePathWithWrongRef = node.eResource().getURI().toFileString();
        Activator.log.error(NLS.bind((String)Messages.RpyProjectHandler_FileNotFoundHandleReference, (Object[])new String[]{filePath, RpyUtil.getNodeIndexInFile(node), filePathWithWrongRef}), null);
    }

    private RpyFileHandler getRpyFileHandler(String uriString) {
        boolean isExternal = uriString.startsWith(OM_ROOT);
        URI referencedURI = this.getNormalizedURI(uriString);
        if (referencedURI != null) {
            Resource resource;
            RpyFileHandler result = this.uriToHandler.get(referencedURI.toFileString());
            if (result == null && (resource = this.getResource(referencedURI)) != null) {
                result = new RpyFileHandler(resource, this);
                this.uriToHandler.put(referencedURI.toFileString(), result);
                this.resourceToHandlerMap.put(resource, result);
            }
            return result;
        }
        return null;
    }

    private RpyNode getReferencedNodeInFileHandler(RpyNode node, RpyFileHandler handler, boolean log) {
        String id = RpyUtil.getReferencedID(node);
        RpyNode referencedNode = null;
        if (id != null) {
            referencedNode = handler.getNodeById(id);
        }
        if (referencedNode != null && RpyUtil.isElementRef(referencedNode)) {
            return this.getReferencedNodeFromElementRef(referencedNode);
        }
        if (referencedNode == null && log) {
            this.logIDNotFound(handler, node);
        }
        return referencedNode;
    }

    private void logIDNotFound(RpyFileHandler handler, RpyNode node) {
        String id = RpyUtil.getReferencedID(node);
        String filePathWithWrongRef = node.eResource().getURI().toFileString();
        Activator.log.error(NLS.bind((String)Messages.RpyProjectHandler_NotFoundIDReference, (Object[])new String[]{id, handler.getRpyFile().eResource().getURI().toFileString(), RpyUtil.getNodeIndexInFile(node), filePathWithWrongRef}), null);
    }

    public Collection<RpyNode> getAllProxies() {
        return this.idToProxyNode.values();
    }
}

