/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.interoperability.rpy.importer.UMLRpyImporter;

public class SelectedRpyFilesImporter {
    private Collection<URI> userSelectedFilesURI;
    public static final String OUTPUT_FOLDER = "output";

    public SelectedRpyFilesImporter(Collection<URI> userSelectedFilesURI) {
        this.userSelectedFilesURI = userSelectedFilesURI;
    }

    public List<URI> getRpyFilesToImportURI() {
        Iterator<URI> iter = this.userSelectedFilesURI.iterator();
        HashSet<URI> urisToImport = new HashSet<URI>();
        while (iter.hasNext()) {
            URI selectedURI = iter.next();
            String fileExtension = selectedURI.fileExtension();
            if ("umlrpy".equals(fileExtension)) {
                urisToImport.add(selectedURI);
                continue;
            }
            if (!"rpy".equals(fileExtension)) continue;
            IFile res = FileUtil.getIFile((String)selectedURI.toPlatformString(true));
            IProject project = res.getProject();
            String projectinput = project.getLocation().toOSString();
            String projectOutput = this.getOutputFolderPath(selectedURI);
            UMLRpyImporter importer = new UMLRpyImporter(res.getLocation().toOSString(), projectOutput);
            importer.getRootProject();
            importer.save();
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            URI rpyEMFFileURI = this.getResultingUMLRpyFileURI(selectedURI);
            urisToImport.add(rpyEMFFileURI);
        }
        return new ArrayList<URI>(urisToImport);
    }

    public String getOutputFolderPath(URI inputURI) {
        IFile res = FileUtil.getIFile((String)inputURI.toPlatformString(true));
        IProject project = res.getProject();
        URI projectURI = URI.createPlatformResourceURI((String)project.getLocation().toPortableString(), (boolean)true);
        String lastSegment = inputURI.trimFileExtension().lastSegment();
        return projectURI.appendSegment(OUTPUT_FOLDER).appendSegment(lastSegment).toPlatformString(true);
    }

    public URI getResultingUMLRpyFileURI(URI inputURI) {
        String str = this.getOutputFolderPath(inputURI);
        IFile file = FileUtil.getIFile((String)str);
        URI projectURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        String fileName = inputURI.lastSegment();
        return projectURI.appendSegment(fileName).trimFileExtension().appendFileExtension("umlrpy");
    }
}

