/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>IExecution Occurrence</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getM_startMessage <em>Mstart Message</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getM_endMessage <em>Mend Message</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getM_length <em>Mlength</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIExecutionOccurrence()
 * @model
 * @generated
 */
public interface IExecutionOccurrence extends IModelElement {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIExecutionOccurrence_Id()
	 * @model
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Mstart Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mstart Message</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mstart Message</em>' reference.
	 * @see #setM_startMessage(IMessage)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIExecutionOccurrence_M_startMessage()
	 * @model
	 * @generated
	 */
	IMessage getM_startMessage();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getM_startMessage <em>Mstart Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mstart Message</em>' reference.
	 * @see #getM_startMessage()
	 * @generated
	 */
	void setM_startMessage(IMessage value);

	/**
	 * Returns the value of the '<em><b>Mend Message</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UnknownType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mend Message</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mend Message</em>' reference list.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIExecutionOccurrence_M_endMessage()
	 * @model
	 * @generated
	 */
	EList<UnknownType> getM_endMessage();

	/**
	 * Returns the value of the '<em><b>Mlength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mlength</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mlength</em>' attribute.
	 * @see #setM_length(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIExecutionOccurrence_M_length()
	 * @model
	 * @generated
	 */
	String getM_length();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence#getM_length <em>Mlength</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mlength</em>' attribute.
	 * @see #getM_length()
	 * @generated
	 */
	void setM_length(String value);

} // IExecutionOccurrence
