/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.RunnableWithResult;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.transformation.core.sync.DepPlanSync;
import org.eclipse.papyrus.designer.transformation.core.sync.InterfaceSync;
import org.eclipse.papyrus.designer.transformation.ui.Messages;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class SyncHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            return true;
        }
        return this.selectedEObject instanceof Package;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof Property) {
            this.selectedEObject = ((Property)this.selectedEObject).getType();
        }
        if (this.selectedEObject instanceof Interface) {
            final Interface selectedIntf = (Interface)this.selectedEObject;
            CommandSupport.exec((String)"Synchronize interface", (ExecutionEvent)event, (Runnable)new Runnable(){

                @Override
                public void run() {
                    InterfaceSync.syncSignalReceptionSupport((Interface)selectedIntf);
                }
            });
        }
        if (this.selectedEObject instanceof Package) {
            final Package selectedPkg = (Package)this.selectedEObject;
            CommandSupport.exec((String)"Synchronize deployment plan", (ExecutionEvent)event, (RunnableWithResult)new RunnableWithResult(){

                public CommandResult run() {
                    try {
                        DepPlanSync.syncDepPlan((Package)selectedPkg);
                        return CommandResult.newOKCommandResult();
                    }
                    catch (TransformationRTException e) {
                        Shell shell = Display.getCurrent().getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)Messages.SyncHandler_CANNOT_SYNCHRONIZE, (String)e.getMessage());
                        return CommandResult.newErrorCommandResult((String)e.getMessage());
                    }
                }
            });
        }
        return null;
    }
}

