/**
 * Copyright (c) 2021 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StringConstants;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.InstrumentCTF;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.ModelQNames;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@SuppressWarnings("all")
public class InitCTF {
  /**
   * Copy a file from the code folder (in the tracing plugin) into the
   * passed target folder
   * @param fileName the name of the file to copy
   * @param targetFolder the target folder
   */
  public static boolean copyCode(final String fileName, final IFolder targetFolder) {
    try {
      boolean _xblockexpression = false;
      {
        final Bundle bundle = FrameworkUtil.getBundle(InstrumentCTF.class);
        final String codeFolder = "code/";
        final URL inputURL = bundle.getResource((codeFolder + fileName));
        final IFile createdFile = targetFolder.getFile(fileName);
        boolean _exists = createdFile.exists();
        if (_exists) {
          createdFile.setContents(inputURL.openStream(), true, true, null);
        } else {
          createdFile.create(inputURL.openStream(), true, null);
        }
        _xblockexpression = TransformationContext.current.keepFiles.add(createdFile.getFullPath().toString());
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * copy platform files into srcCTF folder and create an instance for the
   * BareCTFInit class.
   */
  public static boolean initCode(final IFolder srcCTF, final org.eclipse.uml2.uml.Package cdp) {
    try {
      boolean _xblockexpression = false;
      {
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(cdp, ModelQNames.BareCTFInit);
        Classifier initCl = ((Classifier) _qualifiedElementFromRS);
        if ((initCl != null)) {
          final InstanceSpecification is = UMLFactory.eINSTANCE.createInstanceSpecification();
          final Classifier ctfInitCopy = TransformationContext.current.copier.<Classifier>getCopy(initCl);
          final Property metadataPath = ctfInitCopy.getAttribute("metadataPath", null);
          ValueSpecification _createDefaultValue = metadataPath.createDefaultValue(null, metadataPath.getType(), 
            UMLPackage.eINSTANCE.getLiteralString());
          final LiteralString defaultVal = ((LiteralString) _createDefaultValue);
          String _file = FileLocator.resolve(TransformationContext.current.project.getLocationURI().toURL()).getFile();
          String projectFN = (_file + "/src-gen/ctf/metadata");
          boolean _equals = Objects.equal(File.separator, StringConstants.BSLASH);
          if (_equals) {
            boolean _startsWith = projectFN.startsWith(StringConstants.SLASH);
            if (_startsWith) {
              projectFN = projectFN.substring(1);
            }
            projectFN = projectFN.replace(StringConstants.SLASH, 
              (StringConstants.BSLASH + StringConstants.BSLASH));
          }
          defaultVal.setValue(StringUtils.quote(projectFN));
          is.setName("ctfInit");
          is.getClassifiers().add(ctfInitCopy);
          cdp.getPackagedElements().add(is);
        }
        final String platformFile = "barectf-platform-fs";
        InitCTF.copyCode((platformFile + ".h"), srcCTF);
        InitCTF.copyCode((platformFile + ".c"), srcCTF);
        final String initCode = "barectf-init";
        InitCTF.copyCode((initCode + ".h"), srcCTF);
        _xblockexpression = InitCTF.copyCode((initCode + ".c"), srcCTF);
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
