/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.mappingrules;

import java.util.Iterator;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.fcm.profile.IMappingRule;
import org.eclipse.papyrus.designer.components.fcm.profile.utils.PortMapUtil;
import org.eclipse.papyrus.designer.components.modellibs.core.mappingrules.AMIpoll;
import org.eclipse.papyrus.designer.transformation.base.utils.RealizationUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class AMIcallback
implements IMappingRule {
    private static final String _REPLY = "_reply_";
    private static final String _REQUEST = "_request_";
    private static final String AMI_CB = "AMI_CB";

    public Type calcDerivedType(Port p, boolean update) {
        String name;
        Object name2;
        Type type = p.getType();
        if (!(type instanceof Interface)) {
            return null;
        }
        Interface typingInterface = (Interface)type;
        Class derivedType = PortMapUtil.getDerivedClass((Port)p, (String)AMI_CB);
        Interface derivedRequestInterface = PortMapUtil.getDerivedInterface((Port)p, (String)_REQUEST);
        Interface derivedReplyInterface = PortMapUtil.getDerivedInterface((Port)p, (String)_REPLY);
        RealizationUtils.addUsage((Class)derivedType, (Interface)derivedRequestInterface);
        RealizationUtils.addRealization((Class)derivedType, (Interface)derivedReplyInterface);
        if (!update) {
            return derivedType;
        }
        for (Operation operation : typingInterface.getOwnedOperations()) {
            Type paramType;
            Object paramName;
            name2 = operation.getName();
            Operation derivedOperation = derivedRequestInterface.getOperation((String)name2, null, null);
            if (derivedOperation == null) {
                derivedOperation = derivedRequestInterface.createOwnedOperation((String)name2, null, null);
            }
            for (Parameter parameter : operation.getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL && parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL || derivedOperation.getOwnedParameter((String)(paramName = parameter.getName()), paramType = parameter.getType()) != null) continue;
                Parameter newParameter = derivedOperation.createOwnedParameter(parameter.getName(), parameter.getType());
                newParameter.setDirection(parameter.getDirection());
                newParameter.setLower(parameter.getLower());
                newParameter.setUpper(parameter.getUpper());
            }
            Iterator derivedParameters = derivedOperation.getOwnedParameters().iterator();
            while (derivedParameters.hasNext()) {
                Parameter parameter = (Parameter)derivedParameters.next();
                paramName = parameter.getName();
                if (operation.getOwnedParameter((String)paramName, paramType = parameter.getType()) != null) continue;
                derivedParameters.remove();
            }
        }
        Iterator derivedRequestOperations = derivedRequestInterface.getOwnedOperations().iterator();
        while (derivedRequestOperations.hasNext()) {
            Operation derivedOperation = (Operation)derivedRequestOperations.next();
            name2 = derivedOperation.getName();
            if (name2 == null || typingInterface.getOperation((String)name2, null, null) != null) continue;
            derivedRequestOperations.remove();
        }
        for (Operation operation : typingInterface.getOwnedOperations()) {
            Type paramType;
            String paramName;
            name = operation.getName();
            if (!AMIpoll.hasOutParameters(operation)) continue;
            Operation derivedOperation = derivedReplyInterface.getOperation(name, null, null);
            if (derivedOperation == null) {
                derivedOperation = derivedReplyInterface.createOwnedOperation(name, null, null);
            }
            for (Parameter parameter : operation.getOwnedParameters()) {
                if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL || derivedOperation.getOwnedParameter(paramName = parameter.getName(), paramType = parameter.getType()) != null) continue;
                Parameter newParameter = derivedOperation.createOwnedParameter(parameter.getName(), parameter.getType());
                newParameter.setDirection(ParameterDirectionKind.IN_LITERAL);
                newParameter.setLower(parameter.getLower());
                newParameter.setUpper(parameter.getUpper());
            }
            Iterator derivedParameters = derivedOperation.getOwnedParameters().iterator();
            while (derivedParameters.hasNext()) {
                Parameter parameter = (Parameter)derivedParameters.next();
                paramName = parameter.getName();
                if (operation.getOwnedParameter(paramName, paramType = parameter.getType()) != null) continue;
                derivedParameters.remove();
            }
        }
        Iterator derivedReplyOperations = derivedReplyInterface.getOwnedOperations().iterator();
        while (derivedRequestOperations.hasNext()) {
            Operation derivedOperation = (Operation)derivedReplyOperations.next();
            name = derivedOperation.getName();
            if (name == null || typingInterface.getOperation(name, null, null) != null) continue;
            derivedReplyOperations.remove();
        }
        return derivedType;
    }

    public boolean needsUpdate(Port p) {
        return this.calcDerivedType(p, false) == null;
    }
}

