/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.ecore.pycpa.tests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.designer.realtime.pycpa.ecore.pycpa.PyCPAFactory;
import org.eclipse.papyrus.designer.realtime.pycpa.ecore.pycpa.PyCPAPackage;
import org.eclipse.papyrus.designer.realtime.pycpa.ecore.pycpa.System;

public class PyCPAExample {
    public static void main(String[] args) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://designer.papyrus.eclipse.org/realtime/pycpa/0.1", (Object)PyCPAPackage.eINSTANCE);
        if (args.length == 0) {
            java.lang.System.out.println("Enter a list of file paths or URIs that have content like this:");
            try {
                Resource resource = resourceSet.createResource(URI.createURI((String)"http:///My.pycpa"));
                System root = PyCPAFactory.eINSTANCE.createSystem();
                resource.getContents().add((Object)root);
                resource.save((OutputStream)java.lang.System.out, null);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < args.length) {
                File file = new File(args[i]);
                URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)args[i]);
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    java.lang.System.out.println("Loaded " + uri);
                    for (EObject eObject : resource.getContents()) {
                        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                        if (diagnostic.getSeverity() == 0) continue;
                        PyCPAExample.printDiagnostic(diagnostic, "");
                    }
                }
                catch (RuntimeException exception) {
                    java.lang.System.out.println("Problem loading " + uri);
                    exception.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        java.lang.System.out.print(indent);
        java.lang.System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            PyCPAExample.printDiagnostic(child, String.valueOf(indent) + "  ");
        }
    }
}

