/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.preferences;

import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.monitoring.sm.Activator;

public class MonitoringPreferencesUtil {
    protected static IPreferenceStore preferenceStore = null;
    private static final Pattern IP_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public static void initPreferenceStore() {
        if (preferenceStore == null) {
            preferenceStore = Activator.getDefault().getPreferenceStore();
        }
    }

    public static String getIpAddress() {
        MonitoringPreferencesUtil.initPreferenceStore();
        String ip = preferenceStore.getString("papyrusMonitorIpAddress");
        if (!MonitoringPreferencesUtil.validate(ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static int getPort() {
        MonitoringPreferencesUtil.initPreferenceStore();
        int port = preferenceStore.getInt("papyrusMonitorPort");
        if (port <= 0) {
            port = 4445;
        }
        return port;
    }

    public static boolean getEnabled() {
        MonitoringPreferencesUtil.initPreferenceStore();
        return preferenceStore.getBoolean("papyrusMonitorEnabled");
    }

    private static boolean validate(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }
}

