/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import org.eclipse.uml2.uml.NamedElement;

public class StringUtils {
    public static final int TABSIZE = 4;

    public static String quote(String str) {
        if (str.startsWith("\"")) {
            return str;
        }
        return "\"" + str + "\"";
    }

    public static String unquote(String str) {
        if (str.startsWith("\"") && str.length() >= 2) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String varName(String aName) {
        aName = aName.replace(".", "_");
        aName = aName.replace("::", "_");
        return StringUtils.varName2(aName);
    }

    public static String varName2(NamedElement element) {
        String umlName = element.getName();
        return StringUtils.varName2(umlName);
    }

    public static String varName2(String aName) {
        aName = aName.replace(" ", "_");
        aName = aName.replace("-", "_");
        aName = aName.replace("+", "_");
        aName = aName.replace("?", "_");
        return aName;
    }

    public static String upperCaseFirst(String str) {
        if (str.length() > 0) {
            return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
        }
        return str;
    }

    public static String decreaseIndent(char[] contents, int start, int end, int indentation) {
        String newBlock = "";
        int consume = indentation;
        int i = start;
        while (i < end) {
            char c = contents[i];
            if (consume > 0 && Character.isWhitespace(c)) {
                if (c == '\t') {
                    consume -= 4;
                }
                if (c == ' ') {
                    --consume;
                }
            } else {
                newBlock = String.valueOf(newBlock) + c;
                consume = c == '\n' || c == '\r' ? indentation : 0;
            }
            ++i;
        }
        return newBlock;
    }
}

