/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.test.editor.EcoreTestFile;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EcoreTestFileBase
implements EcoreTestFile {
    private final IFile file;
    private final URI uri;
    private final Resource resource;
    private FileEditorInput fileEditorInput = null;

    public EcoreTestFileBase(IFile file) {
        this.file = file;
        this.uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.resource = resourceSet.createResource(this.uri);
    }

    @Override
    public EClass createEClass(EPackage ePackage, String name) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        if (ePackage != null) {
            ePackage.getEClassifiers().add((Object)eClass);
        }
        return eClass;
    }

    @Override
    public EPackage createEPackage(EPackage parentPackage, String name) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        if (parentPackage == null) {
            this.resource.getContents().add((Object)ePackage);
        } else {
            parentPackage.getESubpackages().add((Object)ePackage);
        }
        return ePackage;
    }

    public IFileEditorInput getEditorInput() throws IOException {
        if (this.fileEditorInput == null) {
            this.resource.save(null);
            this.fileEditorInput = new FileEditorInput(this.file);
        }
        return this.fileEditorInput;
    }

    public EClass getEClass(ResourceSet resourceSet, EClass initClass) {
        EPackage ePackage = this.getEPackage(resourceSet, initClass.getEPackage());
        return (EClass)ePackage.getEClassifier(initClass.getName());
    }

    public EPackage getEPackage(ResourceSet resourceSet, EPackage initPackage) {
        Resource resource = this.getResource(resourceSet, initPackage.eResource());
        String name = initPackage.getName();
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            if (name == null || !name.equals(ePackage.getName())) continue;
            return ePackage;
        }
        return null;
    }

    public Collection<EPackage> getEPackages() {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        for (EObject eObject : this.resource.getContents()) {
            if (!(eObject instanceof EPackage)) continue;
            ePackages.add((EPackage)eObject);
        }
        return ePackages;
    }

    public IFile getFile() {
        return this.file;
    }

    public Resource getResource(ResourceSet resourceSet, Resource initResource) {
        URI uri2 = initResource.getURI();
        return resourceSet.getResource(uri2, false);
    }

    public String getURI() {
        return this.uri.toString();
    }

    public ResourceSet reload() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResource(this.uri, true);
        return resourceSet;
    }
}

