/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.tests.GenericEvaluationTestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericEvaluationStringOperationTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericEvaluationTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    public void testStringAt() {
        this.assertResult("t", "'test'.at(1)");
        this.assertResult("e", "'test'.at(2)");
        this.assertResult("t", "'test'.at(4)");
        this.assertResultInvalid("'test'.at(0)");
        this.assertResultInvalid("'test'.at(5)");
        this.assertResultInvalid("''.at(1)");
        this.assertResultInvalid("let s : String = invalid in s.at(1)");
        this.assertResultInvalid("let s : String = null in s.at(1)");
    }

    private List<String> buildString(String ... strings) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = 0;
            while (i < s.length()) {
                result.add(s.substring(i, i + 1));
                ++i;
            }
            ++n2;
        }
        return result;
    }

    public void testStringCharacters() {
        this.assertResult(this.buildString(new String[0]), "''.characters()");
        this.assertResult(this.buildString("a"), "'a'.characters()");
        this.assertResult(this.buildString("a", "\r", "\n", "b"), "'a\\r\\nb'.characters()");
        this.assertResultInvalid("let s : String = invalid in s.characters()");
        this.assertResultInvalid("let s : String = null in s.characters()");
    }

    public void testStringConcat() {
        this.assertResult("concatenationTest", "'concatenation'.concat('Test')");
        this.assertResult("concatenation\n", "'concatenation'.concat('\\n')");
        this.assertResult("concatenationTest", "'concatenation' + 'Test'");
        this.assertResult("concatenation\n", "'concatenation' + '\\n'");
    }

    public void testStringConcatInvalid() {
        this.assertResultInvalid("let s : String = invalid in 'concatenation'.concat(s)");
        this.assertResultInvalid("let s : String = invalid in s.concat('concatenation')");
        this.assertResultInvalid("let s : String = invalid in 'concatenation' + s");
        this.assertResultInvalid("let s : String = invalid in s + 'concatenation'");
    }

    public void testStringConcatNull() {
        this.assertResultInvalid("let s : String = null in 'concatenation'.concat(s)");
        this.assertResultInvalid("let s : String = null in s.concat('concatenation')");
        this.assertResultInvalid("let s : String = null in 'concatenation' + s");
        this.assertResultInvalid("let s : String = null in s + 'concatenation'");
    }

    public void testStringEndsWith() {
        this.assertResultFalse("'abcdef'.endsWith('aabcdef')");
        this.assertResultTrue("'abcdef'.endsWith('abcdef')");
        this.assertResultTrue("'abcdef'.endsWith('cdef')");
        this.assertResultTrue("'abcdef'.endsWith('f')");
        this.assertResultTrue("'abcdef'.endsWith('')");
        this.assertResultTrue("''.endsWith('')");
        this.assertResultFalse("''.endsWith('a')");
        this.assertResultTrue("'abcdef'.endsWith('')");
        this.assertResultFalse("'abcdef'.endsWith('bcd')");
        this.assertResultFalse("'abcdef'.endsWith('ab')");
        this.assertResultFalse("'abcdef'.endsWith('a')");
        this.assertResultInvalid("let s : String = invalid in s.endsWith('')");
        this.assertResultInvalid("let s : String = invalid in ''.endsWith(s)");
        this.assertResultInvalid("let s : String = null in s.endsWith('')");
        this.assertResultInvalid("let s : String = null in ''.endsWith(s)");
    }

    public void testStringEqual() {
        this.assertResultFalse("'test' = 'se'");
        this.assertResultTrue("'test' = 'test'");
    }

    public void testStringEqualInvalid() {
        this.assertResultInvalid("let s : String = invalid in s = 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' = s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 = s2");
    }

    public void testStringEqualNull() {
        this.assertResultFalse("let s : String = null in s = 'se'");
        this.assertResultFalse("let s : String = null in 'test' = s");
        this.assertResultTrue("let s1 : String = null, s2 : String = null in s1 = s2");
    }

    public void testStringEqualIgnoresCase() {
        this.assertResultFalse("'test'.equalsIgnoreCase('se')");
        this.assertResultTrue("'test'.equalsIgnoreCase('test')");
        this.assertResultTrue("'Test'.equalsIgnoreCase('tEst')");
        this.assertResultTrue("'tesT'.equalsIgnoreCase('teSt')");
        this.assertResultTrue("'TEST'.equalsIgnoreCase('test')");
        this.assertResultTrue("'test'.equalsIgnoreCase('TEST')");
    }

    public void testStringGreaterThan() {
        this.assertResultFalse("'3' > '4'");
        this.assertResultFalse("'a' > 'b'");
        this.assertResultFalse("'aardvark' > 'aardvarks'");
        this.assertResultTrue("'3.2' > '3.1'");
        this.assertResultTrue("'a' > 'A'");
        this.assertResultTrue("'aardvark' > 'aardvarK'");
        this.assertResultFalse("'3' > '3'");
        this.assertResultFalse("'a' > 'a'");
        this.assertResultFalse("'aardvark' > 'aardvark'");
    }

    public void testStringGreaterThanInvalid() {
        this.assertResultInvalid("let s : String = invalid in s > 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' > s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 > s2");
    }

    public void testStringGreaterThanNull() {
        this.assertResultInvalid("let s : String = null in s > 'se'");
        this.assertResultInvalid("let s : String = null in 'test' > s");
        this.assertResultInvalid("let s1 : String = null, s2 : String = null in s1 > s2");
    }

    public void testStringGreaterThanOrEqual() {
        this.assertResultFalse("'3' >= '4'");
        this.assertResultFalse("'a' >= 'b'");
        this.assertResultFalse("'aardvark' >= 'aardvarks'");
        this.assertResultTrue("'3.2' >= '3.1'");
        this.assertResultTrue("'a' >= 'A'");
        this.assertResultTrue("'aardvark' >= 'aardvarK'");
        this.assertResultTrue("'3' >= '3'");
        this.assertResultTrue("'a' >= 'a'");
        this.assertResultTrue("'aardvark' >= 'aardvark'");
    }

    public void testStringGreaterThanOrEqualInvalid() {
        this.assertResultInvalid("let s : String = invalid in s >= 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' >= s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 >= s2");
    }

    public void testStringGreaterThanOrEqualNull() {
        this.assertResultInvalid("let s : String = null in s >= 'se'");
        this.assertResultInvalid("let s : String = null in 'test' >= s");
        this.assertResultInvalid("let s1 : String = null, s2 : String = null in s1 >= s2");
    }

    public void testStringIndexOf() {
        this.assertResult(1, "'test'.indexOf('t')");
        this.assertResult(1, "'test'.indexOf('te')");
        this.assertResult(2, "'test'.indexOf('es')");
        this.assertResult(3, "'test'.indexOf('st')");
        this.assertResult(5, "'tesla'.indexOf('a')");
        this.assertResult(0, "'test'.indexOf('xyzzy')");
        this.assertResult(0, "'test'.indexOf('est2')");
        this.assertResult(1, "'test'.indexOf('')");
        this.assertResult(1, "''.indexOf('')");
        this.assertResult(0, "''.indexOf('t')");
        this.assertResultInvalid("let s : String = invalid in 'test'.indexOf(s)");
        this.assertResultInvalid("let s : String = invalid in s.indexOf('s')");
        this.assertResultInvalid("let s : String = null in 'test'.indexOf(s)");
        this.assertResultInvalid("let s : String = null in s.indexOf('s')");
    }

    public void testStringLastIndexOf() {
        this.assertResult(4, "'test'.lastIndexOf('t')");
        this.assertResult(1, "'test'.lastIndexOf('te')");
        this.assertResult(2, "'test'.lastIndexOf('es')");
        this.assertResult(3, "'test'.lastIndexOf('st')");
        this.assertResult(5, "'tesla'.lastIndexOf('a')");
        this.assertResult(1, "'ates'.lastIndexOf('a')");
        this.assertResult(0, "'test'.lastIndexOf('xyzzy')");
        this.assertResult(0, "'test'.lastIndexOf('est2')");
        this.assertResult(5, "'test'.lastIndexOf('')");
        this.assertResult(1, "''.lastIndexOf('')");
        this.assertResult(0, "''.lastIndexOf('t')");
        this.assertResultInvalid("let s : String = invalid in 'test'.lastIndexOf(s)");
        this.assertResultInvalid("let s : String = invalid in s.lastIndexOf('s')");
        this.assertResultInvalid("let s : String = null in 'test'.lastIndexOf(s)");
        this.assertResultInvalid("let s : String = null in s.lastIndexOf('s')");
    }

    public void testStringLessThan() {
        this.assertResultTrue("'3' < '4'");
        this.assertResultTrue("'a' < 'b'");
        this.assertResultTrue("'aardvark' < 'aardvarks'");
        this.assertResultFalse("'3.2' < '3.1'");
        this.assertResultFalse("'a' < 'A'");
        this.assertResultFalse("'aardvark' < 'aardvarK'");
        this.assertResultFalse("'3' < '3'");
        this.assertResultFalse("'a' < 'a'");
        this.assertResultFalse("'aardvark' < 'aardvark'");
    }

    public void testStringLessThanInvalid() {
        this.assertResultInvalid("let s : String = invalid in s < 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' < s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 < s2");
    }

    public void testStringLessThanNull() {
        this.assertResultInvalid("let s : String = null in s < 'se'");
        this.assertResultInvalid("let s : String = null in 'test' < s");
        this.assertResultInvalid("let s1 : String = null, s2 : String = null in s1 < s2");
    }

    public void testStringLessThanOrEqual() {
        this.assertResultTrue("'3' <= '4'");
        this.assertResultTrue("'a' <= 'b'");
        this.assertResultTrue("'aardvark' <= 'aardvarks'");
        this.assertResultFalse("'3.2' <= '3.1'");
        this.assertResultFalse("'a' <= 'A'");
        this.assertResultFalse("'aardvark' <= 'aardvarK'");
        this.assertResultTrue("'3' <= '3'");
        this.assertResultTrue("'a' <= 'a'");
        this.assertResultTrue("'aardvark' <= 'aardvark'");
    }

    public void testStringLessThanOrEqualInvalid() {
        this.assertResultInvalid("let s : String = invalid in s <= 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' <= s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 <= s2");
    }

    public void testStringLessThanOrEqualNull() {
        this.assertResultInvalid("let s : String = null in s <= 'se'");
        this.assertResultInvalid("let s : String = null in 'test' <= s");
        this.assertResultInvalid("let s1 : String = null, s2 : String = null in s1 <= s2");
    }

    public void testStringMatches() {
        this.assertResultTrue("'characters and spaces'.matches('[\\\\w\\\\s]+')");
        this.assertResultFalse("'characters and 3 digits'.matches('[\\\\p{Alpha}\\\\s]+')");
        this.assertResultTrue("''.matches('')");
        this.assertResultTrue("''.matches('')");
        this.assertResultFalse("'a'.matches('')");
        this.assertResultFalse("''.matches('b')");
        this.assertResultInvalid("'repla ce operation'.matches('a[b-')");
        this.assertResultInvalid("null.matches('(\\\\w+)\\\\s*')");
        this.assertResultInvalid("'repla ce operation'.matches(null)");
        this.assertResultInvalid("invalid.matches('(\\\\w+)\\\\s*')");
        this.assertResultInvalid("'repla ce operation'.matches(invalid)");
        this.assertQueryEquals(null, 50, "let seq : Sequence(Integer) = Sequence{1..20}, rseq : Sequence(Integer) = seq->collect(i | 21-i), seqs : Sequence(Integer) = Sequence{seq,rseq,seq,rseq,seq}->flatten() in seqs->iterate(i; acc : Integer = 0 | if '123456789'.matches('.*' + i.toString() + '.*') then acc + 1 else acc endif)");
    }

    public void testStringNotEqual() {
        this.assertResultTrue("'test' <> 'se'");
        this.assertResultFalse("'test' <> 'test'");
    }

    public void testStringNotEqualInvalid() {
        this.assertResultInvalid("let s : String = invalid in s <> 'se'");
        this.assertResultInvalid("let s : String = invalid in 'test' <> s");
        this.assertResultInvalid("let s1 : String = invalid, s2 : String = invalid in s1 <> s2");
    }

    public void testStringNotEqualNull() {
        this.assertResultTrue("let s : String = null in s <> 'se'");
        this.assertResultTrue("let s : String = null in 'test' <> s");
        this.assertResultFalse("let s1 : String = null, s2 : String = null in s1 <> s2");
    }

    public void testStringOclAsType() {
        this.assertResultInvalid("'test'.oclAsType(Integer)");
        this.assertResult("test", "'test'.oclAsType(String)");
        this.assertResult("test", "'test'.oclAsType(OclAny)");
        this.assertResultInvalid("'test'.oclAsType(OclVoid)");
        this.assertResultInvalid("'test'.oclAsType(OclInvalid)");
    }

    public void testStringOclIsInvalid() {
        this.assertResultFalse("'test'.oclIsInvalid()");
        this.assertResultFalse("''.oclIsInvalid()");
    }

    public void testStringOclIsUndefined() {
        this.assertResultFalse("'test'.oclIsUndefined()");
        this.assertResultFalse("''.oclIsUndefined()");
    }

    public void testStringPlus() {
        this.assertResult("concatenationTest", "'concatenation' + 'Test'");
        this.assertResult("concatenation\n", "'concatenation' + '\\n'");
        this.assertResultInvalid("let s : String = invalid in 'concatenation' + s");
        this.assertResultInvalid("let s : String = invalid in s + 'concatenation'");
        this.assertResultInvalid("let s : String = null in 'concatenation' + s");
        this.assertResultInvalid("let s : String = null in s + 'concatenation'");
        this.assertResult("ab", "let s1 : String = 'a', s2 : String = 'b' in s1 + s2");
        this.assertResult("ab", "let s1 : EString = 'a', s2 : String = 'b' in s1 + s2");
        this.assertResult("ab", "let s1 : String = 'a', s2 : EString = 'b' in s1 + s2");
        this.assertResult("ab", "let s1 : EString = 'a', s2 : EString = 'b' in s1 + s2");
    }

    public void testStringReplaceAll() {
        this.assertResult("rePlaceAll oPeration", "'replaceAll operation'.replaceAll('p', 'P')");
        this.assertResult("ReplaceAllOperation", "'Repla ce All Operation'.replaceAll('(\\\\w+)\\\\s*', '$1')");
        this.assertResult("xx", "''.replaceAll('', 'xx')");
        this.assertResult("xxrxxexxpxxlxxaxx xxcxxexx xxoxxpxxexxrxxaxxtxxixxoxxnxx", "'repla ce operation'.replaceAll('', 'xx')");
        this.assertResult("", "'repla ce operation'.replaceAll('(\\\\w+)\\\\s*', '')");
        this.assertResult("repla ce operation", "'repla ce operation'.replaceAll('', '')");
        this.assertResultInvalid("'repla ce operation'.replaceAll('a[b-', '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceAll('', '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceAll(null, '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceAll('(\\\\w+)\\\\s*', null)");
        this.assertResultInvalid("'repla ce operation'.replaceAll(invalid, '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceAll('(\\\\w+)\\\\s*', invalid)");
    }

    public void testStringReplaceFirst() {
        this.assertResult("rePlace operation", "'replace operation'.replaceFirst('p', 'P')");
        this.assertResult("replace operation", "'repla ce operation'.replaceFirst('(\\\\w+)\\\\s*', '$1')");
        this.assertResult("xx", "''.replaceFirst('', 'xx')");
        this.assertResult("xxrepla ce operation", "'repla ce operation'.replaceFirst('', 'xx')");
        this.assertResult("ce operation", "'repla ce operation'.replaceFirst('(\\\\w+)\\\\s*', '')");
        this.assertResult("repla ce operation", "'repla ce operation'.replaceFirst('', '')");
        this.assertResultInvalid("'repla ce operation'.replaceFirst('a[b-', '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceFirst('', '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceFirst(null, '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceFirst('(\\\\w+)\\\\s*', null)");
        this.assertResultInvalid("'repla ce operation'.replaceFirst(invalid, '$1')");
        this.assertResultInvalid("'repla ce operation'.replaceFirst('(\\\\w+)\\\\s*', invalid)");
    }

    public void testStringSize() {
        this.assertResult(4, "'test'.size()");
        this.assertResult(0, "''.size()");
    }

    public void testStringSizeInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.size()");
    }

    public void testStringSizeNull() {
        this.assertResultInvalid("let s : String = null in s.size()");
    }

    public void testStringStartsWith() {
        this.assertResultFalse("'abcdef'.startsWith('abcdefg')");
        this.assertResultTrue("'abcdef'.startsWith('abcdef')");
        this.assertResultTrue("'abcdef'.startsWith('abcd')");
        this.assertResultTrue("'abcdef'.startsWith('a')");
        this.assertResultTrue("'abcdef'.startsWith('')");
        this.assertResultTrue("''.startsWith('')");
        this.assertResultFalse("''.startsWith('a')");
        this.assertResultTrue("'abcdef'.startsWith('')");
        this.assertResultFalse("'abcdef'.startsWith('bcd')");
        this.assertResultFalse("'abcdef'.startsWith('ef')");
        this.assertResultFalse("'abcdef'.startsWith('f')");
        this.assertResultInvalid("let s : String = invalid in s.startsWith('')");
        this.assertResultInvalid("let s : String = invalid in ''.startsWith(s)");
        this.assertResultInvalid("let s : String = null in s.startsWith('')");
        this.assertResultInvalid("let s : String = null in ''.startsWith(s)");
    }

    public void testStringSubstituteAll() {
        this.assertResult("subsTiTuTeAll operaTion", "'substituteAll operation'.substituteAll('t', 'T')");
        this.assertResult("xx", "''.replaceAll('', 'xx')");
        this.assertResult("xxrxxexxpxxlxxaxx xxcxxexx xxoxxpxxexxrxxaxxtxxixxoxxnxx", "'repla ce operation'.substituteAll('', 'xx')");
        this.assertResult("repla ce operation", "'repla ce operation'.substituteAll('(\\\\w+)\\\\s*', '')");
        this.assertResult("repla ce operation", "'repla ce operation'.substituteAll('', '')");
        this.assertResultInvalid("'repla ce operation'.substituteAll(null, '$1')");
        this.assertResultInvalid("'repla ce operation'.substituteAll('(\\\\w+)\\\\s*', null)");
        this.assertResultInvalid("'repla ce operation'.substituteAll(invalid, '$1')");
        this.assertResultInvalid("'repla ce operation'.substituteAll('(\\\\w+)\\\\s*', invalid)");
    }

    public void testStringSubstituteFirst() {
        this.assertResult("subsTiTuTeFirst operaTion", "'substiTuTeFirst operaTion'.substituteFirst('t', 'T')");
        this.assertResult("SubstiTuTeFirst operaTion", "'substiTuTeFirst operaTion'.substituteFirst('s', 'S')");
        this.assertResult("substiTuTeFirst operaTioN", "'substiTuTeFirst operaTion'.substituteFirst('n', 'N')");
        this.assertResult("substiTuTeFirst operaTion", "'substiTuTeFirst operaTion'.substituteFirst('n', 'n')");
        this.assertResult("substiTuTeFirst operaTiON", "'substiTuTeFirst operaTion'.substituteFirst('on', 'ON')");
        this.assertResult("a[b-c]d\r\n*", "'a[b-c]d\\\\w*'.substituteFirst('\\\\w', '\\r\\n')");
        this.assertResult("xx", "''.substituteFirst('', 'xx')");
        this.assertResult("xxrepla ce operation", "'repla ce operation'.substituteFirst('', 'xx')");
        this.assertResult("repla ce operation", "'repla ce operation'.substituteFirst('', '')");
        this.assertResultInvalid("'repla ce operation'.substituteFirst('(\\\\w+)\\\\s*', '')");
        this.assertResultInvalid("'repla ce operation'.substituteFirst(null, '$1')");
        this.assertResultInvalid("'repla ce operation'.substituteFirst('(\\\\w+)\\\\s*', null)");
        this.assertResultInvalid("'repla ce operation'.substituteFirst(invalid, '$1')");
        this.assertResultInvalid("'repla ce operation'.substituteFirst('(\\\\w+)\\\\s*', invalid)");
    }

    public void testStringSubstring() {
        this.assertResult("t", "'test'.substring(1, 1)");
        this.assertResult("es", "'test'.substring(2, 3)");
        this.assertResult("t", "'test'.substring(4, 4)");
    }

    public void testStringSubstringIllegalArguments() {
        this.assertResultInvalid("'test'.substring(2, 1)");
        this.assertResultInvalid("'test'.substring(3, 1)");
    }

    public void testStringSubstringInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.substring(1, 1)");
        this.assertResultInvalid("let s : String = invalid in s.substring(5, 5)");
    }

    public void testStringSubstringNull() {
        this.assertResultInvalid("let s : String = null in s.substring(1, 1)");
        this.assertResultInvalid("let s : String = null in s.substring(5, 5)");
    }

    public void testStringSubstringOutOfBounds() {
        this.assertResultInvalid("'test'.substring(0, 1)");
        this.assertResultInvalid("'test'.substring(4, 5)");
    }

    public void testStringToBoolean() {
        this.assertResultTrue("'true'.toBoolean()");
        this.assertResultFalse("' true'.toBoolean()");
        this.assertResultFalse("'true '.toBoolean()");
        this.assertResultFalse("'True'.toBoolean()");
        this.assertResultFalse("'false'.toBoolean()");
        this.assertResultFalse("'-4'.toBoolean()");
        this.assertResultInvalid("let s : String = invalid in s.toBoolean()");
        this.assertResultInvalid("let s : String = null in s.toBoolean()");
    }

    public void testStringToInteger() {
        this.assertResult(4, "'4'.toInteger()");
        this.assertResult(-4, "'-4'.toInteger()");
        this.assertResultInvalid("'4.0'.toInteger()");
        this.assertResultInvalid("'2.4.0'.toInteger()");
        this.assertResultInvalid("'a'.toInteger()");
    }

    public void testStringToIntegerInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.toInteger()");
    }

    public void testStringToIntegerNull() {
        this.assertResultInvalid("let s : String = null in s.toInteger()");
    }

    public void testStringToLower() {
        this.checkForUTF8Encoding();
        this.assertResult("4", "'4'.toLower()");
        this.assertResult("mixed", "'MiXeD'.toLower()");
        this.assertResult("upper", "'UPPER'.toLower()");
    }

    public void testStringToLowerCase() {
        this.checkForUTF8Encoding();
        this.assertResult("4", "'4'.toLowerCase()");
        this.assertResult("mixed", "'MiXeD'.toLowerCase()");
        this.assertResult("upper", "'UPPER'.toLowerCase()");
    }

    public void testStringToLowerInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.toLower()");
    }

    public void testStringToLowerNull() {
        this.assertResultInvalid("let s : String = null in s.toLower()");
    }

    public void testStringToReal() {
        this.assertResult(4.0, "'4'.toReal()");
        this.assertResult(-4.0, "'-4'.toReal()");
        this.assertResult(4.0, "'4.0'.toReal()");
        this.assertResultInvalid("'2.4.0'.toReal()");
        this.assertResultInvalid("'a'.toReal()");
    }

    public void testStringToRealInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.toReal()");
    }

    public void testStringToRealNull() {
        this.assertResultInvalid("let s : String = null in s.toReal()");
    }

    public void testStringToString() {
        this.assertExpressionResults("'4.0'", "'4.0'.toString()");
        this.assertResult("4.0 4", "('4.0' + ' ' + '4').toString()");
    }

    public void testStringToUpper() {
        this.checkForUTF8Encoding();
        this.assertResult("4", "'4'.toUpper()");
        this.assertResult("MIXED", "'MiXeD'.toUpper()");
        this.assertResult("LOWER", "'lower'.toUpper()");
    }

    public void testStringToUpperCase() {
        this.checkForUTF8Encoding();
        this.assertResult("4", "'4'.toUpperCase()");
        this.assertResult("MIXED", "'MiXeD'.toUpperCase()");
        this.assertResult("LOWER", "'lower'.toUpperCase()");
    }

    public void testStringToUpperInvalid() {
        this.assertResultInvalid("let s : String = invalid in s.toUpper()");
    }

    public void testStringToUpperNull() {
        this.assertResultInvalid("let s : String = null in s.toUpper()");
    }

    public void testStringTokenize() {
        this.assertExpressionResults("Sequence{'a','b','c','d'}", "'\\na b\\tc\\fd\\r'.tokenize()");
        this.assertExpressionResults("Sequence{'a','b','c','d'}", "' \\t\\n\\r\\fa b\\tc\\fd \\t\\n\\r\\f'.tokenize()");
        this.assertExpressionResults("Sequence{' ','\\t','\\n','\\r','\\f','a',' ','b','\\t','c','\\f','d',' ','\\t','\\n','\\r','\\f'}", "' \\t\\n\\r\\fa b\\tc\\fd \\t\\n\\r\\f'.tokenize(' \\t\\n\\r\\f', true)");
        this.assertExpressionResults("Sequence{'\\na',' ', 'b\\tc\\fd\\r'}", "'\\na b\\tc\\fd\\r'.tokenize(' ', true)");
        this.assertExpressionResults("Sequence{}", "''.tokenize(' ', true)");
        this.assertExpressionResults("Sequence{' \\t\\n\\r\\f'}", "' \\t\\n\\r\\f'.tokenize('', true)");
        this.assertExpressionResults("Sequence{}", "''.tokenize('', true)");
        this.assertExpressionResults("Sequence{}", "''.tokenize(' \\t\\n\\r\\f', true)");
        this.assertResultInvalid("let s : String = invalid in s.tokenize()");
        this.assertResultInvalid("let s : String = invalid in s.tokenize('')");
        this.assertResultInvalid("let s : String = invalid in s.tokenize('',true)");
        this.assertResultInvalid("let s : String = invalid in ''.tokenize(s)");
        this.assertResultInvalid("let s : String = invalid in ''.tokenize(s,true)");
        this.assertResultInvalid("let b : Boolean = invalid in ''.tokenize('',b)");
        this.assertResultInvalid("let s : String = null in s.tokenize()");
        this.assertResultInvalid("let s : String = null in s.tokenize('')");
        this.assertResultInvalid("let s : String = null in s.tokenize('',true)");
        this.assertResultInvalid("let s : String = null in ''.tokenize(s)");
        this.assertResultInvalid("let s : String = null in ''.tokenize(s,true)");
        this.assertResultInvalid("let b : Boolean = null in ''.tokenize('',b)");
    }

    public void testStringTrim() {
        this.assertResult("ab", "'ab'.trim()");
        this.assertResult("a", "'a'.trim()");
        this.assertResult("", "''.trim()");
        this.assertResult("a \t\n\r\fb", "'\\na \\t\\n\\r\\fb\\n'.trim()");
        this.assertResult("", "' \\t\\n\\r\\f \\t\\n\\r\\f'.trim()");
        this.assertResultInvalid("let s : String = invalid in s.trim()");
        this.assertResultInvalid("let s : String = null in s.trim()");
    }
}

