/*
 * Decompiled with CFR 0.152.
 */
package data.classes.util;

import data.classes.ActualObjectParameter;
import data.classes.Association;
import data.classes.AssociationEnd;
import data.classes.AssociationEndSignatureImplementation;
import data.classes.ClassTypeDefinition;
import data.classes.ClassesPackage;
import data.classes.Context;
import data.classes.ConverterBetweenParametrizations;
import data.classes.Delegation;
import data.classes.ExtentModifyingAssociationEndSignatureImplementation;
import data.classes.FunctionSignature;
import data.classes.FunctionSignatureImplementation;
import data.classes.FunctionSignatureTypeDefinition;
import data.classes.InScope;
import data.classes.LinkAddition;
import data.classes.LinkManipulationAtPosition;
import data.classes.LinkRemoval;
import data.classes.LinkSetting;
import data.classes.LinkTraversal;
import data.classes.MethodSignature;
import data.classes.Multiplicity;
import data.classes.NamedValue;
import data.classes.NativeImpl;
import data.classes.NestedTypeDefinition;
import data.classes.Parameter;
import data.classes.PlatformSpecificImplementation;
import data.classes.SapClass;
import data.classes.Signature;
import data.classes.SignatureImplementation;
import data.classes.SignatureOwner;
import data.classes.TypeAdapter;
import data.classes.TypeDefinition;
import data.classes.TypedElement;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesValidator
extends EObjectValidator {
    public static final ClassesValidator INSTANCE = new ClassesValidator();
    public static final String DIAGNOSTIC_SOURCE = "data.classes";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String ASSOCIATION__UNIQUENESS_ON_BOTH_ENDS_MUST_BE_THE_SAME__EEXPRESSION = "self.ends->forAll( e1, e2 : AssociationEnd |\r\n              e1 <> e2 implies e1.type.unique = e2.type.unique)";
    protected static final String ASSOCIATION__AT_MOST_ONE_COMPOSITE_END__EEXPRESSION = "self.ends->select(composite)->size() < 2";
    protected static final String ASSOCIATION__AT_LEAST_ONE_NAVIGABLE_END__EEXPRESSION = "self.ends->select(ae:AssociationEnd | ae.navigable)->notEmpty()";
    protected static final String ASSOCIATION__AT_MOST_ONE_EQUALITY_CONTRIBUTION_FOR_TWO_VALUE_CLASSES__EEXPRESSION = "self.ends->select(contributesToEquality and type.clazz.valueType)->size() < 2";
    protected static final String ASSOCIATION__AT_MOST_ONE_ORDERED_END__EEXPRESSION = "self.ends->select(ae|ae.type.ordered)->size() < 2";
    protected static final String SIGNATURE__ONLY_TRAILING_OPTIONAL_PARAMETERS__EEXPRESSION = "self.input->forAll(p | p.defaultValue->notEmpty() implies Sequence{(self.input->indexOf(p)+1)..self.input->size()}->forAll(\r\n    i | self.input->at(i).defaultValue->notEmpty()))";
    protected static final String ASSOCIATION_END__EXPOSING_CLASSES_EQUAL_OPPOSITE_ENDS_TYPE__EEXPRESSION = "self.signatureImplementations.implements_.owner->forAll(c:SignatureOwner | c = self.otherEnd().type.clazz)";
    protected static final String ASSOCIATION_END__NO_COMPOSITION_WITH_VALUE_CLASS__EEXPRESSION = "self.composite implies self.association.ends.type->forAll(ctd:ClassTypeDefinition | not ctd.clazz.valueType)";
    protected static final String ASSOCIATION_END__EQUALITY_CONTRIBUTIONS_MUST_BE_EXPOSED_AND_NAVIGABLE__EEXPRESSION = "self.contributesToEquality implies (self.otherEnd().signatureImplementations->notEmpty() and self.otherEnd().navigable)";
    protected static final String ASSOCIATION_END__EQUALITY_CONTRIBUTING_END_ON_VALUE_MUST_HAVE_UNLIMITED_UPPER_BOUNDS__EEXPRESSION = "(self.type.clazz.valueType and self.contributesToEquality and\r\n   self.type.clazz.getAssociationEnds()->exists(ae |\r\n     ae <> self and ae.contributesToEquality)) implies\r\n  self.type.isMany()";
    protected static final String SAP_CLASS__ONLY_VALUE_CLASSES_CAN_HAVE_OBJECT_PARAMETERS__EEXPRESSION = "self.formalObjectParameters->notEmpty() implies self.valueType";
    protected static final String SAP_CLASS__ONLY_OBJECT_PARAMETERIZED_CLASSES_CAN_HAVE_CONVERTER__EEXPRESSION = "self.converterBetweenParametrizations->notEmpty() implies self.formalObjectParameters->notEmpty()";
    protected static final String SAP_CLASS__ONLY_TRAILING_OPTIONAL_PARAMETERS__EEXPRESSION = "self.formalObjectParameters->forAll(p | p.defaultValue->notEmpty() implies Sequence{(self.formalObjectParameters->indexOf(p)+1)..self.formalObjectParameters->size()}->forAll(\r\n    i | self.formalObjectParameters->at(i).defaultValue->notEmpty()))";
    protected static final String SAP_CLASS__NO_RECURSION_FOR_OBJECT_PARAMETERS__EEXPRESSION = "true  --  TODO implement this";
    protected static final String DELEGATION__TO_END_MUST_HAVE_MULTIPLICITY_OF_ONE__EEXPRESSION = "self.from.otherEnd().type.lowerMultiplicity = 1 and\r\n  self.from.otherEnd().type.upperMultiplicity = 1";
    protected static final String CONTEXT__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION = "self.condition.getType().upperMultiplicity = 1 and\r\n  self.condition.getType().oclIsKindOf(ClassTypeDefinition) and\r\n  self.condition.getType().oclAsType(ClassTypeDefinition).clazz.name = 'Boolean'";
    protected static final String CONTEXT__CONSTRAINT_FOR_RIGHT_CLASS__EEXPRESSION = "self.constraints->forAll(c | c.constrainedType = self.for_)";
    protected static final String LINK_TRAVERSAL__OUTPUT_TYPE_MATCH_END_TYPE__EEXPRESSION = "self.implements_.input->isEmpty() and\r\n  self.implements_.output.oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.output.oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz";
    protected static final String LINK_TRAVERSAL__MUST_BE_NAVIGABLE__EEXPRESSION = "self.end.navigable";
    protected static final String LINK_ADDITION__ADDITION_INPUT_TYPE_MATCH_END_TYPE__EEXPRESSION = "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz";
    protected static final String LINK_REMOVAL__REMOVAL_TYPE_MATCH_END_TYPE__EEXPRESSION = "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz";
    protected static final String ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__ONLY_ON_OTHER_ENDS_CLASS_OR_CLASS_CONFORMING_TO_IT_OR_ADAPTER_ADAPTING_TO_IT__EEXPRESSION = "(self.implements_.owner.oclIsKindOf(SapClass) and\r\n    self.implements_.owner.oclAsType(SapClass).conformsTo(self.end.otherEnd().type.clazz))\r\n  or   (self.implements_.owner.oclIsKindOf(TypeAdapter) and\r\n    self.implements_.owner.oclAsType(TypeAdapter).adapted.conformsTo(self.end.otherEnd().type.clazz))";
    protected static final String CLASS_TYPE_DEFINITION__ACTUAL_OBJECTS_PARAMETERS_MATCH_SIGNATURE__EEXPRESSION = "let numberOfMandatoryParameters:Integer =\r\n    self.clazz.formalObjectParameters->select(p|p.defaultValue->isEmpty())->size()\r\n  in\r\n  self.objectParameters->size() >= numberOfMandatoryParameters and\r\n  self.objectParameters->size() <= self.clazz.formalObjectParameters->size() and\r\n  Sequence{1..self.objectParameters->size()}->forAll(i:Integer|\r\n    self.objectParameters->at(i).formalObjectParameter =\r\n    self.clazz.formalObjectParameters->at(i))";
    protected static final String NESTED_TYPE_DEFINITION__NESTED_IS_ALWAYS_MANY__EEXPRESSION = "self.isMany()";
    protected static final String LINK_SETTING__INPUT_TYPE_MATCH_END_TYPE__EEXPRESSION = "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz";
    protected static final String TYPE_ADAPTER__ALL_SIGNATURE_CONFORMS__EEXPRESSION = "self.ownedSignatures->forAll(selfSig:MethodSignature |\r\n    self.to.signaturesWithDelegation()->exists(toSig:MethodSignature |\r\n       selfSig.conformsTo(toSig)))";
    protected static final String TYPE_ADAPTER__SIGNATURES_CANNOT_BE_ABSTRACT__EEXPRESSION = "self.ownedSignatures->forAll(selfSig:MethodSignature | not selfSig.isAbstract())";
    protected static final String TYPE_ADAPTER__IS_FULL_ADAPTATION_TO_TO__EEXPRESSION = "self.to.signaturesWithDelegation()->forAll(toSig|\r\n    self.adapted.signaturesWithDelegation()->exists(adaptedSig|\r\n      adaptedSig.conformsTo(toSig))\r\n    or self.ownedSignatures->exists(ownedSig|\r\n      ownedSig.conformsTo(toSig)))";
    protected static final String TYPE_ADAPTER__VALUES_TO_VALUES_ENTITIES_TO_ENTITIES__EEXPRESSION = "self.adapted.valueType = self.to.valueType";
    protected static final String PARAMETER__DEFAULT_VALUE_TYPE__EEXPRESSION = "self.defaultValue->notEmpty() implies self.defaultValue.getType().conformsTo(self.getType())";
    protected static final String EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__MUST_NOT_MODIFY_EXTENT_IF_EQUALITY_RELEVANT_FOR_VALUE_CLASS__EEXPRESSION = "end.association.ends->forAll(ae:AssociationEnd |\r\n    ae.contributesToEquality implies not ae.type.clazz.valueType)";
    protected static final String EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__MUST_NOT_IMPLEMENT_SIDE_EFFECT_FREE_OPERATION__EEXPRESSION = "not self.implements_.sideEffectFree";
    protected static final String CONVERTER_BETWEEN_PARAMETRIZATIONS__MUST_HAVE_CONCRETE_METHOD__EEXPRESSION = "not self.conversionMethod.isAbstract()";
    protected static final String CONVERTER_BETWEEN_PARAMETRIZATIONS__FORMAL_OBJECT_PARAMETERS_CONFORM_TO_METHOD_PARAMETERS__EEXPRESSION = "self.conversionMethod.input->size() = self.clazz.formalObjectParameters->size() and\r\n  Sequence{1..self.conversionMethod.input->size()}->forAll(i |\r\n    self.clazz.formalObjectParameters->at(i).conformsTo(self.conversionMethod.input->at(i)))";

    protected EPackage getEPackage() {
        return ClassesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAssociation((Association)value, diagnostics, context);
            }
            case 1: {
                return this.validateSignature((Signature)value, diagnostics, context);
            }
            case 2: {
                return this.validateAssociationEnd((AssociationEnd)value, diagnostics, context);
            }
            case 3: {
                return this.validateSapClass((SapClass)value, diagnostics, context);
            }
            case 4: {
                return this.validateDelegation((Delegation)value, diagnostics, context);
            }
            case 5: {
                return this.validateTypedElement((TypedElement)value, diagnostics, context);
            }
            case 6: {
                return this.validateContext((Context)value, diagnostics, context);
            }
            case 7: {
                return this.validateMultiplicity((Multiplicity)value, diagnostics, context);
            }
            case 8: {
                return this.validateSignatureImplementation((SignatureImplementation)value, diagnostics, context);
            }
            case 9: {
                return this.validateLinkTraversal((LinkTraversal)value, diagnostics, context);
            }
            case 10: {
                return this.validateLinkAddition((LinkAddition)value, diagnostics, context);
            }
            case 11: {
                return this.validateLinkRemoval((LinkRemoval)value, diagnostics, context);
            }
            case 12: {
                return this.validateAssociationEndSignatureImplementation((AssociationEndSignatureImplementation)value, diagnostics, context);
            }
            case 13: {
                return this.validateClassTypeDefinition((ClassTypeDefinition)value, diagnostics, context);
            }
            case 14: {
                return this.validateTypeDefinition((TypeDefinition)value, diagnostics, context);
            }
            case 15: {
                return this.validateNestedTypeDefinition((NestedTypeDefinition)value, diagnostics, context);
            }
            case 16: {
                return this.validateFunctionSignatureTypeDefinition((FunctionSignatureTypeDefinition)value, diagnostics, context);
            }
            case 17: {
                return this.validateMethodSignature((MethodSignature)value, diagnostics, context);
            }
            case 18: {
                return this.validateFunctionSignature((FunctionSignature)value, diagnostics, context);
            }
            case 19: {
                return this.validateLinkSetting((LinkSetting)value, diagnostics, context);
            }
            case 20: {
                return this.validateTypeAdapter((TypeAdapter)value, diagnostics, context);
            }
            case 21: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 22: {
                return this.validateNamedValue((NamedValue)value, diagnostics, context);
            }
            case 23: {
                return this.validatePlatformSpecificImplementation((PlatformSpecificImplementation)value, diagnostics, context);
            }
            case 24: {
                return this.validateNativeImpl((NativeImpl)value, diagnostics, context);
            }
            case 25: {
                return this.validateSignatureOwner((SignatureOwner)value, diagnostics, context);
            }
            case 26: {
                return this.validateExtentModifyingAssociationEndSignatureImplementation((ExtentModifyingAssociationEndSignatureImplementation)value, diagnostics, context);
            }
            case 27: {
                return this.validateFunctionSignatureImplementation((FunctionSignatureImplementation)value, diagnostics, context);
            }
            case 28: {
                return this.validateActualObjectParameter((ActualObjectParameter)value, diagnostics, context);
            }
            case 29: {
                return this.validateConverterBetweenParametrizations((ConverterBetweenParametrizations)value, diagnostics, context);
            }
            case 30: {
                return this.validateLinkManipulationAtPosition((LinkManipulationAtPosition)value, diagnostics, context);
            }
            case 31: {
                return this.validateInScope((InScope)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAssociation(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(association, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(association, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociation_UniquenessOnBothEndsMustBeTheSame(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociation_AtMostOneCompositeEnd(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociation_AtLeastOneNavigableEnd(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociation_AtMostOneEqualityContributionForTwoValueClasses(association, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociation_AtMostOneOrderedEnd(association, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssociation_UniquenessOnBothEndsMustBeTheSame(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION, association, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "UniquenessOnBothEndsMustBeTheSame", ASSOCIATION__UNIQUENESS_ON_BOTH_ENDS_MUST_BE_THE_SAME__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociation_AtMostOneCompositeEnd(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION, association, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AtMostOneCompositeEnd", ASSOCIATION__AT_MOST_ONE_COMPOSITE_END__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociation_AtLeastOneNavigableEnd(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION, association, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AtLeastOneNavigableEnd", ASSOCIATION__AT_LEAST_ONE_NAVIGABLE_END__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociation_AtMostOneEqualityContributionForTwoValueClasses(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION, association, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AtMostOneEqualityContributionForTwoValueClasses", ASSOCIATION__AT_MOST_ONE_EQUALITY_CONTRIBUTION_FOR_TWO_VALUE_CLASSES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociation_AtMostOneOrderedEnd(Association association, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION, association, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AtMostOneOrderedEnd", ASSOCIATION__AT_MOST_ONE_ORDERED_END__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSignature(Signature signature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(signature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(signature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(signature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignature_OnlyTrailingOptionalParameters(signature, diagnostics, context);
        }
        return result;
    }

    public boolean validateSignature_OnlyTrailingOptionalParameters(Signature signature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.SIGNATURE, signature, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OnlyTrailingOptionalParameters", SIGNATURE__ONLY_TRAILING_OPTIONAL_PARAMETERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEnd(AssociationEnd associationEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(associationEnd, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(associationEnd, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEnd_ExposingClassesEqualOppositeEndsType(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEnd_NoCompositionWithValueClass(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEnd_EqualityContributionsMustBeExposedAndNavigable(associationEnd, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEnd_EqualityContributingEndOnValueMustHaveUnlimitedUpperBounds(associationEnd, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssociationEnd_ExposingClassesEqualOppositeEndsType(AssociationEnd associationEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION_END, associationEnd, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ExposingClassesEqualOppositeEndsType", ASSOCIATION_END__EXPOSING_CLASSES_EQUAL_OPPOSITE_ENDS_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEnd_NoCompositionWithValueClass(AssociationEnd associationEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION_END, associationEnd, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NoCompositionWithValueClass", ASSOCIATION_END__NO_COMPOSITION_WITH_VALUE_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEnd_EqualityContributionsMustBeExposedAndNavigable(AssociationEnd associationEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION_END, associationEnd, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "EqualityContributionsMustBeExposedAndNavigable", ASSOCIATION_END__EQUALITY_CONTRIBUTIONS_MUST_BE_EXPOSED_AND_NAVIGABLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEnd_EqualityContributingEndOnValueMustHaveUnlimitedUpperBounds(AssociationEnd associationEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION_END, associationEnd, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "EqualityContributingEndOnValueMustHaveUnlimitedUpperBounds", ASSOCIATION_END__EQUALITY_CONTRIBUTING_END_ON_VALUE_MUST_HAVE_UNLIMITED_UPPER_BOUNDS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSapClass(SapClass sapClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sapClass, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sapClass, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSapClass_OnlyValueClassesCanHaveObjectParameters(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSapClass_OnlyObjectParameterizedClassesCanHaveConverter(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSapClass_OnlyTrailingOptionalParameters(sapClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSapClass_NoRecursionForObjectParameters(sapClass, diagnostics, context);
        }
        return result;
    }

    public boolean validateSapClass_OnlyValueClassesCanHaveObjectParameters(SapClass sapClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.SAP_CLASS, sapClass, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OnlyValueClassesCanHaveObjectParameters", SAP_CLASS__ONLY_VALUE_CLASSES_CAN_HAVE_OBJECT_PARAMETERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSapClass_OnlyObjectParameterizedClassesCanHaveConverter(SapClass sapClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.SAP_CLASS, sapClass, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OnlyObjectParameterizedClassesCanHaveConverter", SAP_CLASS__ONLY_OBJECT_PARAMETERIZED_CLASSES_CAN_HAVE_CONVERTER__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSapClass_OnlyTrailingOptionalParameters(SapClass sapClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.SAP_CLASS, sapClass, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OnlyTrailingOptionalParameters", SAP_CLASS__ONLY_TRAILING_OPTIONAL_PARAMETERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSapClass_NoRecursionForObjectParameters(SapClass sapClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.SAP_CLASS, sapClass, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NoRecursionForObjectParameters", SAP_CLASS__NO_RECURSION_FOR_OBJECT_PARAMETERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDelegation(Delegation delegation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(delegation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(delegation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delegation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDelegation_ToEndMustHaveMultiplicityOfOne(delegation, diagnostics, context);
        }
        return result;
    }

    public boolean validateDelegation_ToEndMustHaveMultiplicityOfOne(Delegation delegation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.DELEGATION, delegation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ToEndMustHaveMultiplicityOfOne", DELEGATION__TO_END_MUST_HAVE_MULTIPLICITY_OF_ONE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypedElement(TypedElement typedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typedElement, diagnostics, context);
    }

    public boolean validateContext(Context context, DiagnosticChain diagnostics, Map<Object, Object> theContext) {
        if (!this.validate_NoCircularContainment(context, diagnostics, theContext)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(context, diagnostics, theContext);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validateContext_ConditionMustBeBoolean(context, diagnostics, theContext);
        }
        if (result || diagnostics != null) {
            result &= this.validateContext_ConstraintForRightClass(context, diagnostics, theContext);
        }
        return result;
    }

    public boolean validateContext_ConditionMustBeBoolean(Context context, DiagnosticChain diagnostics, Map<Object, Object> theContext) {
        return this.validate(ClassesPackage.Literals.CONTEXT, context, diagnostics, theContext, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConditionMustBeBoolean", CONTEXT__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateContext_ConstraintForRightClass(Context context, DiagnosticChain diagnostics, Map<Object, Object> theContext) {
        return this.validate(ClassesPackage.Literals.CONTEXT, context, diagnostics, theContext, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConstraintForRightClass", CONTEXT__CONSTRAINT_FOR_RIGHT_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMultiplicity(Multiplicity multiplicity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(multiplicity, diagnostics, context);
    }

    public boolean validateSignatureImplementation(SignatureImplementation signatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(signatureImplementation, diagnostics, context);
    }

    public boolean validateLinkTraversal(LinkTraversal linkTraversal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkTraversal, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkTraversal, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkTraversal_OutputTypeMatchEndType(linkTraversal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkTraversal_MustBeNavigable(linkTraversal, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkTraversal_OutputTypeMatchEndType(LinkTraversal linkTraversal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.LINK_TRAVERSAL, linkTraversal, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OutputTypeMatchEndType", LINK_TRAVERSAL__OUTPUT_TYPE_MATCH_END_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkTraversal_MustBeNavigable(LinkTraversal linkTraversal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.LINK_TRAVERSAL, linkTraversal, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustBeNavigable", LINK_TRAVERSAL__MUST_BE_NAVIGABLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkAddition(LinkAddition linkAddition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkAddition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkAddition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(linkAddition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkAddition_AdditionInputTypeMatchEndType(linkAddition, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkAddition_AdditionInputTypeMatchEndType(LinkAddition linkAddition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.LINK_ADDITION, linkAddition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AdditionInputTypeMatchEndType", "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkRemoval(LinkRemoval linkRemoval, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkRemoval, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkRemoval, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(linkRemoval, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkRemoval_RemovalTypeMatchEndType(linkRemoval, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkRemoval_RemovalTypeMatchEndType(LinkRemoval linkRemoval, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.LINK_REMOVAL, linkRemoval, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "RemovalTypeMatchEndType", "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEndSignatureImplementation(AssociationEndSignatureImplementation associationEndSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(associationEndSignatureImplementation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(associationEndSignatureImplementation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(associationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(associationEndSignatureImplementation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(AssociationEndSignatureImplementation associationEndSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.ASSOCIATION_END_SIGNATURE_IMPLEMENTATION, associationEndSignatureImplementation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt", ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__ONLY_ON_OTHER_ENDS_CLASS_OR_CLASS_CONFORMING_TO_IT_OR_ADAPTER_ADAPTING_TO_IT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateClassTypeDefinition(ClassTypeDefinition classTypeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(classTypeDefinition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(classTypeDefinition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(classTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClassTypeDefinition_ActualObjectsParametersMatchSignature(classTypeDefinition, diagnostics, context);
        }
        return result;
    }

    public boolean validateClassTypeDefinition_ActualObjectsParametersMatchSignature(ClassTypeDefinition classTypeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.CLASS_TYPE_DEFINITION, classTypeDefinition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ActualObjectsParametersMatchSignature", CLASS_TYPE_DEFINITION__ACTUAL_OBJECTS_PARAMETERS_MATCH_SIGNATURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypeDefinition(TypeDefinition typeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typeDefinition, diagnostics, context);
    }

    public boolean validateNestedTypeDefinition(NestedTypeDefinition nestedTypeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nestedTypeDefinition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nestedTypeDefinition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nestedTypeDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedTypeDefinition_NestedIsAlwaysMany(nestedTypeDefinition, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedTypeDefinition_NestedIsAlwaysMany(NestedTypeDefinition nestedTypeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.NESTED_TYPE_DEFINITION, nestedTypeDefinition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NestedIsAlwaysMany", NESTED_TYPE_DEFINITION__NESTED_IS_ALWAYS_MANY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFunctionSignatureTypeDefinition(FunctionSignatureTypeDefinition functionSignatureTypeDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(functionSignatureTypeDefinition, diagnostics, context);
    }

    public boolean validateMethodSignature(MethodSignature methodSignature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(methodSignature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(methodSignature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(methodSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignature_OnlyTrailingOptionalParameters(methodSignature, diagnostics, context);
        }
        return result;
    }

    public boolean validateFunctionSignature(FunctionSignature functionSignature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(functionSignature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(functionSignature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(functionSignature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignature_OnlyTrailingOptionalParameters(functionSignature, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkSetting(LinkSetting linkSetting, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkSetting, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkSetting, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(linkSetting, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLinkSetting_InputTypeMatchEndType(linkSetting, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinkSetting_InputTypeMatchEndType(LinkSetting linkSetting, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.LINK_SETTING, linkSetting, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "InputTypeMatchEndType", "self.implements_.output->isEmpty() and\r\n  self.implements_.input->size() = 1 and \r\n  self.implements_.input->at(1).getType().oclIsKindOf(ClassTypeDefinition) and \r\n  self.implements_.input->at(1).getType().oclAsType(ClassTypeDefinition).clazz = self.end.type.clazz", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypeAdapter(TypeAdapter typeAdapter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeAdapter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeAdapter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAdapter_AllSignatureConforms(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAdapter_SignaturesCannotBeAbstract(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAdapter_IsFullAdaptationToTo(typeAdapter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAdapter_ValuesToValues_EntitiesToEntities(typeAdapter, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeAdapter_AllSignatureConforms(TypeAdapter typeAdapter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.TYPE_ADAPTER, typeAdapter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "AllSignatureConforms", TYPE_ADAPTER__ALL_SIGNATURE_CONFORMS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypeAdapter_SignaturesCannotBeAbstract(TypeAdapter typeAdapter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.TYPE_ADAPTER, typeAdapter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SignaturesCannotBeAbstract", TYPE_ADAPTER__SIGNATURES_CANNOT_BE_ABSTRACT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypeAdapter_IsFullAdaptationToTo(TypeAdapter typeAdapter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.TYPE_ADAPTER, typeAdapter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "IsFullAdaptationToTo", TYPE_ADAPTER__IS_FULL_ADAPTATION_TO_TO__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTypeAdapter_ValuesToValues_EntitiesToEntities(TypeAdapter typeAdapter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.TYPE_ADAPTER, typeAdapter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValuesToValues_EntitiesToEntities", TYPE_ADAPTER__VALUES_TO_VALUES_ENTITIES_TO_ENTITIES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(parameter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(parameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameter_DefaultValueType(parameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter_DefaultValueType(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.PARAMETER, parameter, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "DefaultValueType", PARAMETER__DEFAULT_VALUE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNamedValue(NamedValue namedValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedValue, diagnostics, context);
    }

    public boolean validatePlatformSpecificImplementation(PlatformSpecificImplementation platformSpecificImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(platformSpecificImplementation, diagnostics, context);
    }

    public boolean validateNativeImpl(NativeImpl nativeImpl, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nativeImpl, diagnostics, context);
    }

    public boolean validateSignatureOwner(SignatureOwner signatureOwner, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(signatureOwner, diagnostics, context);
    }

    public boolean validateExtentModifyingAssociationEndSignatureImplementation(ExtentModifyingAssociationEndSignatureImplementation extentModifyingAssociationEndSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(extentModifyingAssociationEndSignatureImplementation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(extentModifyingAssociationEndSignatureImplementation, diagnostics, context);
        }
        return result;
    }

    public boolean validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(ExtentModifyingAssociationEndSignatureImplementation extentModifyingAssociationEndSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION, extentModifyingAssociationEndSignatureImplementation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustNotModifyExtentIfEqualityRelevantForValueClass", EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__MUST_NOT_MODIFY_EXTENT_IF_EQUALITY_RELEVANT_FOR_VALUE_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(ExtentModifyingAssociationEndSignatureImplementation extentModifyingAssociationEndSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION, extentModifyingAssociationEndSignatureImplementation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustNotImplementSideEffectFreeOperation", EXTENT_MODIFYING_ASSOCIATION_END_SIGNATURE_IMPLEMENTATION__MUST_NOT_IMPLEMENT_SIDE_EFFECT_FREE_OPERATION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFunctionSignatureImplementation(FunctionSignatureImplementation functionSignatureImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(functionSignatureImplementation, diagnostics, context);
    }

    public boolean validateActualObjectParameter(ActualObjectParameter actualObjectParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(actualObjectParameter, diagnostics, context);
    }

    public boolean validateConverterBetweenParametrizations(ConverterBetweenParametrizations converterBetweenParametrizations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(converterBetweenParametrizations, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(converterBetweenParametrizations, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConverterBetweenParametrizations_MustHaveConcreteMethod(converterBetweenParametrizations, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConverterBetweenParametrizations_FormalObjectParametersConformToMethodParameters(converterBetweenParametrizations, diagnostics, context);
        }
        return result;
    }

    public boolean validateConverterBetweenParametrizations_MustHaveConcreteMethod(ConverterBetweenParametrizations converterBetweenParametrizations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.CONVERTER_BETWEEN_PARAMETRIZATIONS, converterBetweenParametrizations, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MustHaveConcreteMethod", CONVERTER_BETWEEN_PARAMETRIZATIONS__MUST_HAVE_CONCRETE_METHOD__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateConverterBetweenParametrizations_FormalObjectParametersConformToMethodParameters(ConverterBetweenParametrizations converterBetweenParametrizations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ClassesPackage.Literals.CONVERTER_BETWEEN_PARAMETRIZATIONS, converterBetweenParametrizations, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FormalObjectParametersConformToMethodParameters", CONVERTER_BETWEEN_PARAMETRIZATIONS__FORMAL_OBJECT_PARAMETERS_CONFORM_TO_METHOD_PARAMETERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLinkManipulationAtPosition(LinkManipulationAtPosition linkManipulationAtPosition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linkManipulationAtPosition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linkManipulationAtPosition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndSignatureImplementation_OnlyOnOtherEndsClassOrClassConformingToItOrAdapterAdaptingToIt(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotModifyExtentIfEqualityRelevantForValueClass(linkManipulationAtPosition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExtentModifyingAssociationEndSignatureImplementation_MustNotImplementSideEffectFreeOperation(linkManipulationAtPosition, diagnostics, context);
        }
        return result;
    }

    public boolean validateInScope(InScope inScope, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(inScope, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

