/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.context.ModelContext;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.TuplePartCS;
import org.eclipse.ocl.xtext.basecs.TupleTypeCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.CurlyBracketedClauseCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.RoundBracketedClauseCS;
import org.eclipse.ocl.xtext.essentialoclcs.SquareBracketedClauseCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeNameExpCS;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;

public class XtextTestCase
extends PivotTestCaseWithAutoTearDown {
    protected void assertPivotIsValid(URI pivotURI) {
        OCL ocl = OCL.newInstance((ProjectManager)XtextTestCase.getProjectMap());
        ResourceSet reloadResourceSet = ocl.getMetamodelManager().getASResourceSet();
        Resource reloadedPivotResource = reloadResourceSet.getResource(pivotURI, true);
        XtextTestCase.assertNoValidationErrors("Pivot reload validation problems", reloadedPivotResource);
        XtextTestCase.unloadResourceSet(reloadResourceSet);
        ocl.dispose();
    }

    @Deprecated
    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        TestUtil.assertSameModel(expectedResource, actualResource);
    }

    protected void doBadLoadFromString(@NonNull OCLInternal ocl, @NonNull String fileName, @NonNull String testContents, @NonNull Bag<String> expectedErrorMessages) throws Exception {
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        metamodelManager.addClassLoader((ClassLoader)ClassUtil.nonNullState((Object)((Object)((Object)this)).getClass().getClassLoader()));
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testContents, "UTF-8");
        URI libraryURI = this.getTestFileURI(fileName, (InputStream)inputStream);
        @NonNull BaseCSResource xtextResource = (BaseCSResource)ocl.getResourceSet().createResource(libraryURI);
        @NonNull ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)classLoader);
        xtextResource.load(null);
        BagImpl actualErrorMessages = new BagImpl();
        for (Resource.Diagnostic actualError : xtextResource.getErrors()) {
            actualErrorMessages.add((Object)actualError.getMessage());
        }
        String s = XtextTestCase.formatMessageDifferences(expectedErrorMessages, (Bag<String>)actualErrorMessages);
        if (s != null) {
            XtextTestCase.fail((String)("Inconsistent load errors (expected/actual) message" + s));
        }
    }

    protected void doLoadFromString(@NonNull OCL ocl, @NonNull String fileName, @NonNull String testContents) throws Exception {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testContents, "UTF-8");
        URI libraryURI = this.getTestFileURI(fileName, (InputStream)inputStream);
        ResourceSet resourceSet = ocl.getResourceSet();
        BaseCSResource xtextResource = (BaseCSResource)resourceSet.createResource(libraryURI);
        xtextResource.load(null);
        XtextTestCase.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = xtextResource.getASResource();
        assert (asResource != null);
        XtextTestCase.assertNoResourceErrors("File Model", (Resource)asResource);
        XtextTestCase.assertNoUnresolvedProxies("File Model", (Resource)asResource);
        XtextTestCase.assertNoValidationErrors("File Model", (Resource)asResource);
    }

    protected ASResource doLoadASResourceFromString(@NonNull OCL ocl, @NonNull String fileName, @NonNull String testContents) throws Exception {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testContents, "UTF-8");
        URI libraryURI = this.getTestFileURI(fileName, (InputStream)inputStream);
        EnvironmentFactoryInternal environmentFactory = (EnvironmentFactoryInternal)ocl.getEnvironmentFactory();
        ModelContext modelContext = new ModelContext((EnvironmentFactory)environmentFactory, libraryURI);
        BaseCSResource xtextResource = (BaseCSResource)modelContext.createBaseResource(null);
        XtextTestCase.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource asResource = xtextResource.getASResource();
        assert (asResource != null);
        XtextTestCase.assertNoResourceErrors("File Model", (Resource)asResource);
        XtextTestCase.assertNoUnresolvedProxies("File Model", (Resource)asResource);
        XtextTestCase.assertNoValidationErrors("File Model", (Resource)asResource);
        return asResource;
    }

    protected static boolean hasCorrespondingCS(Element pivotElement) {
        if (!XtextTestCase.isValidPivot(pivotElement)) {
            return false;
        }
        if (pivotElement instanceof ExpressionInOCL) {
            return false;
        }
        if (pivotElement instanceof Variable && pivotElement.eContainer() instanceof ExpressionInOCL) {
            return false;
        }
        return !(pivotElement instanceof Variable) || !(pivotElement.eContainer() instanceof LoopExp) || !Character.isDigit(((Variable)pivotElement).getName().charAt(0));
    }

    public static boolean hasCorrespondingPivot(ModelElementCS csElement) {
        if (csElement instanceof TupleTypeCS) {
            return true;
        }
        if (csElement instanceof TuplePartCS) {
            return false;
        }
        if (csElement instanceof InfixExpCS) {
            return false;
        }
        if (csElement instanceof NestedExpCS) {
            return false;
        }
        if (csElement instanceof PrefixExpCS) {
            return false;
        }
        if (csElement instanceof NavigatingArgCS) {
            return false;
        }
        if (csElement instanceof CurlyBracketedClauseCS) {
            return false;
        }
        if (csElement instanceof RoundBracketedClauseCS) {
            return false;
        }
        if (csElement instanceof SquareBracketedClauseCS) {
            return false;
        }
        if (NavigationUtil.isNavigationInfixExp((EObject)csElement)) {
            return false;
        }
        if (csElement instanceof CollectionTypeCS) {
            return false;
        }
        return !(csElement instanceof TypeNameExpCS);
    }

    public static boolean hasUniqueMoniker(ModelElementCS csElement) {
        if (csElement instanceof TupleTypeCS) {
            return false;
        }
        if (csElement instanceof TypeRefCS) {
            return false;
        }
        if (csElement instanceof InfixExpCS) {
            return false;
        }
        if (csElement instanceof NestedExpCS) {
            return false;
        }
        if (csElement instanceof PrefixExpCS) {
            return false;
        }
        if (csElement instanceof CurlyBracketedClauseCS) {
            return false;
        }
        if (csElement instanceof RoundBracketedClauseCS) {
            return false;
        }
        if (csElement instanceof SquareBracketedClauseCS) {
            return false;
        }
        if (NavigationUtil.isNavigationInfixExp((EObject)csElement)) {
            return false;
        }
        return !(csElement instanceof CollectionTypeCS);
    }

    protected static boolean isValidPivot(Element pivotElement) {
        EObject eContainer;
        if (pivotElement instanceof Package && pivotElement.eContainer() == null && "$$".equals(((NamedElement)pivotElement).getName())) {
            return false;
        }
        if (pivotElement instanceof TemplateableElement && ((TemplateableElement)pivotElement).getOwnedBindings().size() > 0) {
            return false;
        }
        if (pivotElement instanceof LambdaType) {
            return false;
        }
        if (pivotElement instanceof TupleType) {
            return false;
        }
        if (pivotElement instanceof Type && (eContainer = pivotElement.eContainer()) instanceof Package && eContainer.eContainer() == null && "$$".equals(((NamedElement)pivotElement).getName()) && "$$".equals(((NamedElement)eContainer).getName())) {
            return false;
        }
        if (pivotElement instanceof Property && pivotElement.eContainer() instanceof TupleType) {
            return false;
        }
        return !(pivotElement instanceof VariableExp) || !(pivotElement.eContainer() instanceof OperationCallExp);
    }

    public @NonNull String createEcoreString(@NonNull OCL ocl, @NonNull String fileName, @NonNull String fileContent, boolean assignIds) throws IOException {
        String inputName = String.valueOf(fileName) + ".oclinecore";
        this.createOCLinEcoreFile(inputName, fileContent);
        URI inputURI = this.getTestFileURI(inputName);
        URI ecoreURI = this.getTestFileURI(String.valueOf(fileName) + ".ecore");
        BaseCSResource xtextResource = null;
        try {
            ResourceSet resourceSet2 = ocl.getResourceSet();
            xtextResource = (BaseCSResource)ClassUtil.nonNullState((Object)((BaseCSResource)resourceSet2.getResource(inputURI, true)));
            XtextTestCase.assertNoResourceErrors("Load failed", (Resource)xtextResource);
            ASResource asResource = xtextResource.getASResource();
            XtextTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
            XtextTestCase.assertNoValidationErrors("Pivot validation errors", (EObject)asResource.getContents().get(0));
            XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()), (Resource)asResource, (URI)ecoreURI, null);
            XtextTestCase.assertNoResourceErrors("To Ecore errors", (Resource)ecoreResource);
            if (assignIds) {
                TreeIterator tit = ecoreResource.getAllContents();
                while (tit.hasNext()) {
                    EObject eObject = (EObject)tit.next();
                    ecoreResource.setID(eObject, EcoreUtil.generateUUID());
                }
            }
            StringWriter writer = new StringWriter();
            ecoreResource.save((Writer)writer, XMIUtil.createSaveOptions());
            String string = (String)ClassUtil.nonNullState((Object)((Object)writer).toString());
            return string;
        }
        finally {
            if (xtextResource != null) {
                xtextResource.dispose();
            }
        }
    }

    protected void mapOwnURI(Resource resource) {
        EPackage rootPackage;
        String nsURI;
        EObject root;
        EList contents = resource.getContents();
        if (contents.size() == 1 && (root = (EObject)contents.get(0)) instanceof EPackage && (nsURI = (rootPackage = (EPackage)root).getNsURI()) != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            HashMap<URI, Resource> uriResourceMap = ((ResourceSetImpl)resourceSet).getURIResourceMap();
            if (uriResourceMap == null) {
                uriResourceMap = new HashMap<URI, Resource>();
                ((ResourceSetImpl)resourceSet).setURIResourceMap(uriResourceMap);
            }
            uriResourceMap.put(URI.createURI((String)nsURI), resource);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
        TestUtil.doCompleteOCLSetup();
        TestUtil.doOCLinEcoreSetup();
        TestUtil.doOCLstdlibSetup();
        OCLstdlib.install();
        OCLDelegateDomain.initialize(null);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static class EAnnotationConstraintsNormalizer
    implements Normalizer {
        protected final @NonNull EAnnotation eAnnotation;
        protected final @Nullable String oldConstraints;

        public EAnnotationConstraintsNormalizer(@NonNull EAnnotation eAnnotation) {
            this.eAnnotation = eAnnotation;
            this.oldConstraints = (String)eAnnotation.getDetails().get((Object)"constraints");
        }

        @Override
        public void denormalize() {
            this.eAnnotation.getDetails().put((Object)"constraints", (Object)this.oldConstraints);
        }

        @Override
        public void normalize() {
            StringBuilder s1 = new StringBuilder();
            if (this.oldConstraints != null) {
                Object[] s = this.oldConstraints.split(" ");
                Arrays.sort(s);
                int i = 0;
                while (i < s.length) {
                    if (i > 0) {
                        s1.append(" ");
                    }
                    s1.append((String)s[i]);
                    ++i;
                }
            }
            this.eAnnotation.getDetails().put((Object)"constraints", (Object)s1.toString());
        }
    }

    public static class EAnnotationsNormalizer
    implements Normalizer {
        protected final @NonNull EModelElement eModelElement;
        protected final List<EAnnotation> oldOrder;

        public EAnnotationsNormalizer(@NonNull EModelElement eModelElement) {
            this.eModelElement = eModelElement;
            this.oldOrder = new ArrayList<EAnnotation>((Collection<EAnnotation>)eModelElement.getEAnnotations());
        }

        @Override
        public void denormalize() {
            EList eList = this.eModelElement.getEAnnotations();
            eList.clear();
            eList.addAll(this.oldOrder);
        }

        @Override
        public void normalize() {
            EList eList = this.eModelElement.getEAnnotations();
            ArrayList newOrder = new ArrayList(eList);
            Collections.sort(newOrder, NameUtil.EAnnotationComparator.INSTANCE);
            eList.clear();
            eList.addAll(newOrder);
        }
    }

    public static class EDetailsNormalizer
    implements Normalizer {
        protected final @NonNull EAnnotation eAnnotation;
        protected final List<Map.Entry<String, String>> oldOrder;

        public EDetailsNormalizer(@NonNull EAnnotation eAnnotation) {
            this.eAnnotation = eAnnotation;
            this.oldOrder = new ArrayList<Map.Entry<String, String>>((Collection<Map.Entry<String, String>>)eAnnotation.getDetails());
        }

        @Override
        public void denormalize() {
            EMap eDetails = this.eAnnotation.getDetails();
            eDetails.clear();
            eDetails.addAll(this.oldOrder);
        }

        @Override
        public void normalize() {
            EMap eDetails = this.eAnnotation.getDetails();
            ArrayList newOrder = new ArrayList(eDetails);
            Collections.sort(newOrder, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    String n1 = o1.getKey();
                    String n2 = o2.getKey();
                    return n1.compareTo(n2);
                }
            });
            eDetails.clear();
            eDetails.addAll(newOrder);
        }
    }

    public static class EOperationsNormalizer
    implements Normalizer {
        protected final @NonNull EClass eClass;
        protected final List<EOperation> oldOrder;

        public EOperationsNormalizer(@NonNull EClass eClass) {
            this.eClass = eClass;
            this.oldOrder = new ArrayList<EOperation>((Collection<EOperation>)eClass.getEOperations());
        }

        @Override
        public void denormalize() {
            EList eOperations = this.eClass.getEOperations();
            eOperations.clear();
            eOperations.addAll(this.oldOrder);
        }

        @Override
        public void normalize() {
            EList eOperations = this.eClass.getEOperations();
            ArrayList newOrder = new ArrayList(eOperations);
            Collections.sort(newOrder, new Comparator<EOperation>(){

                @Override
                public int compare(EOperation o1, EOperation o2) {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    return n1.compareTo(n2);
                }
            });
            eOperations.clear();
            eOperations.addAll(newOrder);
        }
    }

    public static class ETypedElementNormalizer
    implements Normalizer {
        protected final @NonNull ETypedElement eTypedElement;
        protected final EClassifier wasType;
        protected final int wasLower;
        protected final boolean wasOrdered;
        protected final boolean wasUnique;

        public ETypedElementNormalizer(@NonNull ETypedElement eTypedElement) {
            this.eTypedElement = eTypedElement;
            this.wasType = eTypedElement.getEType();
            this.wasLower = eTypedElement.getLowerBound();
            this.wasOrdered = eTypedElement.isOrdered();
            this.wasUnique = eTypedElement.isUnique();
        }

        @Override
        public void denormalize() {
            if (this.wasType == null) {
                this.eTypedElement.setLowerBound(this.wasLower);
            }
            this.eTypedElement.setOrdered(this.wasOrdered);
            this.eTypedElement.setUnique(this.wasUnique);
        }

        @Override
        public void normalize() {
            EClassifier wasType2 = this.wasType;
            if (wasType2 == null) {
                this.eTypedElement.setLowerBound(0);
            } else if (wasType2 instanceof EDataType && ElementUtil.isPrimitiveInstanceClass((EDataType)((EDataType)wasType2))) {
                this.eTypedElement.setLowerBound(1);
            }
            this.eTypedElement.setOrdered(true);
            this.eTypedElement.setUnique(true);
        }
    }

    public static interface Normalizer {
        public void denormalize();

        public void normalize();
    }
}

