/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.base.serializer.CommentSegmentSupport;
import org.eclipse.ocl.xtext.base.serializer.SerializationBuilder;
import org.eclipse.ocl.xtext.base.serializer.UserElementFormatter;
import org.eclipse.ocl.xtext.base.serializer.UserElementSerializer;

public class BaseCommentSegmentSupport
implements CommentSegmentSupport {
    @Override
    public void appendBody(@NonNull SerializationBuilder serializationBuilder, @Nullable String body) {
        int i;
        int bodyLineCount;
        ArrayList<@NonNull String> bodyLines = new ArrayList<String>();
        if (body != null) {
            String[] stringArray = body.split("\n", -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bodyLine = stringArray[n2];
                bodyLines.add(bodyLine);
                ++n2;
            }
        }
        if ((bodyLineCount = bodyLines.size()) <= 0) {
            serializationBuilder.append("/**/");
        } else if (bodyLineCount == 1) {
            serializationBuilder.append("/*");
            serializationBuilder.append((String)bodyLines.get(0));
            serializationBuilder.append("*/");
        } else if (((String)bodyLines.get(0)).startsWith("*")) {
            serializationBuilder.append("/*");
            serializationBuilder.append((String)bodyLines.get(0));
            serializationBuilder.append(SerializationBuilder.PUSH_NEXT);
            serializationBuilder.append(" *");
            i = 1;
            while (i < bodyLineCount - 1) {
                serializationBuilder.append(SerializationBuilder.NEW_LINE);
                String line = (String)bodyLines.get(i);
                if (line.length() > 0) {
                    serializationBuilder.append(" ");
                    serializationBuilder.append(line);
                }
                ++i;
            }
            serializationBuilder.append(SerializationBuilder.NEW_LINE);
            String lastLine = (String)bodyLines.get(bodyLineCount - 1);
            if (lastLine.length() > 0) {
                serializationBuilder.append(lastLine);
                if (!lastLine.endsWith("*")) {
                    serializationBuilder.append(" ");
                }
                serializationBuilder.append("*");
            }
            serializationBuilder.append("/");
            serializationBuilder.append(SerializationBuilder.POP);
        } else {
            serializationBuilder.append("/*");
            serializationBuilder.append((String)bodyLines.get(0));
            i = 1;
            while (i < bodyLineCount - 1) {
                serializationBuilder.append(SerializationBuilder.NEW_LINE);
                String line = (String)bodyLines.get(i);
                if (line.length() > 0) {
                    serializationBuilder.append(line);
                }
                ++i;
            }
            serializationBuilder.append(SerializationBuilder.NEW_LINE);
            String lastLine = (String)bodyLines.get(bodyLineCount - 1);
            if (lastLine.length() > 0) {
                serializationBuilder.append(lastLine);
            }
            serializationBuilder.append("*/");
        }
        serializationBuilder.append(SerializationBuilder.NEW_LINE);
    }

    @Override
    public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
        formatter.addCommentSupport(this);
    }

    @Override
    public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        Element asElement;
        EObject eObject = serializer.getElement();
        if (eObject instanceof Pivotable && (asElement = ((Pivotable)eObject).getPivot()) != null) {
            for (Comment asComment : PivotUtil.getOwnedComments((Element)asElement)) {
                String body = asComment.getBody();
                this.appendBody(serializationBuilder, body);
            }
        }
    }
}

