/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedOppositeNavigationProperty
extends AbstractProperty {
    protected @NonNull PropertyId oppositePropertyId;

    public UnboxedOppositeNavigationProperty(@NonNull PropertyId oppositePropertyId) {
        this.oppositePropertyId = oppositePropertyId;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        IdResolver idResolver = executor.getIdResolver();
        Property oppositeProperty = idResolver.getProperty(this.oppositePropertyId);
        ModelManager.ModelManagerExtension modelManager = (ModelManager.ModelManagerExtension)executor.getModelManager();
        Type thatType = ClassUtil.nonNullModel(oppositeProperty.getType());
        if (thatType instanceof CollectionType) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (thatType instanceof Class) {
            for (Object object : modelManager.get((Class)thatType)) {
                EClass eClass = modelManager.eClass(object);
                EStructuralFeature eFeature = eClass.getEStructuralFeature(oppositeProperty.getName());
                assert (eFeature != null);
                Object eGet = modelManager.eGet(object, eFeature);
                if (eGet != sourceValue) continue;
                results.add(object);
            }
        }
        return results;
    }
}

