/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.filters;

import junit.textui.TestRunner;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.NewValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.tests.filters.ClassFilterTest;
import org.junit.Test;

public class NewValueClassIncludingSubclassesFilterTest
extends ClassFilterTest {
    private Notification noti;
    private EClass cls;
    EClass testSuperCls = EcoreFactory.eINSTANCE.createEClass();
    EClass testCls = EcoreFactory.eINSTANCE.createEClass();

    public static void main(String[] args) {
        TestRunner.run(NewValueClassIncludingSubclassesFilterTest.class);
    }

    public NewValueClassIncludingSubclassesFilterTest() {
        this.testCls.getESuperTypes().add((Object)this.testSuperCls);
    }

    protected NewValueClassFilterIncludingSubclasses getFixture() {
        return (NewValueClassFilterIncludingSubclasses)this.fixture;
    }

    public void setUp() {
        super.setUp();
        this.cls = EcoreFactory.eINSTANCE.createEClass();
        this.cls.setName("my class");
        this.setFixture(EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(this.cls));
    }

    public void tearDown() {
        this.setFixture(null);
        this.cls = null;
        super.tearDown();
    }

    public void testMatchesFor__Notification() {
        this.noti = new ENotificationImpl(null, 3, null, null, (Object)new DynamicEObjectImpl(this.cls));
        NewValueClassIncludingSubclassesFilterTest.assertTrue((String)"exact class match", (boolean)this.getFixture().matchesFor(this.noti));
        this.noti = new ENotificationImpl(null, 3, null, null, (Object)EcoreFactory.eINSTANCE.createEClass());
        NewValueClassIncludingSubclassesFilterTest.assertFalse((boolean)this.getFixture().matchesFor(this.noti));
    }

    @Test
    public void testMatchesFor__SubclassNotification() {
        EClass childCls = EcoreFactory.eINSTANCE.createEClass();
        childCls.setName("child");
        childCls.getESuperTypes().add((Object)this.cls);
        this.noti = new ENotificationImpl(null, 3, null, null, (Object)new DynamicEObjectImpl(childCls));
        NewValueClassIncludingSubclassesFilterTest.assertTrue((String)"exact class match", (boolean)this.getFixture().matchesFor(this.noti));
    }

    public Notification[] giveMatchingNotifications() {
        BasicEList list = new BasicEList();
        list.add((Object)new DynamicEObjectImpl(this.testCls));
        return new Notification[]{new ENotificationImpl(null, 0, null, null, (Object)new DynamicEObjectImpl(this.testCls)), new ENotificationImpl(null, 0, null, null, (Object)list)};
    }

    public Notification giveNotMatchingNotifcation() {
        EClass otherCls = EcoreFactory.eINSTANCE.createEClass();
        return new ENotificationImpl(null, 0, null, null, (Object)new DynamicEObjectImpl(otherCls));
    }

    public EventFilter giveTestFilter() {
        return EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(this.testSuperCls);
    }
}

