/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.tests;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.internal.validation.PivotEAnnotationValidator;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLRuntimeModule;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLRuntimeModule;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreRuntimeModule;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibRuntimeModule;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibStandaloneSetup;
import org.eclipse.xtext.util.EmfFormatter;

public class TestUtil {
    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        @NonNull EList errors = resource.getErrors();
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)prefix, (String)"\n\t");
        if (message != null) {
            TestCase.fail((String)message);
        }
    }

    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        List<XtextTestCase.Normalizer> expectedNormalizations = TestUtil.normalize(expectedResource);
        List<XtextTestCase.Normalizer> actualNormalizations = TestUtil.normalize(actualResource);
        String expected = EmfFormatter.listToStr((List)expectedResource.getContents());
        String actual = EmfFormatter.listToStr((List)actualResource.getContents());
        TestCase.assertEquals((String)expected, (String)actual);
        for (XtextTestCase.Normalizer normalizer : expectedNormalizations) {
            normalizer.denormalize();
        }
        for (XtextTestCase.Normalizer normalizer : actualNormalizations) {
            normalizer.denormalize();
        }
    }

    public static void deleteDirectory(@NonNull File dir) {
        File[] listFiles;
        File[] fileArray = listFiles = dir.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                TestUtil.deleteDirectory(file);
            }
            ++n2;
        }
        dir.delete();
    }

    public static void doCompleteOCLSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompleteOCLStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new CompleteOCLRuntimeModule()});
        }
    }

    public static void doEssentialOCLSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EssentialOCLStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new EssentialOCLRuntimeModule()});
        }
    }

    public static void doOCLinEcoreSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new OCLinEcoreRuntimeModule()});
        }
    }

    public static void doOCLstdlibSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLstdlibStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new OCLstdlibRuntimeModule()});
        }
    }

    public static @NonNull String getName(@NonNull String name) {
        String testNameSuffix = System.getProperty("testNameSuffix", "");
        return String.valueOf(name) + " <" + testNameSuffix + ">";
    }

    public static boolean initializeEcoreEAnnotationValidators() {
        assert (!EMFPlugin.IS_ECLIPSE_RUNNING);
        Map eAnnotationValidatorRegistry2 = PivotEAnnotationValidator.getEAnnotationValidatorRegistry();
        if (eAnnotationValidatorRegistry2 != null) {
            try {
                PivotEAnnotationValidator.installAnnotationValidator((Map)eAnnotationValidatorRegistry2, (String)"org.eclipse.emf.ecore.util.EcoreAnnotationValidator");
                PivotEAnnotationValidator.installAnnotationValidator((Map)eAnnotationValidatorRegistry2, (String)"org.eclipse.emf.ecore.util.ExtendedMetaDataAnnotationValidator");
                PivotEAnnotationValidator.installAnnotationValidator((Map)eAnnotationValidatorRegistry2, (String)"org.eclipse.emf.codegen.ecore.genmodel.util.GenModelAnnotatonValidator");
                EPackage.Registry.INSTANCE.put((Object)"http:///org/eclipse/emf/ecore/util/EcoreAnnotation", (Object)new EPackage.Descriptor(){

                    public EPackage getEPackage() {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        OCL.CLASS_PATH.initializeResourceSet((ResourceSet)resourceSet);
                        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                        Resource eResource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.emf.ecore/model/EcoreAnnotation.ecore", (boolean)true), true);
                        return (EPackage)eResource.getContents().get(0);
                    }

                    public EFactory getEFactory() {
                        return this.getEPackage().getEFactoryInstance();
                    }
                });
                EPackage.Registry.INSTANCE.put((Object)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (Object)new EPackage.Descriptor(){

                    public EPackage getEPackage() {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        OCL.CLASS_PATH.initializeResourceSet((ResourceSet)resourceSet);
                        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                        Resource eResource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.emf.ecore/model/ExtendedMetaData.ecore", (boolean)true), true);
                        return (EPackage)eResource.getContents().get(0);
                    }

                    public EFactory getEFactory() {
                        return this.getEPackage().getEFactoryInstance();
                    }
                });
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<XtextTestCase.Normalizer> normalize(Resource resource) {
        ArrayList<XtextTestCase.Normalizer> normalizers = new ArrayList<XtextTestCase.Normalizer>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EModelElement eModelElement;
            EClass eClass;
            ETypedElement eTypedElement;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof ETypedElement && (eTypedElement = (ETypedElement)eObject).getUpperBound() == 1) {
                EClassifier eType;
                if (!eTypedElement.isOrdered() || !eTypedElement.isUnique()) {
                    normalizers.add(new XtextTestCase.ETypedElementNormalizer(eTypedElement));
                } else if (eTypedElement.getLowerBound() == 0 && (eType = eTypedElement.getEType()) instanceof EDataType && ElementUtil.isPrimitiveInstanceClass((EDataType)((EDataType)eType))) {
                    normalizers.add(new XtextTestCase.ETypedElementNormalizer(eTypedElement));
                }
            }
            if (eObject instanceof EClass && (eClass = (EClass)eObject).getEOperations().size() >= 2) {
                normalizers.add(new XtextTestCase.EOperationsNormalizer(eClass));
            }
            if (eObject instanceof EModelElement && (eModelElement = (EModelElement)eObject).getEAnnotations().size() >= 2) {
                normalizers.add(new XtextTestCase.EAnnotationsNormalizer(eModelElement));
            }
            if (!(eObject instanceof EAnnotation)) continue;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EMap eDetails = eAnnotation.getDetails();
            if (eDetails.size() > 1) {
                normalizers.add(new XtextTestCase.EDetailsNormalizer(eAnnotation));
            }
            if (!"http://www.eclipse.org/emf/2002/Ecore".equals(eAnnotation.getSource()) || !eDetails.containsKey((Object)"constraints")) continue;
            normalizers.add(new XtextTestCase.EAnnotationConstraintsNormalizer(eAnnotation));
        }
        for (XtextTestCase.Normalizer normalizer : normalizers) {
            normalizer.normalize();
        }
        return normalizers;
    }

    public static void saveAsXMI(Resource resource, URI xmiURI, Map<?, ?> options) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource xmiResource = resourceSet.createResource(xmiURI);
        xmiResource.getContents().addAll((Collection)resource.getContents());
        xmiResource.save(options);
        TestUtil.assertNoResourceErrors("Save failed", xmiResource);
        resource.getContents().addAll((Collection)xmiResource.getContents());
    }
}

