/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.query.ui.views.queryExecution.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.ui.Activator;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.QueryResultDisplayer;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class QueryResultDisplayersRegistry
extends AbstractRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.infra.query.ui";
    private static final String EXTENSION_POINT_NAME = "queryResultDisplay";
    private static final String ELEMENT_QUERY_RESULT_DISPLAYER = "queryResultDisplayer";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_NAME = "name";
    private static QueryResultDisplayersRegistry instance = null;
    private final List<NamedQueryResultDisplayer> queryResultDisplayers = new ArrayList<NamedQueryResultDisplayer>();

    public QueryResultDisplayersRegistry() {
        this.initialize();
    }

    public static QueryResultDisplayersRegistry getInstance() {
        if (instance == null) {
            instance = new QueryResultDisplayersRegistry();
        }
        return instance;
    }

    public List<NamedQueryResultDisplayer> getQueryResultDisplayers() {
        return this.queryResultDisplayers;
    }

    public NamedQueryResultDisplayer getQueryResultDisplayer(String name) {
        for (NamedQueryResultDisplayer namedQueryResultDisplayer : this.queryResultDisplayers) {
            if (!name.equals(namedQueryResultDisplayer.getName())) continue;
            return namedQueryResultDisplayer;
        }
        return null;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(ELEMENT_QUERY_RESULT_DISPLAYER)) {
            this.readQueryResultDisplayer(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readQueryResultDisplayer(IConfigurationElement configurationElement) {
        String nameAttribute = configurationElement.getAttribute(ATTRIBUTE_NAME);
        if (nameAttribute == null) {
            this.logMissingAttribute(configurationElement, ATTRIBUTE_NAME);
            return;
        }
        Object queryResultDisplayerObject = null;
        try {
            queryResultDisplayerObject = configurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        if (queryResultDisplayerObject == null) {
            this.logMissingAttribute(configurationElement, ATTRIBUTE_CLASS);
            return;
        }
        if (queryResultDisplayerObject instanceof QueryResultDisplayer) {
            QueryResultDisplayer queryResultDisplayer = (QueryResultDisplayer)queryResultDisplayerObject;
            this.queryResultDisplayers.add(new NamedQueryResultDisplayer(nameAttribute, queryResultDisplayer));
        } else {
            this.logError(configurationElement, NLS.bind((String)"The given class is not a {0}.", (Object)QueryResultDisplayer.class.getSimpleName()));
        }
    }

    public class NamedQueryResultDisplayer {
        private final String name;
        private final QueryResultDisplayer displayer;

        public NamedQueryResultDisplayer(String name, QueryResultDisplayer displayer) {
            this.name = name;
            this.displayer = displayer;
        }

        public String getName() {
            return this.name;
        }

        public QueryResultDisplayer getDisplayer() {
            return this.displayer;
        }
    }
}

