/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main.AcceleoNewMainTemplateWizardPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main.FileBlocksWizardPage;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoNewMainTemplateWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private AcceleoNewMainTemplateWizardPage templatePage;
    private FileBlocksWizardPage fileBlocksPage;

    public AcceleoNewMainTemplateWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizard.Title"));
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.selection = aSelection;
    }

    public void addPages() {
        IStructuredSelection aSelection;
        IContainer firstContainer = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (aSelection = (IStructuredSelection)this.selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IContainer) {
                firstContainer = (IContainer)element;
            } else if (element instanceof IResource) {
                firstContainer = ((IResource)element).getParent();
            }
        }
        String container = "";
        if (firstContainer != null) {
            container = firstContainer.getFullPath().toString();
        }
        this.templatePage = new AcceleoNewMainTemplateWizardPage(container);
        this.addPage((IWizardPage)this.templatePage);
        this.fileBlocksPage = firstContainer != null ? new FileBlocksWizardPage(firstContainer.getProject(), false) : new FileBlocksWizardPage(null, false);
        this.addPage((IWizardPage)this.fileBlocksPage);
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AcceleoNewMainTemplateWizard.this.createTemplate(monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    private void createTemplate(IProgressMonitor monitor) {
        if (this.templatePage.getTemplateContainer().length() > 0 && this.templatePage.getTemplateName().length() > 0) {
            IPath templatePath = new Path(this.templatePage.getTemplateContainer()).append(this.templatePage.getTemplateName()).addFileExtension("mtl");
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(templatePath.segment(0));
                if (project.isAccessible()) {
                    monitor.beginTask(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizard.Task.CreateTemplate", templatePath.lastSegment()), 2);
                    IPath projectRelativePath = templatePath.removeFirstSegments(1);
                    ByteArrayInputStream javaStream = new ByteArrayInputStream(this.createTemplateContent(this.templatePage.getTemplateName()).getBytes("UTF8"));
                    IProject container = project;
                    String[] folders = projectRelativePath.removeLastSegments(1).segments();
                    int i = 0;
                    while (i < folders.length) {
                        if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                            ((IFolder)container).create(true, true, monitor);
                        }
                        ++i;
                    }
                    final IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
                    if (!file.exists()) {
                        file.create((InputStream)javaStream, true, monitor);
                    } else {
                        file.setContents((InputStream)javaStream, true, false, monitor);
                    }
                    monitor.worked(1);
                    monitor.setTaskName(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizard.Task.OpenTemplate"));
                    this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPage aPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)aPage, (IFile)file, (boolean)true);
                            }
                            catch (PartInitException e) {
                                AcceleoUIActivator.log((Exception)((Object)e), true);
                            }
                        }
                    });
                    monitor.worked(1);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (UnsupportedEncodingException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private String createTemplateContent(String moduleName) {
        Template[] templates = this.fileBlocksPage.getSelectedTemplates();
        String defaultEncoding = "UTF-8";
        StringBuilder buffer = new StringBuilder("[comment encoding = ");
        buffer.append(defaultEncoding);
        buffer.append(" /]\n");
        buffer.append("[module " + moduleName + "('");
        TreeSet<String> metamodels = new TreeSet<String>();
        TreeSet<String> imports = new TreeSet<String>();
        this.computeMinimizedHeaderInformation(templates, metamodels, imports);
        Iterator metamodelsIt = metamodels.iterator();
        while (metamodelsIt.hasNext()) {
            buffer.append((String)metamodelsIt.next());
            if (!metamodelsIt.hasNext()) continue;
            buffer.append("', '");
        }
        buffer.append("')/]\n");
        Iterator importsIt = imports.iterator();
        while (importsIt.hasNext()) {
            buffer.append("[import " + (String)importsIt.next() + "/]\n");
        }
        buffer.append("\n");
        if (templates.length > 0) {
            buffer.append("\n");
            this.computeTemplateCalls(buffer, moduleName, templates);
        } else {
            buffer.append("[template public " + moduleName + "(element : OclAny)]\n\t\n");
            buffer.append("\t[comment @main /]\n");
            buffer.append("\t[file (element.name.concat('.java'), false, '" + defaultEncoding + "')]\n");
            buffer.append("\t\t\n");
            buffer.append("\t[/file]\n\t\n");
            buffer.append("[/template]\n");
        }
        return buffer.toString();
    }

    private void computeTemplateCalls(StringBuilder buffer, String moduleName, Template[] templates) {
        TreeSet<String> receiverTypes = new TreeSet<String>();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            receiverTypes.add(this.getTemplateReceiverType(template));
            ++n2;
        }
        for (String receiverType : receiverTypes) {
            String var = receiverType.length() > 0 ? String.valueOf('a') + receiverType : "arg";
            buffer.append("[template public " + moduleName + receiverType + "(" + var + " : " + receiverType + ")]\n");
            buffer.append("\t\n");
            buffer.append("\t[comment @main /]\n");
            Template[] templateArray2 = templates;
            int n3 = templates.length;
            int n4 = 0;
            while (n4 < n3) {
                Template template = templateArray2[n4];
                if (receiverType.equals(this.getTemplateReceiverType(template))) {
                    buffer.append("\t[" + var + ".");
                    buffer.append(template.getName());
                    buffer.append('(');
                    Iterator<String> argumentTypesIt = this.getTemplateArgumentTypes(template).iterator();
                    while (argumentTypesIt.hasNext()) {
                        buffer.append(argumentTypesIt.next());
                        if (!argumentTypesIt.hasNext()) continue;
                        buffer.append(", ");
                    }
                    buffer.append(")/]\n");
                }
                ++n4;
            }
            buffer.append("\t\n");
            buffer.append("[/template]\n");
        }
    }

    private void computeMinimizedHeaderInformation(Template[] templates, Collection<String> metamodels, Collection<String> imports) {
        CompactHashSet done = new CompactHashSet();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            Module module = null;
            EObject parent = template.eContainer();
            while (parent != null) {
                if (parent instanceof Module) {
                    module = (Module)parent;
                    break;
                }
                parent = parent.eContainer();
            }
            if (module != null && !done.contains(module)) {
                done.add(module);
                for (TypedModel typedModel : module.getInput()) {
                    for (EPackage ePackage : typedModel.getTakesTypesFrom()) {
                        String nsURI = ePackage.getNsURI();
                        if (nsURI == null) continue;
                        metamodels.add(nsURI);
                    }
                }
                if (module.getNsURI() != null && module.getNsURI().length() > 0) {
                    imports.add(module.getNsURI());
                } else if (module.getName() != null) {
                    imports.add(module.getName());
                }
            }
            ++n2;
        }
    }

    private List<String> getTemplateArgumentTypes(Template template) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (template != null && template.getParameter().size() > 1) {
            int i = 1;
            while (i < template.getParameter().size()) {
                Variable variable = (Variable)template.getParameter().get(i);
                if (variable != null && variable.getEType() != null) {
                    parameterTypes.add(variable.getEType().getName());
                } else {
                    parameterTypes.add("OclAny");
                }
                ++i;
            }
        }
        return parameterTypes;
    }

    private String getTemplateReceiverType(Template template) {
        Variable variable;
        String context = null;
        if (template != null && template.getParameter().size() > 0 && (variable = (Variable)template.getParameter().get(0)) != null && variable.getEType() != null) {
            context = variable.getEType().getName();
        }
        if (context == null) {
            context = "OclAny";
        }
        return context;
    }
}

