/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.preference;

import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public final class AcceleoPreferences {
    private static final String PREFERENCE_KEY_ENABLE_PROFILER = "org.eclipse.acceleo.profiler.enable";
    private static final String PREFERENCE_KEY_ENABLE_TRACEABILITY = "org.eclipse.acceleo.traceability.enable";
    private static final String PREFERENCE_KEY_ENABLE_QUERY_CACHE = "org.eclipse.acceleo.query.cache.enable";
    private static final String PREFERENCE_KEY_ENABLE_DEBUG_MESSAGES = "org.eclipse.acceleo.debug.messages.enable";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS = "org.eclipse.acceleo.ui.notification";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_FORCED_DEACTIVATION = "org.eclipse.acceleo.ui.notification.forced.deactivation";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_ERROR = "org.eclipse.acceleo.ui.notification.error";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_WARNING = "org.eclipse.acceleo.ui.notification.warning";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_OK = "org.eclipse.acceleo.ui.notification.ok";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_SUCCESS = "org.eclipse.acceleo.ui.notification.success";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_INFO = "org.eclipse.acceleo.ui.notification.info";
    private static final String PREFERENCE_KEY_ENABLE_NOTIFICATIONS_CANCEL = "org.eclipse.acceleo.ui.notification.cancel";
    private static final boolean DEFAULT_ENABLE_PROFILER = false;
    private static final boolean DEFAULT_ENABLE_TRACEABILITY = false;
    private static final boolean DEFAULT_ENABLE_QUERY_CACHE = true;
    private static final boolean DEFAULT_ENABLE_DEBUG_MESSAGES = true;
    private static final boolean DEFAULT_ENABLE_NOTIFICATIONS = true;
    private static final boolean DEFAULT_ENABLE_NOTIFICATIONS_TYPE = true;
    private static final boolean DEFAULT_FORCE_DISABLE_NOTIFICATIONS = false;
    private static final IEclipsePreferences PREFERENCES_SCOPE = new InstanceScope().getNode("org.eclipse.acceleo.common");

    private AcceleoPreferences() {
    }

    public static void switchTraceability(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_TRACEABILITY, state);
    }

    public static boolean isTraceabilityEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_TRACEABILITY, false);
    }

    public static void switchQueryCache(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_QUERY_CACHE, state);
    }

    public static boolean isQueryCacheEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_QUERY_CACHE, true);
    }

    public static void switchProfiler(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_PROFILER, state);
    }

    public static boolean isProfilerEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_PROFILER, false);
    }

    public static void switchDebugMessages(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_DEBUG_MESSAGES, state);
    }

    public static void save() {
        try {
            PREFERENCES_SCOPE.flush();
        }
        catch (BackingStoreException e) {
            AcceleoCommonPlugin.log((Exception)((Object)e), true);
        }
    }

    public static boolean isDebugMessagesEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_DEBUG_MESSAGES, true);
    }

    public static void switchNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS, state);
    }

    public static boolean areNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS, true);
    }

    public static void switchForceDeactivationNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_FORCED_DEACTIVATION, state);
    }

    public static boolean areNotificationsForcedDisabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_FORCED_DEACTIVATION, false);
    }

    public static void switchErrorNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_ERROR, state);
    }

    public static boolean areErrorNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_ERROR, true);
    }

    public static void switchWarningNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_WARNING, state);
    }

    public static boolean areWarningNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_WARNING, true);
    }

    public static void switchOKNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_OK, state);
    }

    public static boolean areOKNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_OK, true);
    }

    public static void switchSuccessNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_SUCCESS, state);
    }

    public static boolean areSuccessNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_SUCCESS, true);
    }

    public static void switchInfoNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_INFO, state);
    }

    public static boolean areInfoNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_INFO, true);
    }

    public static void switchCancelNotifications(boolean state) {
        PREFERENCES_SCOPE.putBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_CANCEL, state);
    }

    public static boolean areCancelNotificationsEnabled() {
        return PREFERENCES_SCOPE.getBoolean(PREFERENCE_KEY_ENABLE_NOTIFICATIONS_CANCEL, true);
    }
}

