/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoMarkerUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionChoice;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserMessage;
import org.eclipse.acceleo.parser.AcceleoParserMessages;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.Documentation;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoSourceContent {
    private static final String DEFAULT_EMTL_URI = "http://acceleo.eclipse.org/default.emtl";
    private static final String MARKER_POSITION_SEPARATOR = ",";
    protected int syntaxHelpCount;
    protected ResourceSet syntaxHelpResourceSet;
    protected IFile file;
    protected AcceleoSourceBufferWithASTJob source;
    private AcceleoProject acceleoProject;
    private CSTParser cstParser;
    private SyntaxHelpJob syntaxHelpUnloadJob = new SyntaxHelpJob();
    private List<URI> accessibleOutputFiles;

    public void cancelTasks() {
        if (this.source != null) {
            this.source.cancel();
            this.source.getProblems().clear();
            this.source.getWarnings().clear();
            this.source.getInfos().clear();
        }
    }

    public org.eclipse.acceleo.parser.cst.Module getCST() {
        if (this.source == null) {
            return null;
        }
        if (this.source.getCST() == null) {
            this.createCST();
        }
        return this.source.getCST();
    }

    public Module getAST() {
        if (this.source == null) {
            return null;
        }
        if (this.source.getAST() == null) {
            this.createAST();
        }
        return this.source.getAST();
    }

    public IFile getFile() {
        return this.file;
    }

    public void init(StringBuffer text) {
        this.init(text, null);
    }

    public void init(StringBuffer text, IFile aFile) {
        this.file = aFile;
        this.acceleoProject = this.file != null ? new AcceleoProject(this.file.getProject()) : null;
        this.source = new AcceleoSourceBufferWithASTJob(text);
        this.cstParser = new CSTParser((AcceleoSourceBuffer)this.source);
    }

    public void createCST() {
        this.source.getProblems().clear();
        this.source.getWarnings().clear();
        this.source.getInfos().clear();
        this.source.createCST();
    }

    public CSTNode updateCST(int posBegin, int posEnd, String newText) {
        this.source.getProblems().clear();
        this.source.getWarnings().clear();
        this.source.getInfos().clear();
        this.source.getBuffer().replace(posBegin, posEnd, newText);
        CSTNode current = this.getCSTNode(posBegin, posEnd);
        if (current instanceof TextExpression && newText.indexOf("[") > -1) {
            current = (CSTNode)current.eContainer();
        }
        if (!(current == null || posBegin != posEnd || posBegin != current.getStartPosition() || current instanceof TextExpression || current instanceof Variable || current instanceof ModelExpression)) {
            current = (CSTNode)current.eContainer();
        }
        while (current != null) {
            ModelExpression oldExpression;
            int shift;
            int newPosEnd;
            EObject modified = null;
            if (current instanceof org.eclipse.acceleo.parser.cst.ModuleElement && ((org.eclipse.acceleo.parser.cst.ModuleElement)current).eContainingFeature() == CstPackage.eINSTANCE.getModule_OwnedModuleElement()) {
                org.eclipse.acceleo.parser.cst.ModuleElement oldModuleElement = (org.eclipse.acceleo.parser.cst.ModuleElement)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceModuleElement(oldModuleElement);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof org.eclipse.acceleo.parser.cst.ModuleElement && ((org.eclipse.acceleo.parser.cst.ModuleElement)current).eContainingFeature() == CstPackage.eINSTANCE.getModule_Documentation()) {
                Documentation oldDocumentation = (Documentation)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceModuleDocumentation(oldDocumentation);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof ModelExpression) {
                oldExpression = (ModelExpression)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceModelExpression(oldExpression);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof TemplateExpression) {
                oldExpression = (TemplateExpression)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceTemplateExpression((TemplateExpression)oldExpression);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            } else if (current instanceof Variable) {
                Variable oldVariable = (Variable)current;
                newPosEnd = posBegin + newText.length();
                shift = newPosEnd - posEnd;
                this.shiftPositionsAfter(posBegin, shift);
                modified = this.replaceVariable(oldVariable);
                if (modified == null) {
                    this.shiftPositionsAfter(posBegin + shift, -shift);
                }
            }
            if (modified instanceof CSTNode) {
                this.source.refreshAST();
                return (CSTNode)modified;
            }
            current = (CSTNode)current.eContainer();
        }
        this.doSave();
        return this.source.getCST();
    }

    public void doSave() {
        if (this.source != null) {
            this.source.cancel();
            this.source.getProblems().clear();
            this.source.getWarnings().clear();
            this.source.getInfos().clear();
            this.source.createCST();
        }
    }

    private EObject replaceModuleDocumentation(Documentation oldDocumentation) {
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        this.cstParser.parseModuleDocumentation(0, tempModule);
        if (tempModule.getDocumentation() != null) {
            try {
                Documentation newDocumentation = tempModule.getDocumentation();
                EcoreUtil.replace((EObject)oldDocumentation, (EObject)newDocumentation);
                return newDocumentation;
            }
            catch (ClassCastException e) {
                AcceleoUIActivator.log(e, true);
            }
            catch (ArrayStoreException e) {
                AcceleoUIActivator.log(e, true);
            }
        }
        return null;
    }

    private EObject replaceModuleElement(org.eclipse.acceleo.parser.cst.ModuleElement oldModuleElement) {
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        this.cstParser.parseModuleBody(oldModuleElement.getStartPosition(), oldModuleElement.getEndPosition(), tempModule);
        if (tempModule.getOwnedModuleElement().size() > 0) {
            try {
                org.eclipse.acceleo.parser.cst.ModuleElement newModuleElement = (org.eclipse.acceleo.parser.cst.ModuleElement)tempModule.getOwnedModuleElement().get(0);
                EcoreUtil.replace((EObject)oldModuleElement, (EObject)newModuleElement);
                return newModuleElement;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    private ModelExpression replaceModelExpression(ModelExpression oldExpression) {
        oldExpression.setBefore(null);
        oldExpression.setEach(null);
        oldExpression.setAfter(null);
        this.cstParser.getPBlock().parseExpressionHeader(oldExpression.getStartPosition(), oldExpression.getEndPosition(), oldExpression);
        return oldExpression;
    }

    private EObject replaceTemplateExpression(TemplateExpression oldExpression) {
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        Template tempBlock = CstFactory.eINSTANCE.createTemplate();
        tempModule.getOwnedModuleElement().add((Object)tempBlock);
        this.cstParser.getPBlock().parse(oldExpression.getStartPosition(), oldExpression.getEndPosition(), (Block)tempBlock);
        if (tempBlock.getBody().size() > 0) {
            try {
                TemplateExpression newExpression = (TemplateExpression)tempBlock.getBody().get(0);
                EcoreUtil.replace((EObject)oldExpression, (EObject)newExpression);
                return newExpression;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    private EObject replaceVariable(Variable oldVariable) {
        Variable newVariable;
        org.eclipse.acceleo.parser.cst.Module tempModule = CstFactory.eINSTANCE.createModule();
        if (this.getCST() != null) {
            tempModule.getInput().addAll(EcoreUtil.copyAll((Collection)this.getCST().getInput()));
        }
        if ((newVariable = this.cstParser.createVariable(oldVariable.getStartPosition(), oldVariable.getEndPosition())) != null) {
            try {
                EcoreUtil.replace((EObject)oldVariable, (EObject)newVariable);
                return newVariable;
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void shiftPositionsAfter(int index, int shift) {
        if (this.getCST() != null) {
            TreeIterator eAllContents = this.getCST().eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof CSTNode)) continue;
                CSTNode cstNode = (CSTNode)eObject;
                this.shiftPositionsAfter(cstNode, index, shift);
            }
        }
    }

    private void shiftPositionsAfter(CSTNode candidate, int index, int shift) {
        if (candidate instanceof TextExpression || candidate instanceof Variable || candidate instanceof ModelExpression) {
            if (candidate.getStartPosition() > index) {
                assert (candidate.getStartPosition() + shift > -1);
                candidate.setStartPosition(candidate.getStartPosition() + shift);
            }
            if (candidate.getEndPosition() >= index) {
                assert (candidate.getEndPosition() + shift > -1);
                candidate.setEndPosition(candidate.getEndPosition() + shift);
            }
        } else {
            if (candidate.getStartPosition() >= index) {
                assert (candidate.getStartPosition() + shift > -1);
                candidate.setStartPosition(candidate.getStartPosition() + shift);
            }
            if (candidate.getEndPosition() > index) {
                assert (candidate.getEndPosition() + shift > -1);
                candidate.setEndPosition(candidate.getEndPosition() + shift);
            }
        }
    }

    public CSTNode getCSTNode(int posBegin, int posEnd) {
        if (this.getCST() != null) {
            org.eclipse.acceleo.parser.cst.Module candidate = this.getCST();
            CSTNode childrenCandidate = this.getChildrenCandidate((CSTNode)candidate, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((CSTNode)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    private CSTNode getChildrenCandidate(CSTNode candidate, int posBegin, int posEnd) {
        for (CSTNode eContent : candidate.eContents()) {
            int startPosition = eContent.getStartPosition();
            int endPosition = eContent.getEndPosition();
            assert (startPosition > -1 && endPosition > -1);
            if (startPosition > posBegin || endPosition < posEnd) continue;
            return eContent;
        }
        return null;
    }

    public CSTNode getCSTParent(CSTNode node, Class c) {
        CSTNode eContainer = (CSTNode)node.eContainer();
        while (eContainer != null) {
            if (c.isInstance(eContainer)) {
                return eContainer;
            }
            eContainer = (CSTNode)eContainer.eContainer();
        }
        return null;
    }

    public ASTNode getASTParent(ASTNode node, Class c) {
        ASTNode eContainer = (ASTNode)node.eContainer();
        while (eContainer != null) {
            if (c.isInstance(eContainer)) {
                return eContainer;
            }
            eContainer = (ASTNode)eContainer.eContainer();
        }
        return null;
    }

    public Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        return this.source.getOCLEnvironment();
    }

    public synchronized Collection<Choice> getSyntaxHelp(String text, int offset) {
        ++this.syntaxHelpCount;
        try {
            EClassifier eContext;
            OCLParser oclParser;
            if (this.getCST() != null) {
                Module vAST = this.source.getAST();
                if (vAST == null) {
                    this.createAST();
                    vAST = this.source.getAST();
                }
                if (vAST != null) {
                    Resource resource;
                    URI uri = vAST.eResource().getURI();
                    vAST = (Module)EcoreUtil.copy((EObject)vAST);
                    if (this.syntaxHelpResourceSet == null) {
                        this.syntaxHelpResourceSet = new ResourceSetImpl();
                    }
                    if (this.syntaxHelpResourceSet.getResources().size() > 0) {
                        resource = (Resource)this.syntaxHelpResourceSet.getResources().get(0);
                        resource.unload();
                    } else {
                        resource = this.syntaxHelpResourceSet.createResource(uri);
                    }
                    resource.getContents().add((Object)vAST);
                    oclParser = new OCLParser(resource);
                    if (!this.getCST().getImports().isEmpty() || !this.getCST().getExtends().isEmpty()) {
                        List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
                        this.loadImportsDependencies(vAST, dependenciesURIs);
                        this.loadExtendsDependencies(vAST, dependenciesURIs);
                    }
                    oclParser.addRecursivelyMetamodelsToScope(vAST);
                    boolean isAfterDot = this.isAfterDot(text);
                    oclParser.addRecursivelyBehavioralFeaturesToScope(vAST, true, !isAfterDot, this.getCurrentQualifiedName(text));
                    int specificOffset = this.getSpecificOffset(offset);
                    eContext = oclParser.addRecursivelyVariablesToScopeAndGetContextClassifierAt(vAST, specificOffset);
                    if (this.isPostOffset(offset)) {
                        eContext = oclParser.getStringType();
                    }
                    if (eContext != null) {
                        oclParser.pushContext(eContext);
                    }
                    Collection<Choice> order = this.order(oclParser.getSyntaxHelp(text), oclParser);
                    oclParser.dispose();
                    Collection<Choice> collection = order;
                    return collection;
                }
            }
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            return arrayList;
            finally {
                if (eContext != null) {
                    oclParser.popContext();
                }
                this.syntaxHelpUnloadJob.run();
                oclParser.dispose();
            }
        }
        finally {
            --this.syntaxHelpCount;
        }
    }

    private Collection<Choice> order(List<Choice> choices, OCLParser oclParser) {
        ArrayList<Choice> orderedChoices = new ArrayList<Choice>(choices.size());
        for (Choice choice : choices) {
            EOperation eOperation;
            ModuleElement eModuleElement;
            if (choice.getElement() instanceof EOperation && (eModuleElement = oclParser.getModuleElement(eOperation = (EOperation)choice.getElement())) != null) {
                AcceleoCompletionChoice acceleoChoice = new AcceleoCompletionChoice(choice, eModuleElement);
                choice = acceleoChoice;
            }
            orderedChoices.add(choice);
        }
        Collections.sort(orderedChoices, new ChoiceComparator());
        return orderedChoices;
    }

    private boolean isAfterDot(String text) {
        boolean isAfterDot = false;
        int i = text.length() - 1;
        while (!isAfterDot && i >= 0) {
            char c = text.charAt(i);
            if (c == '.') {
                isAfterDot = true;
            } else if (!Character.isJavaIdentifierPart(c)) break;
            --i;
        }
        return isAfterDot;
    }

    private String getCurrentQualifiedName(String text) {
        StringBuffer result = new StringBuffer();
        int i = text.length() - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) break;
            result.insert(0, c);
            --i;
        }
        return result.toString();
    }

    private int getSpecificOffset(int offset) {
        CSTNode cstNode = this.getCSTNode(offset, offset);
        int result = offset;
        if (cstNode != null) {
            EObject eContainer = cstNode.eContainer();
            EStructuralFeature eContainingFeature = cstNode.eContainingFeature();
            if (cstNode instanceof ModelExpression && eContainer instanceof ForBlock) {
                if (eContainingFeature == CstPackage.eINSTANCE.getForBlock_IterSet() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_Before() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_Each() || eContainingFeature == CstPackage.eINSTANCE.getForBlock_After()) {
                    result = ((ForBlock)eContainer).getStartPosition();
                }
            } else if (cstNode instanceof TemplateOverridesValue && eContainer instanceof Template) {
                result = ((Template)eContainer).getStartPosition();
            } else if (cstNode instanceof Variable) {
                result = cstNode.getStartPosition();
            }
        }
        return result;
    }

    private boolean isPostOffset(int offset) {
        CSTNode cstNode = this.getCSTNode(offset, offset);
        if (cstNode != null) {
            EObject eContainer = cstNode.eContainer();
            EStructuralFeature eContainingFeature = cstNode.eContainingFeature();
            if (cstNode instanceof ModelExpression && eContainer instanceof Template && eContainingFeature == CstPackage.eINSTANCE.getTemplate_Post()) {
                return true;
            }
        }
        return false;
    }

    protected void loadImportsDependencies(Module vAST, List<URI> dependenciesURIs) {
        block0: for (URI oURI : dependenciesURIs) {
            String oName = new Path(oURI.lastSegment()).removeFileExtension().lastSegment();
            for (ModuleImportsValue moduleImportsValue : this.getCST().getImports()) {
                if (moduleImportsValue == null || moduleImportsValue.getName() == null || !("::" + moduleImportsValue.getName()).endsWith("::" + oName)) continue;
                Module otherModule = this.getModule(vAST.eResource().getResourceSet(), oURI);
                if (otherModule == null || !moduleImportsValue.getName().equals(otherModule.getNsURI()) && !moduleImportsValue.getName().equals(otherModule.getName()) || vAST.getImports().contains((Object)otherModule)) continue block0;
                vAST.getImports().add((Object)otherModule);
                continue block0;
            }
        }
    }

    protected void loadExtendsDependencies(Module vAST, List<URI> dependenciesURIs) {
        block0: for (URI oURI : dependenciesURIs) {
            String oName = new Path(oURI.lastSegment()).removeFileExtension().lastSegment();
            for (ModuleExtendsValue moduleExtendsValue : this.getCST().getExtends()) {
                if (moduleExtendsValue == null || moduleExtendsValue.getName() == null || !("::" + moduleExtendsValue.getName()).endsWith("::" + oName)) continue;
                Module otherModule = this.getModule(vAST.eResource().getResourceSet(), oURI);
                if (otherModule == null || !moduleExtendsValue.getName().equals(otherModule.getNsURI()) && !moduleExtendsValue.getName().equals(otherModule.getName()) || vAST.getExtends().contains((Object)otherModule)) continue block0;
                vAST.getExtends().add((Object)otherModule);
                continue block0;
            }
        }
    }

    protected Map<String, IMarker> initMarkers(Map<String, IMarker> position2marker, IFile fileMTL, String markerID) {
        try {
            IMarker[] taskMarkers;
            IMarker[] markers = fileMTL.findMarkers(markerID, false, 2);
            if ("org.eclipse.acceleo.ide.ui.info".equals(markerID) && (taskMarkers = fileMTL.findMarkers("org.eclipse.core.resources.taskmarker", false, 2)).length > 0) {
                IMarker[] markersArray = new IMarker[markers.length + taskMarkers.length];
                System.arraycopy(markers, 0, markersArray, 0, markers.length);
                System.arraycopy(taskMarkers, 0, markersArray, markers.length, taskMarkers.length);
            }
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String key = String.valueOf(MarkerUtilities.getCharStart((IMarker)marker)) + MARKER_POSITION_SEPARATOR + MarkerUtilities.getCharEnd((IMarker)marker);
                if (position2marker.containsKey(key)) {
                    marker.delete();
                } else {
                    position2marker.put(key, marker);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            AcceleoUIActivator.getDefault().getLog().log(ex.getStatus());
        }
        return position2marker;
    }

    protected void manageMarker(AcceleoParserMessages acceleoParserDatas, Map<String, IMarker> position2marker, IFile fileMTL) {
        if (acceleoParserDatas == null) {
            return;
        }
        List messageList = null;
        String markerId = null;
        if (acceleoParserDatas instanceof AcceleoParserProblems) {
            AcceleoParserProblems acceleoParserProblems = (AcceleoParserProblems)acceleoParserDatas;
            messageList = acceleoParserProblems.getList();
            markerId = "org.eclipse.acceleo.ide.ui.problem";
        } else if (acceleoParserDatas instanceof AcceleoParserWarnings) {
            AcceleoParserWarnings acceleoParserWarnings = (AcceleoParserWarnings)acceleoParserDatas;
            messageList = acceleoParserWarnings.getList();
            markerId = "org.eclipse.acceleo.ide.ui.warning";
        } else if (acceleoParserDatas instanceof AcceleoParserInfos) {
            AcceleoParserInfos acceleoParserInfos = (AcceleoParserInfos)acceleoParserDatas;
            messageList = acceleoParserInfos.getList();
            markerId = "org.eclipse.acceleo.ide.ui.info";
        } else {
            return;
        }
        for (AcceleoParserMessage message : messageList) {
            try {
                String key = String.valueOf(message.getPosBegin()) + MARKER_POSITION_SEPARATOR + message.getPosEnd();
                if (!position2marker.containsKey(key)) {
                    AcceleoMarkerUtils.createMarkerOnFile(markerId, fileMTL, message.getLine(), message.getPosBegin(), message.getPosEnd(), message.getMessage());
                    continue;
                }
                position2marker.remove(key);
            }
            catch (CoreException ex) {
                AcceleoUIActivator.getDefault().getLog().log(ex.getStatus());
            }
        }
        for (IMarker markerToDelete : position2marker.values()) {
            try {
                markerToDelete.delete();
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private Module getModule(ResourceSet resourceSet, URI uri) {
        block4: {
            try {
                EObject root;
                if (resourceSet != null && (root = ModelUtils.load((URI)uri, (ResourceSet)resourceSet)) instanceof Module) {
                    return (Module)root;
                }
            }
            catch (IOException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
            catch (WrappedException e) {
                if (e.getMessage().endsWith(".emtl' does not exist.")) break block4;
                throw e;
            }
        }
        return null;
    }

    public List<EClassifier> getTypes() {
        if (this.getCST() != null) {
            Module vAST = this.source.getAST();
            if (vAST == null) {
                this.createAST();
                vAST = this.source.getAST();
            }
            if (vAST != null) {
                URI uri = vAST.eResource().getURI();
                vAST = (Module)EcoreUtil.copy((EObject)vAST);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = ModelUtils.createResource((URI)uri, (ResourceSet)resourceSet);
                resource.getContents().add((Object)vAST);
                OCLParser oclParser = new OCLParser(resource);
                List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
                this.loadImportsDependencies(vAST, dependenciesURIs);
                this.loadExtendsDependencies(vAST, dependenciesURIs);
                oclParser.addRecursivelyMetamodelsToScope(vAST);
                List result = oclParser.getTypes();
                Iterator resources = resourceSet.getResources().iterator();
                while (resources.hasNext()) {
                    ((Resource)resources.next()).unload();
                }
                oclParser.dispose();
                return result;
            }
        }
        return new ArrayList<EClassifier>();
    }

    public List<URI> getAccessibleOutputFiles() {
        if (this.accessibleOutputFiles == null && this.acceleoProject != null) {
            this.accessibleOutputFiles = this.acceleoProject.getAccessibleOutputFiles();
        }
        if (this.accessibleOutputFiles != null) {
            return new ArrayList<URI>(this.accessibleOutputFiles);
        }
        return new ArrayList<URI>();
    }

    protected void resetAccessibleOutputFilesCache() {
        this.accessibleOutputFiles = null;
    }

    public String getText() {
        return this.source.getBuffer().toString();
    }

    protected void createAST() {
        IPath outputPath;
        URI fileURI = this.file != null ? ((outputPath = this.acceleoProject.getOutputFilePath(this.file)) != null ? URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false) : URI.createPlatformResourceURI((String)this.file.getFullPath().removeFileExtension().addFileExtension("emtl").toString(), (boolean)false)) : URI.createURI((String)DEFAULT_EMTL_URI);
        ResourceSetImpl oResourceSet = new ResourceSetImpl();
        Resource oResource = ModelUtils.createResource((URI)fileURI, (ResourceSet)oResourceSet);
        ArrayList<URI> resourceSetURIs = new ArrayList<URI>();
        resourceSetURIs.add(fileURI);
        this.source.createAST(oResource);
    }

    public ASTNode getResolvedASTNode(int posBegin, int posEnd) {
        Module vAST;
        if (posBegin > -1 && (vAST = this.getAST()) != null) {
            List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
            this.loadImportsDependencies(vAST, dependenciesURIs);
            this.loadExtendsDependencies(vAST, dependenciesURIs);
            this.source.resolveAST(posBegin, posEnd);
            ASTNode candidate = null;
            ASTNode childrenCandidate = this.getChildrenCandidate((EObject)vAST, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((EObject)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    public boolean isInModuleHeader(int posBegin, int posEnd, boolean inAST) {
        int beginHeaderModule = -1;
        if (inAST) {
            if (this.getAST() == null) {
                this.createAST();
            }
            beginHeaderModule = this.getAST().getStartHeaderPosition();
        } else {
            beginHeaderModule = this.getCST().getStartPosition();
        }
        int endHeaderModule = this.source.getBuffer().indexOf("/]", beginHeaderModule);
        return posBegin >= beginHeaderModule && posBegin <= endHeaderModule && posEnd >= beginHeaderModule && posEnd <= endHeaderModule && posBegin >= posEnd;
    }

    public ASTNode getASTNode(int posBegin, int posEnd) {
        Module vAST;
        if (posBegin > -1 && (vAST = this.getAST()) != null) {
            List<URI> dependenciesURIs = this.getAccessibleOutputFiles();
            this.loadImportsDependencies(vAST, dependenciesURIs);
            this.loadExtendsDependencies(vAST, dependenciesURIs);
            ASTNode candidate = null;
            ASTNode childrenCandidate = this.getChildrenCandidate((EObject)vAST, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((EObject)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    public ASTNode getASTNodeWithoutImportsExtends(int posBegin, int posEnd) {
        Module vAST;
        if (posBegin > -1 && (vAST = this.getAST()) != null) {
            ASTNode candidate = null;
            ASTNode childrenCandidate = this.getChildrenCandidate((EObject)vAST, posBegin, posEnd);
            while (childrenCandidate != null) {
                candidate = childrenCandidate;
                childrenCandidate = this.getChildrenCandidate((EObject)candidate, posBegin, posEnd);
            }
            return candidate;
        }
        return null;
    }

    private ASTNode getChildrenCandidate(EObject candidate, int posBegin, int posEnd) {
        Iterator itContents = candidate.eContents().iterator();
        while (itContents.hasNext()) {
            ASTNode astNode = null;
            EObject eContent = (EObject)itContents.next();
            if (eContent instanceof ASTNode) {
                astNode = (ASTNode)eContent;
            } else if (eContent instanceof CollectionItem) {
                astNode = ((CollectionItem)eContent).getItem();
            }
            if (astNode == null) continue;
            int startPosition = astNode.getStartPosition();
            int endPosition = astNode.getEndPosition();
            if (startPosition <= -1 || endPosition <= -1 || startPosition > posBegin || endPosition < posEnd) continue;
            return astNode;
        }
        return null;
    }

    protected int compareOperations(Choice arg0, Choice arg1) {
        boolean arg1IsQuery;
        boolean arg0IsTemplate = arg0 instanceof AcceleoCompletionChoice && ((AcceleoCompletionChoice)arg0).getAcceleoElement() instanceof org.eclipse.acceleo.model.mtl.Template;
        boolean arg1IsTemplate = arg1 instanceof AcceleoCompletionChoice && ((AcceleoCompletionChoice)arg1).getAcceleoElement() instanceof org.eclipse.acceleo.model.mtl.Template;
        boolean arg0IsQuery = arg0 instanceof AcceleoCompletionChoice && ((AcceleoCompletionChoice)arg0).getAcceleoElement() instanceof Query;
        boolean bl = arg1IsQuery = arg1 instanceof AcceleoCompletionChoice && ((AcceleoCompletionChoice)arg1).getAcceleoElement() instanceof Query;
        int value = arg0IsTemplate ? (arg1IsTemplate ? arg0.getName().compareTo(arg1.getName()) : -1) : (arg0IsQuery ? (arg1IsTemplate ? 1 : (arg1IsQuery ? arg0.getName().compareTo(arg1.getName()) : -1)) : (arg1IsTemplate ? 1 : (arg1IsQuery ? 1 : arg0.getName().compareTo(arg1.getName()))));
        return value;
    }

    protected class AcceleoSourceBufferWithASTJob
    extends AcceleoSourceBuffer {
        private Job createASTJob;

        public AcceleoSourceBufferWithASTJob(StringBuffer buffer) {
            super(buffer);
        }

        public void refreshAST() {
            if (this.createASTJob != null) {
                this.createASTJob.cancel();
            }
            this.createASTJob = this.createASTJob();
            this.createASTJob.setPriority(50);
            this.createASTJob.setSystem(true);
            int schedule = 1500;
            this.createASTJob.schedule(1500L);
        }

        public void cancel() {
            if (this.createASTJob != null) {
                this.createASTJob.cancel();
            }
        }

        private Job createASTJob() {
            return new Job("Acceleo"){

                protected IStatus run(IProgressMonitor monitor) {
                    AcceleoSourceBufferWithASTJob.this.ast = null;
                    AcceleoSourceBufferWithASTJob.this.runCreateAST();
                    if (AcceleoSourceBufferWithASTJob.this.astCreator != null) {
                        AcceleoSourceBufferWithASTJob.this.astCreator.canceling(false);
                    }
                    return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
                }

                protected void canceling() {
                    super.canceling();
                    if (AcceleoSourceBufferWithASTJob.this.astCreator != null) {
                        AcceleoSourceBufferWithASTJob.this.astCreator.canceling(true);
                    }
                }
            };
        }

        protected void runCreateAST() {
            IFile fileMTL = AcceleoSourceContent.this.file;
            if (fileMTL != null && fileMTL.exists()) {
                Map<String, IMarker> position2problemMarkers = new HashMap<String, IMarker>();
                position2problemMarkers = AcceleoSourceContent.this.initMarkers(position2problemMarkers, fileMTL, "org.eclipse.acceleo.ide.ui.problem");
                Map<String, IMarker> position2warningMarkers = new HashMap<String, IMarker>();
                position2warningMarkers = AcceleoSourceContent.this.initMarkers(position2warningMarkers, fileMTL, "org.eclipse.acceleo.ide.ui.warning");
                Map<String, IMarker> position2infoMarkers = new HashMap<String, IMarker>();
                position2infoMarkers = AcceleoSourceContent.this.initMarkers(position2infoMarkers, fileMTL, "org.eclipse.acceleo.ide.ui.info");
                AcceleoSourceContent.this.createAST();
                Module vAST = this.getAST();
                if (vAST != null) {
                    List<URI> dependenciesURIs = AcceleoSourceContent.this.getAccessibleOutputFiles();
                    AcceleoSourceContent.this.loadImportsDependencies(vAST, dependenciesURIs);
                    AcceleoSourceContent.this.loadExtendsDependencies(vAST, dependenciesURIs);
                    AcceleoSourceContent.this.source.resolveAST();
                    AcceleoSourceContent.this.source.resolveASTDocumentation();
                }
                AcceleoParserProblems problems = AcceleoSourceContent.this.source.getProblems();
                AcceleoSourceContent.this.manageMarker((AcceleoParserMessages)problems, position2problemMarkers, fileMTL);
                AcceleoSourceContent.this.source.getProblems().clear();
                AcceleoParserWarnings warnings = AcceleoSourceContent.this.source.getWarnings();
                AcceleoSourceContent.this.manageMarker((AcceleoParserMessages)warnings, position2warningMarkers, fileMTL);
                AcceleoSourceContent.this.source.getWarnings().clear();
                AcceleoParserInfos infos = AcceleoSourceContent.this.source.getInfos();
                AcceleoSourceContent.this.manageMarker((AcceleoParserMessages)infos, position2infoMarkers, fileMTL);
                AcceleoSourceContent.this.source.getInfos().clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChoiceComparator
    implements Comparator<Choice> {
        protected ChoiceComparator() {
        }

        @Override
        public int compare(Choice arg0, Choice arg1) {
            int value = arg0.getKind() == ChoiceKind.VARIABLE ? (arg1.getKind() == ChoiceKind.VARIABLE ? arg0.getName().compareTo(arg1.getName()) : -1) : (arg0.getKind() == ChoiceKind.PROPERTY ? (arg1.getKind() == ChoiceKind.VARIABLE ? 1 : (arg1.getKind() == ChoiceKind.PROPERTY ? arg0.getName().compareTo(arg1.getName()) : -1)) : (arg0.getKind() == ChoiceKind.OPERATION ? (arg1.getKind() == ChoiceKind.VARIABLE ? 1 : (arg1.getKind() == ChoiceKind.PROPERTY ? 1 : (arg1.getKind() == ChoiceKind.OPERATION ? AcceleoSourceContent.this.compareOperations(arg0, arg1) : -1))) : (arg1.getKind() == ChoiceKind.VARIABLE ? 1 : (arg1.getKind() == ChoiceKind.PROPERTY ? 1 : (arg1.getKind() == ChoiceKind.OPERATION ? 1 : arg0.getName().compareTo(arg1.getName()))))));
            return value;
        }
    }

    protected class SyntaxHelpJob {
        Job unloadJob;

        protected SyntaxHelpJob() {
        }

        public void run() {
            if (this.unloadJob != null) {
                this.unloadJob.cancel();
            }
            this.unloadJob = new Job("Acceleo"){

                protected IStatus run(IProgressMonitor monitor) {
                    ResourceSet resourceSet = ((SyntaxHelpJob)SyntaxHelpJob.this).AcceleoSourceContent.this.syntaxHelpResourceSet;
                    if (((SyntaxHelpJob)SyntaxHelpJob.this).AcceleoSourceContent.this.syntaxHelpCount == 0) {
                        ((SyntaxHelpJob)SyntaxHelpJob.this).AcceleoSourceContent.this.syntaxHelpResourceSet = null;
                        if (resourceSet != null) {
                            Iterator resources = resourceSet.getResources().iterator();
                            while (resources.hasNext()) {
                                ((Resource)resources.next()).unload();
                            }
                            resourceSet.getResources().clear();
                        }
                    }
                    return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
                }
            };
            this.unloadJob.setPriority(50);
            this.unloadJob.setSystem(true);
            int delay = 4000;
            this.unloadJob.schedule(4000L);
        }
    }
}

