/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl.environment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoUMLReflection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractTypeResolver;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.internal.OCLEcorePlugin;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.ecore.internal.TupleFactory;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoTypeResolver
extends AbstractTypeResolver<EPackage, EClassifier, EOperation, EStructuralFeature, EParameter> {
    public AcceleoTypeResolver(EcoreEnvironment env) {
        super((Environment)env);
    }

    public AcceleoTypeResolver(EcoreEnvironment env, Resource resource) {
        super((Environment)env, resource);
    }

    public static boolean classifierEqual(EClassifier shadowedClassifier, EClassifier type) {
        boolean result = true;
        if (shadowedClassifier != null && type != null && shadowedClassifier.getName() != null) {
            result = result && shadowedClassifier.getName().equals(type.getName());
            EObject shadowedEContainer = shadowedClassifier.eContainer();
            EObject typeEContainer = type.eContainer();
            if (shadowedEContainer instanceof ENamedElement && typeEContainer instanceof ENamedElement) {
                boolean bl = result = result && ((ENamedElement)shadowedEContainer).getName() != null && ((ENamedElement)shadowedEContainer).getName().equals(((ENamedElement)typeEContainer).getName());
            }
            if (shadowedEContainer != null && typeEContainer != null) {
                boolean bl = result = result && EcoreUtil.getURI((EObject)shadowedEContainer).equals((Object)EcoreUtil.getURI((EObject)typeEContainer));
            }
            if (shadowedClassifier instanceof EClass && type instanceof EClass) {
                EClass shadowClass = (EClass)shadowedClassifier;
                EClass typeClass = (EClass)type;
                EList shadowEAllAttributes = shadowClass.getEAllAttributes();
                EList typeEAllAttributes = typeClass.getEAllAttributes();
                if (shadowEAllAttributes != null && typeEAllAttributes != null) {
                    boolean bl = result = result && shadowEAllAttributes.size() == typeEAllAttributes.size();
                }
                if (!result || shadowEAllAttributes == null || typeEAllAttributes == null) {
                    return result;
                }
                int i = 0;
                while (i < shadowEAllAttributes.size()) {
                    EAttribute shadowEAttribute = (EAttribute)shadowEAllAttributes.get(i);
                    EAttribute typeEAttribute = (EAttribute)typeEAllAttributes.get(i);
                    if (shadowEAttribute != null && typeEAttribute != null && shadowEAttribute.getName() != null) {
                        boolean bl = result = result && shadowEAttribute.getName().equals(((EAttribute)typeEAllAttributes.get(i)).getName());
                    }
                    if (shadowEAttribute != null && typeEAttribute != null) {
                        result = result && shadowEAttribute.getLowerBound() == typeEAttribute.getLowerBound();
                        result = result && shadowEAttribute.getUpperBound() == typeEAttribute.getUpperBound();
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public List<EOperation> getAdditionalOperations(EClassifier owner, String name) {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        if (this.hasAdditionalFeatures()) {
            EClassifier shadow = this.findShadowClass(owner);
            if (shadow == null) {
                return result;
            }
            UMLReflection umlReflection = this.getEnvironment().getUMLReflection();
            if (umlReflection instanceof AcceleoUMLReflection) {
                result.addAll(((AcceleoUMLReflection)umlReflection).getOperations(shadow, name));
            } else {
                List candidates = umlReflection.getOperations((Object)shadow);
                for (EOperation candidate : candidates) {
                    if (!name.equals(candidate.getName())) continue;
                    result.add(candidate);
                }
            }
        }
        return result;
    }

    protected void addClassifier(EPackage pkg, EClassifier classifier) {
        if (pkg != null) {
            pkg.getEClassifiers().add((Object)classifier);
        }
    }

    protected void addOperation(EClassifier owner, EOperation operation) {
        if (owner instanceof EClass) {
            ((EClass)owner).getEOperations().add((Object)operation);
        }
    }

    protected void addProperty(EClassifier owner, EStructuralFeature property) {
        if (owner instanceof EClass) {
            ((EClass)owner).getEStructuralFeatures().add((Object)property);
        }
    }

    protected EPackage createPackage(String name) {
        EPackage result = EcoreFactory.eINSTANCE.createEPackage();
        result.setName(name);
        this.getResource().getContents().add((Object)result);
        return result;
    }

    protected Resource createResource() {
        Resource.Factory factory = OCLEcorePlugin.getEcoreResourceFactory();
        return factory.createResource(URI.createURI((String)"ocl:///oclenv.ecore"));
    }

    protected EClass createShadowClass(EClassifier type) {
        return OCLStandardLibraryImpl.createShadowClass((EClassifier)type);
    }

    protected EPackage createTuplePackage() {
        EPackage result = (EPackage)super.createTuplePackage();
        result.setEFactoryInstance((EFactory)new TupleFactory());
        return result;
    }

    protected EOperation findMatchingOperation(EClassifier shadow, EOperation operation) {
        UMLReflection umlReflection = this.getEnvironment().getUMLReflection();
        String operationName = umlReflection.getName((Object)operation);
        List<EOperation> candidates = umlReflection instanceof AcceleoUMLReflection ? ((AcceleoUMLReflection)umlReflection).getOperations(shadow, operationName) : umlReflection.getOperations((Object)shadow);
        for (EOperation next : candidates) {
            if (next != operation && (!umlReflection.getName((Object)next).equals(operationName) || !this.matchParameters(next, operation))) continue;
            return next;
        }
        return null;
    }

    protected EPackage findPackage(String name) {
        EPackage result = null;
        for (EObject o : this.getResource().getContents()) {
            if (!(o instanceof EPackage)) continue;
            EPackage epkg = (EPackage)o;
            if (name == null || !name.equals(epkg.getName())) continue;
            result = epkg;
            break;
        }
        return result;
    }

    protected EClassifier findShadowClass(EClassifier type) {
        EPackage pkg = null;
        if (this.hasAdditionalFeatures()) {
            pkg = (EPackage)this.getAdditionalFeaturesPackage();
        }
        if (pkg != null) {
            for (EClassifier next : pkg.getEClassifiers()) {
                EClassifier shadow = this.getShadowedClassifier(next);
                if (shadow != type && (shadow == null || !AcceleoTypeResolver.classifierEqual(shadow, type))) continue;
                return next;
            }
        }
        return null;
    }

    protected EClassifier getShadowedClassifier(EClassifier shadow) {
        if (shadow instanceof EClass) {
            return OCLStandardLibraryImpl.getRealClassifier((EClass)((EClass)shadow));
        }
        return null;
    }

    private boolean matchParameters(EOperation a, EOperation b) {
        UMLReflection umlReflection = this.getEnvironment().getUMLReflection();
        List aparms = umlReflection.getParameters((Object)a);
        List bparms = umlReflection.getParameters((Object)b);
        boolean matching = false;
        if (aparms.size() == bparms.size()) {
            int count = aparms.size();
            int i = 0;
            while (i < count) {
                EParameter aparm = (EParameter)aparms.get(i);
                EParameter bparm = (EParameter)bparms.get(i);
                if (!umlReflection.getName((Object)aparm).equals(umlReflection.getName((Object)bparm)) || TypeUtil.getRelationship((Environment)this.getEnvironment(), (Object)((EClassifier)this.resolve((EClassifier)umlReflection.getOCLType((Object)aparm))), (Object)((EClassifier)this.resolve((EClassifier)umlReflection.getOCLType((Object)bparm)))) != 1) {
                    return false;
                }
                ++i;
            }
            matching = true;
        }
        return matching;
    }
}

