/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ReferencesTreeContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARR = new Object[0];
    private Map<Object, Set<Object>> map;
    private ReferencesSearchResult result;
    private TreeViewer viewer;

    public ReferencesTreeContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void clear() {
        this.viewer.setInput(null);
        this.viewer.refresh();
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.map.get(parentElement);
        if (children == null) {
            return EMPTY_ARR;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        IFile res = null;
        if (element instanceof ReferenceEntry) {
            ReferenceEntry entry = (ReferenceEntry)element;
            res = entry.getTemplateFile();
        } else if (element instanceof IFile) {
            res = ((IFile)element).getParent();
        } else if (element instanceof IFolder) {
            res = ((IFolder)element).getProject();
        }
        return res;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.viewer = null;
        this.result = null;
        this.map.clear();
    }

    public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
        if (newInput instanceof ReferencesSearchResult) {
            this.initialize((ReferencesSearchResult)((Object)newInput));
        }
    }

    protected synchronized void initialize(ReferencesSearchResult newInput) {
        this.result = newInput;
        this.map = new HashMap<Object, Set<Object>>();
        if (newInput != null) {
            Object[] entries = newInput.getElements();
            int i = 0;
            while (i < entries.length) {
                this.insert(entries[i], false);
                ++i;
            }
        }
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object localChild = child;
        Object parent = this.getParent(localChild);
        while (parent != null) {
            if (this.insertChild(parent, localChild)) {
                if (refreshViewer) {
                    this.viewer.add(parent, localChild);
                }
            } else {
                if (refreshViewer) {
                    this.viewer.refresh(parent);
                }
                return;
            }
            localChild = parent;
            parent = this.getParent(localChild);
        }
        if (this.insertChild((Object)this.result, localChild) && refreshViewer) {
            this.viewer.add((Object)this.result, localChild);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.map.get(parent);
        if (children == null) {
            children = new TreeSet<Object>(new EntryComparator());
            this.map.put(parent, children);
        }
        return children.add(child);
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.result.getMatchCount(updatedElements[i]) > 0) {
                this.insert(updatedElements[i], true);
            } else {
                this.remove(updatedElements[i], true);
            }
            ++i;
        }
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.viewer.refresh(element);
            }
        } else if (this.result.getMatchCount(element) == 0) {
            this.map.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.result);
                if (refreshViewer) {
                    this.viewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.viewer.refresh(element);
        }
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.map.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntryComparator
    implements Comparator<Object> {
        protected EntryComparator() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            int res = 0;
            if (arg0 instanceof ReferenceEntry && arg1 instanceof ReferenceEntry) {
                int begin1;
                int begin0 = ((ReferenceEntry)arg0).getRegion().getOffset();
                res = begin0 > (begin1 = ((ReferenceEntry)arg1).getRegion().getOffset()) ? 1 : (begin0 < begin1 ? -1 : 0);
            } else if (arg0 instanceof IResource && arg1 instanceof IResource) {
                IResource res0 = (IResource)arg0;
                IResource res1 = (IResource)arg1;
                String name0 = String.valueOf(res0.getProject().toString()) + res0.getProjectRelativePath().toString() + res0.getName();
                String name1 = String.valueOf(res1.getProject().toString()) + res1.getProjectRelativePath().toString() + res1.getName();
                res = name0.compareTo(name1);
            } else {
                res = 0;
            }
            return res;
        }
    }
}

