/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class AcceleoBuilderSettings {
    public static final String BUILD_RESOURCE_KIND = "resource.kind";
    public static final String BUILD_XMI_RESOURCE = "xmi";
    public static final String BUILD_BINARY_RESOURCE = "binary";
    public static final String BUILD_STRICT_MTL_COMPLIANCE = "strict";
    public static final String BUILD_PRAGMATIC_COMPLIANCE = "pragmatic";
    private static final String BUILD_COMPLIANCE_KEYWORD = "compliance";
    private static final String TRIM_POSITION_RESOURCE_KEYWORD = "trim-position";
    private IProject project;
    private String compliance;
    private String resourceKind;
    private boolean trimmedPositions;

    public AcceleoBuilderSettings(IProject project) {
        this.project = project;
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand command = this.getCommand(commands);
            if (command != null) {
                Object arg = command.getArguments().get(BUILD_COMPLIANCE_KEYWORD);
                this.compliance = BUILD_STRICT_MTL_COMPLIANCE.equals(arg) ? BUILD_STRICT_MTL_COMPLIANCE : BUILD_PRAGMATIC_COMPLIANCE;
                arg = command.getArguments().get(BUILD_RESOURCE_KIND);
                this.resourceKind = BUILD_BINARY_RESOURCE.equals(arg) ? BUILD_BINARY_RESOURCE : BUILD_XMI_RESOURCE;
                arg = command.getArguments().get(TRIM_POSITION_RESOURCE_KEYWORD);
                if (arg instanceof Boolean && ((Boolean)arg).booleanValue()) {
                    this.trimmedPositions = true;
                }
            } else {
                this.compliance = BUILD_PRAGMATIC_COMPLIANCE;
                this.resourceKind = BUILD_XMI_RESOURCE;
                this.trimmedPositions = false;
            }
        }
        catch (CoreException e) {
            this.compliance = BUILD_PRAGMATIC_COMPLIANCE;
            this.resourceKind = BUILD_XMI_RESOURCE;
            this.trimmedPositions = false;
        }
    }

    private ICommand getCommand(ICommand[] commands) {
        if (commands != null) {
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.acceleo.ide.ui.acceleoBuilder")) {
                    return commands[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String getCompliance() {
        return this.compliance;
    }

    public void setCompliance(String compliance) {
        this.compliance = compliance;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public void setResourceKind(String resourceKind) {
        this.resourceKind = resourceKind;
    }

    public void save() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ICommand command = this.getCommand(commands);
        if (command != null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(BUILD_COMPLIANCE_KEYWORD, this.compliance);
            args.put(BUILD_RESOURCE_KIND, this.resourceKind);
            command.setArguments(args);
            desc.setBuildSpec(commands);
            this.project.setDescription(desc, null);
        }
    }

    public boolean isTrimmedPositions() {
        return this.trimmedPositions;
    }

    public void setTrimmedPositions(boolean trimmedPositions) {
        this.trimmedPositions = trimmedPositions;
    }
}

