/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.internal.xpand.Activator;

public class StreamConverter {
    public char[] toCharArray(Reader input) throws IOException {
        return this.toCharWriter(input).toCharArray();
    }

    public char[] toCharArray(IFile file) throws CoreException, UnsupportedEncodingException, IOException {
        Reader r = null;
        try {
            r = this.toContentsReader(file);
            char[] cArray = this.toCharArray(r);
            return cArray;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    Activator.logError(ex);
                }
            }
        }
    }

    public Reader toContentsReader(IFile file) throws CoreException, UnsupportedEncodingException {
        InputStream is = file.getContents();
        return new InputStreamReader(is, Charset.forName(file.getCharset(true)));
    }

    public CharArrayWriter toCharWriter(Reader input) throws IOException {
        int r;
        CharArrayWriter buffer = new CharArrayWriter(4096);
        char[] cbuf = new char[4096];
        while ((r = input.read(cbuf)) != -1) {
            buffer.write(cbuf, 0, r);
        }
        return buffer;
    }
}

