/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gmf.internal.common.AbstractNamesDispenser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalNamesDispenser
extends AbstractNamesDispenser {
    private Set<String> namesPool = new HashSet<String>();
    private int initialIndex;

    public IncrementalNamesDispenser() {
        this.initialIndex = 2;
    }

    public IncrementalNamesDispenser(int initialIndex) {
        this.initialIndex = initialIndex;
    }

    @Override
    protected final Collection<String> getNamesPool() {
        return this.namesPool;
    }

    @Override
    public String get(String prefixPart, String semanticPart, String suffixPart) {
        String name = IncrementalNamesDispenser.composeName(prefixPart, semanticPart, suffixPart);
        if (!this.contains(name)) {
            this.add(name);
            return name;
        }
        int i = this.initialIndex;
        while (i <= Integer.MAX_VALUE) {
            name = IncrementalNamesDispenser.composeName(prefixPart, String.valueOf(semanticPart) + i, suffixPart);
            if (!this.contains(name)) {
                this.add(name);
                return name;
            }
            ++i;
        }
        throw new IllegalStateException();
    }
}

