/*
 * Copyright (c) 2006, 2009 Borland Software Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 */
package org.eclipse.gmf.internal.xpand.parser;

public interface XpandParsersym {
    public final static int
      TK_NUMERIC_OPERATION = 64,
      TK_STRING_LITERAL = 27,
      TK_INTEGER_LITERAL = 52,
      TK_REAL_LITERAL = 53,
      TK_PLUS = 32,
      TK_MINUS = 15,
      TK_MULTIPLY = 4,
      TK_DIVIDE = 26,
      TK_GREATER = 16,
      TK_LESS = 17,
      TK_EQUAL = 5,
      TK_GREATER_EQUAL = 18,
      TK_LESS_EQUAL = 19,
      TK_NOT_EQUAL = 20,
      TK_LPAREN = 1,
      TK_RPAREN = 2,
      TK_LBRACE = 74,
      TK_RBRACE = 78,
      TK_LBRACKET = 76,
      TK_RBRACKET = 81,
      TK_ARROW = 90,
      TK_BAR = 73,
      TK_COMMA = 71,
      TK_COLON = 79,
      TK_COLONCOLON = 75,
      TK_SEMICOLON = 85,
      TK_DOT = 91,
      TK_DOTDOT = 92,
      TK_ATPRE = 82,
      TK_CARET = 93,
      TK_CARETCARET = 94,
      TK_QUESTIONMARK = 95,
      TK_ADD_ASSIGN = 133,
      TK_RESET_ASSIGN = 96,
      TK_AT_SIGN = 134,
      TK_EXCLAMATION_MARK = 83,
      TK_NOT_EQUAL_EXEQ = 80,
      TK_INTEGER_RANGE_START = 86,
      TK_class = 135,
      TK_composes = 136,
      TK_constructor = 137,
      TK_datatype = 138,
      TK_default = 139,
      TK_derived = 140,
      TK_do = 141,
      TK_elif = 142,
      TK_enum = 143,
      TK_except = 144,
      TK_exception = 145,
      TK_from = 146,
      TK_literal = 147,
      TK_ordered = 148,
      TK_primitive = 149,
      TK_raise = 150,
      TK_readonly = 151,
      TK_references = 152,
      TK_tag = 153,
      TK_try = 154,
      TK_typedef = 155,
      TK_unlimited = 156,
      TK_invalid = 157,
      TK_COLONCOLONEQUAL = 158,
      TK_IMPORT = 109,
      TK_EXTENSION = 110,
      TK_AROUND = 97,
      TK_ENDAROUND = 84,
      TK_DEFINE = 98,
      TK_ENDDEFINE = 99,
      TK_ERROR = 111,
      TK_EXPAND = 112,
      TK_FOR = 77,
      TK_SEPARATOR = 100,
      TK_AS = 87,
      TK_ITERATOR = 113,
      TK_FOREACH = 101,
      TK_ENDFOREACH = 114,
      TK_FILE = 115,
      TK_ENDFILE = 116,
      TK_IF = 117,
      TK_ELSEIF = 118,
      TK_ELSE = 119,
      TK_ENDIF = 120,
      TK_LET = 121,
      TK_ENDLET = 122,
      TK_PROTECT = 123,
      TK_CSTART = 124,
      TK_CEND = 102,
      TK_ID = 103,
      TK_DISABLE = 104,
      TK_ENDPROTECT = 125,
      TK_LG = 126,
      TK_self = 33,
      TK_inv = 159,
      TK_pre = 160,
      TK_post = 161,
      TK_context = 162,
      TK_package = 163,
      TK_endpackage = 164,
      TK_def = 165,
      TK_if = 65,
      TK_then = 105,
      TK_else = 106,
      TK_endif = 88,
      TK_and = 28,
      TK_or = 29,
      TK_xor = 30,
      TK_not = 54,
      TK_implies = 107,
      TK_let = 69,
      TK_in = 89,
      TK_true = 55,
      TK_false = 56,
      TK_body = 37,
      TK_derive = 38,
      TK_init = 166,
      TK_null = 31,
      TK_attr = 167,
      TK_oper = 168,
      TK_Set = 21,
      TK_Bag = 22,
      TK_Sequence = 23,
      TK_Collection = 24,
      TK_OrderedSet = 25,
      TK_iterate = 39,
      TK_forAll = 40,
      TK_exists = 41,
      TK_isUnique = 42,
      TK_any = 43,
      TK_one = 44,
      TK_collect = 45,
      TK_select = 46,
      TK_reject = 47,
      TK_collectNested = 48,
      TK_sortedBy = 49,
      TK_closure = 50,
      TK_oclIsKindOf = 57,
      TK_oclIsTypeOf = 58,
      TK_oclAsType = 59,
      TK_oclIsNew = 60,
      TK_oclIsUndefined = 61,
      TK_oclIsInvalid = 62,
      TK_oclIsInState = 63,
      TK_allInstances = 51,
      TK_String = 6,
      TK_Integer = 7,
      TK_UnlimitedNatural = 8,
      TK_Real = 9,
      TK_Boolean = 10,
      TK_Tuple = 34,
      TK_OclAny = 11,
      TK_OclVoid = 12,
      TK_Invalid = 13,
      TK_OclMessage = 14,
      TK_OclInvalid = 66,
      TK_end = 169,
      TK_while = 170,
      TK_out = 171,
      TK_object = 172,
      TK_transformation = 173,
      TK_import = 174,
      TK_library = 175,
      TK_metamodel = 176,
      TK_mapping = 177,
      TK_query = 178,
      TK_helper = 179,
      TK_inout = 180,
      TK_when = 181,
      TK_var = 182,
      TK_configuration = 183,
      TK_intermediate = 184,
      TK_property = 185,
      TK_opposites = 186,
      TK_population = 187,
      TK_map = 188,
      TK_new = 189,
      TK_xmap = 190,
      TK_late = 191,
      TK_log = 192,
      TK_assert = 193,
      TK_with = 194,
      TK_resolve = 195,
      TK_resolveone = 196,
      TK_resolveIn = 197,
      TK_resolveoneIn = 198,
      TK_invresolve = 199,
      TK_invresolveone = 200,
      TK_invresolveIn = 201,
      TK_invresolveoneIn = 202,
      TK_modeltype = 203,
      TK_uses = 204,
      TK_where = 205,
      TK_refines = 206,
      TK_access = 207,
      TK_extends = 208,
      TK_blackbox = 209,
      TK_abstract = 210,
      TK_static = 211,
      TK_result = 212,
      TK_main = 213,
      TK_this = 214,
      TK_switch = 215,
      TK_case = 216,
      TK_xselect = 127,
      TK_xcollect = 128,
      TK_selectOne = 129,
      TK_collectOne = 130,
      TK_collectselect = 131,
      TK_collectselectOne = 132,
      TK_return = 217,
      TK_rename = 218,
      TK_disjuncts = 219,
      TK_merges = 220,
      TK_inherits = 221,
      TK_forEach = 222,
      TK_forOne = 223,
      TK_compute = 224,
      TK_Dict = 35,
      TK_List = 36,
      TK_break = 67,
      TK_continue = 68,
      TK_EOF_TOKEN = 108,
      TK_IDENTIFIER = 3,
      TK_STEREOTYPE_QUALIFIER_OPEN = 225,
      TK_STEREOTYPE_QUALIFIER_CLOSE = 226,
      TK_MULTIPLICITY_RANGE = 227,
      TK_TILDE_SIGN = 228,
      TK_TEXT = 72,
      TK_ERROR_TOKEN = 70;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "LPAREN",
                 "RPAREN",
                 "IDENTIFIER",
                 "MULTIPLY",
                 "EQUAL",
                 "String",
                 "Integer",
                 "UnlimitedNatural",
                 "Real",
                 "Boolean",
                 "OclAny",
                 "OclVoid",
                 "Invalid",
                 "OclMessage",
                 "MINUS",
                 "GREATER",
                 "LESS",
                 "GREATER_EQUAL",
                 "LESS_EQUAL",
                 "NOT_EQUAL",
                 "Set",
                 "Bag",
                 "Sequence",
                 "Collection",
                 "OrderedSet",
                 "DIVIDE",
                 "STRING_LITERAL",
                 "and",
                 "or",
                 "xor",
                 "null",
                 "PLUS",
                 "self",
                 "Tuple",
                 "Dict",
                 "List",
                 "body",
                 "derive",
                 "iterate",
                 "forAll",
                 "exists",
                 "isUnique",
                 "any",
                 "one",
                 "collect",
                 "select",
                 "reject",
                 "collectNested",
                 "sortedBy",
                 "closure",
                 "allInstances",
                 "INTEGER_LITERAL",
                 "REAL_LITERAL",
                 "not",
                 "true",
                 "false",
                 "oclIsKindOf",
                 "oclIsTypeOf",
                 "oclAsType",
                 "oclIsNew",
                 "oclIsUndefined",
                 "oclIsInvalid",
                 "oclIsInState",
                 "NUMERIC_OPERATION",
                 "if",
                 "OclInvalid",
                 "break",
                 "continue",
                 "let",
                 "ERROR_TOKEN",
                 "COMMA",
                 "TEXT",
                 "BAR",
                 "LBRACE",
                 "COLONCOLON",
                 "LBRACKET",
                 "FOR",
                 "RBRACE",
                 "COLON",
                 "NOT_EQUAL_EXEQ",
                 "RBRACKET",
                 "ATPRE",
                 "EXCLAMATION_MARK",
                 "ENDAROUND",
                 "SEMICOLON",
                 "INTEGER_RANGE_START",
                 "AS",
                 "endif",
                 "in",
                 "ARROW",
                 "DOT",
                 "DOTDOT",
                 "CARET",
                 "CARETCARET",
                 "QUESTIONMARK",
                 "RESET_ASSIGN",
                 "AROUND",
                 "DEFINE",
                 "ENDDEFINE",
                 "SEPARATOR",
                 "FOREACH",
                 "CEND",
                 "ID",
                 "DISABLE",
                 "then",
                 "else",
                 "implies",
                 "EOF_TOKEN",
                 "IMPORT",
                 "EXTENSION",
                 "ERROR",
                 "EXPAND",
                 "ITERATOR",
                 "ENDFOREACH",
                 "FILE",
                 "ENDFILE",
                 "IF",
                 "ELSEIF",
                 "ELSE",
                 "ENDIF",
                 "LET",
                 "ENDLET",
                 "PROTECT",
                 "CSTART",
                 "ENDPROTECT",
                 "LG",
                 "xselect",
                 "xcollect",
                 "selectOne",
                 "collectOne",
                 "collectselect",
                 "collectselectOne",
                 "ADD_ASSIGN",
                 "AT_SIGN",
                 "class",
                 "composes",
                 "constructor",
                 "datatype",
                 "default",
                 "derived",
                 "do",
                 "elif",
                 "enum",
                 "except",
                 "exception",
                 "from",
                 "literal",
                 "ordered",
                 "primitive",
                 "raise",
                 "readonly",
                 "references",
                 "tag",
                 "try",
                 "typedef",
                 "unlimited",
                 "invalid",
                 "COLONCOLONEQUAL",
                 "inv",
                 "pre",
                 "post",
                 "context",
                 "package",
                 "endpackage",
                 "def",
                 "init",
                 "attr",
                 "oper",
                 "end",
                 "while",
                 "out",
                 "object",
                 "transformation",
                 "import",
                 "library",
                 "metamodel",
                 "mapping",
                 "query",
                 "helper",
                 "inout",
                 "when",
                 "var",
                 "configuration",
                 "intermediate",
                 "property",
                 "opposites",
                 "population",
                 "map",
                 "new",
                 "xmap",
                 "late",
                 "log",
                 "assert",
                 "with",
                 "resolve",
                 "resolveone",
                 "resolveIn",
                 "resolveoneIn",
                 "invresolve",
                 "invresolveone",
                 "invresolveIn",
                 "invresolveoneIn",
                 "modeltype",
                 "uses",
                 "where",
                 "refines",
                 "access",
                 "extends",
                 "blackbox",
                 "abstract",
                 "static",
                 "result",
                 "main",
                 "this",
                 "switch",
                 "case",
                 "return",
                 "rename",
                 "disjuncts",
                 "merges",
                 "inherits",
                 "forEach",
                 "forOne",
                 "compute",
                 "STEREOTYPE_QUALIFIER_OPEN",
                 "STEREOTYPE_QUALIFIER_CLOSE",
                 "MULTIPLICITY_RANGE",
                 "TILDE_SIGN"
             };

    public final static boolean isValidForParser = true;
}
