/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.tests.validate.AnnotationUtil;
import org.eclipse.gmf.tests.validate.DynamicModelHelper;
import org.eclipse.gmf.tests.validate.MetaExpressionDefTestBase;
import org.eclipse.gmf.validate.GMFValidator;

public class ValueSpecDefTest
extends MetaExpressionDefTestBase {
    EStructuralFeature restrictTypeFeature;

    public ValueSpecDefTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.restrictTypeFeature = DynamicModelHelper.createFeature(this.constraintMetaClass, (EClassifier)EcorePackage.eINSTANCE.getEDataType());
    }

    protected String getMetaDefinitionAnnotationKey() {
        return "ValueSpec";
    }

    public void testBodyTypeRestriction() throws Exception {
        this.setTypeRestrictionExpression();
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"2006");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        constraintInstance.eSet(this.restrictTypeFeature, (Object)EcorePackage.eINSTANCE.getEDouble());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        ValueSpecDefTest.assertTrue((status.getSeverity() == 0 ? 1 : 0) != 0);
    }

    public void testBodyTypeRestrictionViolation() throws Exception {
        this.setTypeRestrictionExpression();
        EObject constraintInstance = DynamicModelHelper.createInstance(this.constraintMetaClass);
        constraintInstance.eSet(this.languageAttr, (Object)"ocl");
        constraintInstance.eSet(this.bodyAttr, (Object)"self.name");
        this.bindToEClassContext(constraintInstance, EcorePackage.eINSTANCE.getEOperation());
        constraintInstance.eSet(this.restrictTypeFeature, (Object)EcorePackage.eINSTANCE.getEDouble());
        Diagnostic status = GMFValidator.validate((EObject)constraintInstance);
        ValueSpecDefTest.assertTrue((status.getSeverity() == 4 ? 1 : 0) != 0);
        ValueSpecDefTest.assertEquals((int)AnnotationUtil.getChildDiagnostic(status).getCode(), (int)StatusCodes.INVALID_EXPRESSION_TYPE);
    }

    private void setTypeRestrictionExpression() {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)this.constraintMetaClass, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"type");
        eAnnotation.getDetails().put((Object)"ocl", (Object)this.restrictTypeFeature.getName());
    }
}

