/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.NoteTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.PresentationTestFixture;

public class NoteTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public NoteTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NoteTests.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.NoteTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setTestFixture() {
        this.testFixture = new PresentationTestFixture();
    }

    protected PresentationTestFixture getFixture() {
        return (PresentationTestFixture)this.testFixture;
    }

    public void testNotesAndNoteAttachments() throws Exception {
        DiagramEditPart diagramEP = this.getFixture().getDiagramEditPart();
        NoteTests.assertTrue((boolean)diagramEP.getChildren().isEmpty());
        NoteEditPart note1EP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10));
        NoteEditPart note2EP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
        NoteAttachmentEditPart noteAttachment1EP = (NoteAttachmentEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)DiagramNotationType.NOTE_ATTACHMENT);
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)noteAttachment1EP, (IElementType)DiagramNotationType.NOTE_ATTACHMENT);
        GroupRequest request = new GroupRequest((Object)"delete");
        noteAttachment1EP.getCommand((Request)request).execute();
        note1EP.getCommand((Request)request).execute();
        note2EP.getCommand((Request)request).execute();
        NoteTests.assertTrue((boolean)diagramEP.getChildren().isEmpty());
    }

    public void testTextShape() throws Exception {
        final DiagramEditPart diagramEP = this.getFixture().getDiagramEditPart();
        NoteTests.assertTrue((boolean)diagramEP.getChildren().isEmpty());
        TextEditPart textEP = (TextEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.TEXT, new Point(10, 10));
        this.testCommand(textEP.getCommand((Request)new GroupRequest((Object)"delete")), new ITestCommandCallback(){

            public void onCommandExecution() {
                NoteTests.assertTrue((boolean)diagramEP.getChildren().isEmpty());
            }
        });
    }

    public void testConnectionHandleForNoteAttachment() throws Exception {
        NoteEditPart noteEP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10));
        class AttachableNoteableEP
        extends ShapeNodeEditPart
        implements INotableEditPart {
            final /* synthetic */ NoteTests this$0;

            public AttachableNoteableEP(NoteTests noteTests) {
                this.this$0 = noteTests;
                super(null);
            }

            public boolean canAttachNote() {
                return true;
            }

            protected NodeFigure createNodeFigure() {
                return null;
            }
        }
        AttachableNoteableEP attachableNoteableEP = new AttachableNoteableEP(this);
        class NonAttachableNoteableEP
        extends ShapeNodeEditPart
        implements INotableEditPart {
            final /* synthetic */ NoteTests this$0;

            public NonAttachableNoteableEP(NoteTests noteTests) {
                this.this$0 = noteTests;
                super(null);
            }

            public boolean canAttachNote() {
                return false;
            }

            protected NodeFigure createNodeFigure() {
                return null;
            }
        }
        NonAttachableNoteableEP nonAttachableNoteableEP = new NonAttachableNoteableEP(this);
        ModelingAssistantService service = ModelingAssistantService.getInstance();
        NoteTests.assertTrue((boolean)service.getRelTypesOnSource((IAdaptable)noteEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertTrue((boolean)service.getRelTypesOnSource((IAdaptable)attachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertFalse((boolean)service.getRelTypesOnSource((IAdaptable)nonAttachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertTrue((boolean)service.getRelTypesOnTarget((IAdaptable)noteEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertTrue((boolean)service.getRelTypesOnTarget((IAdaptable)attachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertFalse((boolean)service.getRelTypesOnTarget((IAdaptable)nonAttachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertTrue((boolean)service.getRelTypesOnSourceAndTarget((IAdaptable)noteEP, (IAdaptable)attachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertFalse((boolean)service.getRelTypesOnSourceAndTarget((IAdaptable)noteEP, (IAdaptable)nonAttachableNoteableEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertTrue((boolean)service.getRelTypesOnSourceAndTarget((IAdaptable)attachableNoteableEP, (IAdaptable)noteEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
        NoteTests.assertFalse((boolean)service.getRelTypesOnSourceAndTarget((IAdaptable)nonAttachableNoteableEP, (IAdaptable)noteEP).contains(DiagramNotationType.NOTE_ATTACHMENT));
    }
}

