/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.service;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;

public class AbstractProviderTest
extends TestCase {
    private Fixture fixture = null;
    private Exception exception = null;

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractProviderTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractProviderTest.class);
    }

    public AbstractProviderTest(String name) {
        super(name);
    }

    protected Fixture getFixture() {
        return this.fixture;
    }

    private void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    protected void setUp() {
        this.setFixture(new Fixture());
    }

    public void test_add_remove_ProviderChangeListener() {
        IProviderChangeListener listener = new IProviderChangeListener(){

            public final void providerChanged(ProviderChangeEvent event) {
                throw new RuntimeException();
            }
        };
        this.getFixture().addProviderChangeListener(listener);
        try {
            this.getFixture().fireProviderChange(new ProviderChangeEvent((IProvider)this.getFixture()));
            AbstractProviderTest.fail();
        }
        catch (Exception exception) {}
        this.getFixture().removeProviderChangeListener(listener);
        try {
            this.getFixture().fireProviderChange(new ProviderChangeEvent((IProvider)this.getFixture()));
        }
        catch (Exception exception) {
            AbstractProviderTest.fail();
        }
    }

    public void test_fireProviderChange() {
        final IProviderChangeListener[] listeners = new IProviderChangeListener[99];
        int i = 0;
        while (i < 99) {
            listeners[i] = new IProviderChangeListener(){

                public void providerChanged(ProviderChangeEvent event) {
                }
            };
            ++i;
        }
        Thread addThread = new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < 99) {
                    AbstractProviderTest.this.getFixture().addProviderChangeListener(listeners[i]);
                    if (AbstractProviderTest.this.getException() != null) break;
                    ++i;
                }
            }
        });
        addThread.start();
        Thread fireThread = new Thread(new Runnable(){

            public void run() {
                ProviderChangeEvent event = new ProviderChangeEvent((IProvider)AbstractProviderTest.this.getFixture());
                try {
                    int i = 0;
                    while (i < 99) {
                        AbstractProviderTest.this.getFixture().fireProviderChange(event);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                }
                catch (Exception e) {
                    AbstractProviderTest.this.setException(e);
                }
            }
        });
        fireThread.start();
        Thread removeThread = new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < 99) {
                    AbstractProviderTest.this.getFixture().removeProviderChangeListener(listeners[i]);
                    if (AbstractProviderTest.this.getException() != null) break;
                    ++i;
                }
            }
        });
        removeThread.start();
        try {
            fireThread.join();
        }
        catch (InterruptedException ie) {
            this.setException(ie);
        }
        if (this.getException() != null) {
            AbstractProviderTest.fail();
        }
    }

    protected static class Fixture
    extends AbstractProvider {
        protected Fixture() {
        }

        protected void fireProviderChange(ProviderChangeEvent event) {
            super.fireProviderChange(event);
        }

        public boolean provides(IOperation operation) {
            return true;
        }
    }
}

