/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class FanRouter
extends org.eclipse.draw2d.FanRouter {
    static final int SEPARATION = 15;

    public void route(Connection conn) {
        this.routeBendpoints(conn);
    }

    private void routeBendpoints(Connection conn) {
        if (!this.isFeedback(conn)) {
            this.setSeparation(MapModeUtil.getMapMode((IFigure)conn).DPtoLP(15));
        } else {
            this.setSeparation(15);
        }
        super.route(conn);
    }

    private boolean isFeedback(Connection conn) {
        Dimension dim = new Dimension(100, 100);
        Dimension dimCheck = dim.getCopy();
        conn.translateToRelative((Translatable)dimCheck);
        return dim.equals((Object)dimCheck);
    }

    protected void handleCollision(PointList points, int index) {
        Point end;
        if (points.size() == 2 && points.getFirstPoint().equals((Object)points.getLastPoint())) {
            return;
        }
        Point start = points.getFirstPoint();
        if (start.equals((Object)(end = points.getLastPoint()))) {
            return;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        Ray ray = position == 4 || position == 16 ? new Ray(start, end) : new Ray(end, start);
        double length = Math.sqrt((double)ray.x * (double)ray.x + (double)ray.y * (double)ray.y);
        double xSeparation = (double)(this.getSeparation() * ray.x) / length;
        double ySeparation = (double)(this.getSeparation() * ray.y) / length;
        Point bendPoint = index % 2 == 0 ? new Point((double)midPoint.x + (double)(index / 2) * (-1.0 * ySeparation), (double)midPoint.y + (double)(index / 2) * xSeparation) : new Point((double)midPoint.x + (double)(index / 2) * ySeparation, (double)midPoint.y + (double)(index / 2) * (-1.0 * xSeparation));
        if (!bendPoint.equals((Object)midPoint)) {
            points.insertPoint(bendPoint, 1);
        }
    }
}

