/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.gmfgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColorConstants implements Enumerator
{
    WHITE_LITERAL(0, "white", "white"),
    BLACK_LITERAL(1, "black", "black"),
    LIGHT_GRAY_LITERAL(2, "lightGray", "lightGray"),
    GRAY_LITERAL(3, "gray", "gray"),
    DARK_GRAY_LITERAL(4, "darkGray", "darkGray"),
    RED_LITERAL(5, "red", "red"),
    ORANGE_LITERAL(6, "orange", "orange"),
    YELLOW_LITERAL(7, "yellow", "yellow"),
    GREEN_LITERAL(8, "green", "green"),
    LIGHT_GREEN_LITERAL(9, "lightGreen", "lightGreen"),
    DARK_GREEN_LITERAL(10, "darkGreen", "darkGreen"),
    CYAN_LITERAL(11, "cyan", "cyan"),
    LIGHT_BLUE_LITERAL(12, "lightBlue", "lightBlue"),
    BLUE_LITERAL(13, "blue", "blue"),
    DARK_BLUE_LITERAL(14, "darkBlue", "darkBlue");

    public static final int WHITE = 0;
    public static final int BLACK = 1;
    public static final int LIGHT_GRAY = 2;
    public static final int GRAY = 3;
    public static final int DARK_GRAY = 4;
    public static final int RED = 5;
    public static final int ORANGE = 6;
    public static final int YELLOW = 7;
    public static final int GREEN = 8;
    public static final int LIGHT_GREEN = 9;
    public static final int DARK_GREEN = 10;
    public static final int CYAN = 11;
    public static final int LIGHT_BLUE = 12;
    public static final int BLUE = 13;
    public static final int DARK_BLUE = 14;
    private static final ColorConstants[] VALUES_ARRAY;
    public static final List<ColorConstants> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ColorConstants[]{WHITE_LITERAL, BLACK_LITERAL, LIGHT_GRAY_LITERAL, GRAY_LITERAL, DARK_GRAY_LITERAL, RED_LITERAL, ORANGE_LITERAL, YELLOW_LITERAL, GREEN_LITERAL, LIGHT_GREEN_LITERAL, DARK_GREEN_LITERAL, CYAN_LITERAL, LIGHT_BLUE_LITERAL, BLUE_LITERAL, DARK_BLUE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ColorConstants get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ColorConstants result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ColorConstants getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ColorConstants result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ColorConstants get(int value) {
        switch (value) {
            case 0: {
                return WHITE_LITERAL;
            }
            case 1: {
                return BLACK_LITERAL;
            }
            case 2: {
                return LIGHT_GRAY_LITERAL;
            }
            case 3: {
                return GRAY_LITERAL;
            }
            case 4: {
                return DARK_GRAY_LITERAL;
            }
            case 5: {
                return RED_LITERAL;
            }
            case 6: {
                return ORANGE_LITERAL;
            }
            case 7: {
                return YELLOW_LITERAL;
            }
            case 8: {
                return GREEN_LITERAL;
            }
            case 9: {
                return LIGHT_GREEN_LITERAL;
            }
            case 10: {
                return DARK_GREEN_LITERAL;
            }
            case 11: {
                return CYAN_LITERAL;
            }
            case 12: {
                return LIGHT_BLUE_LITERAL;
            }
            case 13: {
                return BLUE_LITERAL;
            }
            case 14: {
                return DARK_BLUE_LITERAL;
            }
        }
        return null;
    }

    private ColorConstants(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

