/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;

public class Trace {
    private static final Plugin plugin = GMFValidationPlugin.getDefault();
    private static final String PARENTHESIS_OPEN = "(";
    private static final String PARENTHESIS_CLOSE = ")";
    private static final String PREFIX_CATCHING = "CAUGHT ";
    private static final String SEPARATOR_SPACE = " ";
    private static final Map cachedOptions = new HashMap();

    private Trace() {
    }

    protected static boolean shouldTrace() {
        return plugin.isDebugging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldTrace(String option) {
        if (Trace.shouldTrace()) {
            Boolean value = null;
            Map map = cachedOptions;
            synchronized (map) {
                value = (Boolean)cachedOptions.get(option);
                if (value == null) {
                    value = Boolean.valueOf(Platform.getDebugOption((String)option));
                    cachedOptions.put(option, value);
                }
            }
            return value;
        }
        return false;
    }

    public static void trace(String message) {
        if (Trace.shouldTrace()) {
            System.out.println(message);
        }
    }

    public static void trace(String option, String message) {
        if (Trace.shouldTrace(option)) {
            Trace.trace(message);
        }
    }

    public static void catching(String option, Throwable throwable) {
        if (Trace.shouldTrace(option)) {
            Trace.trace("CAUGHT  (" + throwable.getMessage() + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }
}

