/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.factory;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageType;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.image.ImageRenderedImage;
import org.eclipse.swt.graphics.RGB;

public class RenderedImageFactory {
    private static Map instanceMap = new WeakHashMap();
    private static final String E_MODIFIER_FACTORY = "factory";
    private static final String A_CLASS = "class";
    private static List imageTypes = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static RenderInfo createInfo(int width, int height, boolean maintainAspectRatio, boolean antialias, RGB fill, RGB outline) {
        RenderedImageKey svgInfo = new RenderedImageKey();
        svgInfo.setValues(width, height, maintainAspectRatio, antialias, fill, outline);
        return svgInfo;
    }

    public static RenderedImage getInstance(URL theURL) {
        return RenderedImageFactory.getInstance(theURL, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getInstance(URL theURL, RenderInfo info) {
        try {
            InputStream is = theURL.openStream();
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            return RenderedImageFactory.getInstance(buffer, info);
        }
        catch (Exception e) {
            Plugin plugin = Draw2dRenderPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)plugin, (String)Draw2dRenderDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"RenderedImageFactory.getInstance()", (Throwable)e);
            return null;
        }
    }

    public static RenderedImage getInstance(String szFilePath) {
        return RenderedImageFactory.getInstance(szFilePath, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getInstance(String szFilePath, RenderInfo info) {
        try {
            FileInputStream fis = new FileInputStream(szFilePath);
            int size = fis.available();
            byte[] buffer = new byte[size];
            fis.read(buffer);
            fis.close();
            return RenderedImageFactory.getInstance(buffer, info);
        }
        catch (Exception e) {
            Plugin plugin = Draw2dRenderPlugin.getInstance();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)plugin, (String)Draw2dRenderDebugOptions.EXCEPTIONS_THROWING, (Class)clazz, (String)"RenderedImageFactory.getInstance()", (Throwable)e);
            return null;
        }
    }

    public static RenderedImage getInstance(byte[] buffer) {
        return RenderedImageFactory.getInstance(buffer, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getRelatedInstance(RenderedImage image, RenderInfo info) {
        if (image instanceof AbstractRenderedImage) {
            RenderedImageKey oldKey = ((AbstractRenderedImage)image).getKey();
            RenderedImageKey key = new RenderedImageKey(info, oldKey.getChecksum(), oldKey.getExtraData());
            WeakReference ref = (WeakReference)instanceMap.get(key);
            if (ref != null) {
                return (RenderedImage)ref.get();
            }
            return RenderedImageFactory.autodetectImage(((AbstractRenderedImage)image).getBuffer(), key);
        }
        return null;
    }

    public static RenderedImage getInstance(byte[] buffer, RenderInfo info) {
        if (buffer == null) {
            throw new InvalidParameterException();
        }
        Adler32 checksum = new Adler32();
        checksum.update(buffer);
        RenderedImageKey key = new RenderedImageKey(info, checksum.getValue(), null);
        WeakReference ref = (WeakReference)instanceMap.get(key);
        RenderedImage image = null;
        image = ref != null ? (RenderedImage)((WeakReference)instanceMap.get(key)).get() : RenderedImageFactory.autodetectImage(buffer, key);
        return image;
    }

    private static RenderedImage autodetectImage(byte[] buffer, RenderedImageKey key) {
        if (imageTypes == null) {
            imageTypes = new ArrayList();
            IExtensionPoint riExtensionPt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.gmf.runtime.draw2d.ui.render", "renderedImageFactory");
            IConfigurationElement[] configEls = riExtensionPt.getConfigurationElements();
            int i = 0;
            while (i < configEls.length) {
                IConfigurationElement element = configEls[i];
                if (element.getName().equals(E_MODIFIER_FACTORY)) {
                    RenderedImageType imageType = null;
                    try {
                        imageType = (RenderedImageType)element.createExecutableExtension(A_CLASS);
                        if (imageType != null) {
                            imageTypes.add(imageType);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        RenderedImage image = null;
        ListIterator li = imageTypes.listIterator();
        while (li.hasNext()) {
            RenderedImageType imageType = (RenderedImageType)li.next();
            image = imageType.autoDetect(buffer, key);
            if (image != null) break;
        }
        if (image == null) {
            image = new ImageRenderedImage(buffer, key);
        }
        if (image != null) {
            instanceMap.put(key, new WeakReference<ImageRenderedImage>((ImageRenderedImage)image));
        }
        return image;
    }
}

