/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCall
extends Expression {
    private Expression target;
    private final Identifier name;

    public FeatureCall(int start, int end, int line, Identifier name, Expression target) {
        super(start, end, line);
        this.target = target;
        this.name = name;
    }

    public Expression getTarget() {
        return this.target;
    }

    public void setTarget(Expression target) {
        this.target = target;
    }

    public Identifier getName() {
        return this.name;
    }

    public EEnumLiteral getEnumLiteral(ExecutionContext ctx) {
        if (this.name.getValue().indexOf("::") != -1) {
            String typeName = this.name.getValue();
            EClassifier type = ctx.getTypeForName(typeName = typeName.substring(0, typeName.lastIndexOf("::")));
            if (type != null) {
                if (!(type instanceof EEnum)) {
                    return null;
                }
                String litName = this.name.getValue().substring(this.name.getValue().lastIndexOf("::") + "::".length());
                return ((EEnum)type).getEEnumLiteral(litName);
            }
        }
        return null;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        EClassifier type;
        Object targetObj = null;
        if (this.target == null) {
            EEnumLiteral staticProp = this.getEnumLiteral(ctx);
            if (staticProp != null) {
                return staticProp.getInstance();
            }
            Variable var = ctx.getVariable(this.getName().getValue());
            if (var != null) {
                return var.getValue();
            }
            var = ctx.getVariable("this");
            if (var != null && (targetObj = var.getValue()) == null) {
                return null;
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
            if (targetObj == null) {
                return null;
            }
        }
        if (targetObj != null) {
            EClassifier targetObjType = BuiltinMetaModel.getType(targetObj);
            EStructuralFeature p = BuiltinMetaModel.getAttribute(targetObjType, this.getName().getValue());
            if (p == null && targetObj instanceof Collection) {
                return this.handleCollection(ctx, (Collection)targetObj);
            }
            if (p != null) {
                return BuiltinMetaModel.getValue(p, targetObj);
            }
        }
        if (this.target == null && (type = ctx.getTypeForName(this.getName().getValue())) != null) {
            return type;
        }
        if (this.getName().getValue().indexOf("::") != -1) {
            throw new EvaluationException("Couldn't find enum literal or type '" + this.getName().getValue() + "'", (SyntaxElement)this);
        }
        if (this.target == null) {
            throw new EvaluationException("Couldn't find type or property '" + this.getName().getValue() + "'", (SyntaxElement)this);
        }
        throw new EvaluationException("Couldn't find property '" + this.getName().getValue() + "' for type " + this.findEClassifier(targetObj, ctx).getName(), (SyntaxElement)this);
    }

    private Object handleCollection(ExecutionContext ctx, Collection col) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : col) {
            EClassifier type = BuiltinMetaModel.getType(element);
            EStructuralFeature prop = BuiltinMetaModel.getAttribute(type, this.getName().getValue());
            if (prop == null) {
                throw new EvaluationException("Couldn't find property '" + this.getName().getValue() + "' for inner type " + type + "'", (SyntaxElement)this);
            }
            Object r = BuiltinMetaModel.getValue(prop, element);
            if (r instanceof Collection) {
                result.addAll((Collection)r);
                continue;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier type;
        EClassifier targetType = null;
        if (this.target == null) {
            EEnumLiteral staticProp = this.getEnumLiteral(ctx);
            if (staticProp != null) {
                return BuiltinMetaModel.getReturnType(staticProp);
            }
            Variable var = ctx.getVariable(this.getName().getValue());
            if (var != null) {
                assert (var.getValue() == null || var.getValue() instanceof EClassifier) : "variable should hold EClassifier";
                return (EClassifier)var.getValue();
            }
            var = ctx.getVariable("this");
            if (var != null) {
                targetType = (EClassifier)var.getValue();
            }
        } else {
            targetType = this.analyzeTarget(ctx, issues);
            if (targetType == null) {
                return null;
            }
        }
        String additionalMsg = "";
        if (targetType != null) {
            EStructuralFeature p = BuiltinMetaModel.getAttribute(targetType, this.getName().getValue());
            if (p != null) {
                return BuiltinMetaModel.getTypedElementType((ETypedElement)p);
            }
            if (p == null && BuiltinMetaModel.isParameterizedType(targetType)) {
                EClassifier innerEClassifier = BuiltinMetaModel.getInnerType(targetType);
                p = BuiltinMetaModel.getAttribute(innerEClassifier, this.getName().getValue());
                if (p != null) {
                    EClassifier rt = p.getEType();
                    if (BuiltinMetaModel.isParameterizedType(rt)) {
                        rt = BuiltinMetaModel.getInnerType(rt);
                    }
                    return BuiltinMetaModel.getListType(rt);
                }
                additionalMsg = " or inner type '" + innerEClassifier + "'";
            }
        }
        if (this.target == null && (type = ctx.getTypeForName(this.getName().getValue())) != null) {
            return EcorePackage.eINSTANCE.getEClass();
        }
        if (this.target == null) {
            String txt = "";
            if (targetType != null) {
                txt = String.valueOf(targetType.getName()) + " property, ";
            }
            issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, "Unknown " + txt + "variable, type or enumeration literal '" + this.getName().getValue() + "'", this));
            return null;
        }
        issues.add(new AnalysationIssue(AnalysationIssue.Type.FEATURE_NOT_FOUND, "Couldn't find property '" + this.getName().getValue() + "' for type '" + targetType.getName() + "'" + additionalMsg, this));
        return null;
    }

    protected EClassifier analyzeTarget(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return this.getTarget().analyze(ctx, issues);
    }

    protected EClassifier findEClassifier(Object value, ExecutionContext ctx) {
        EClassifier t = BuiltinMetaModel.getType(value);
        if (t == null) {
            throw new EvaluationException("Unkown object type : " + value.getClass().getName(), (SyntaxElement)this);
        }
        return t;
    }

    public String toString() {
        return String.valueOf(this.getTarget() != null ? String.valueOf(this.getTarget().toString()) + "." : "") + this.name.getValue();
    }
}

