/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.build.OawBuilder;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

public class WorkspaceResourceManager
extends ResourceManagerImpl {
    private final IProject contextProject;
    private long configStamp = -1L;
    private IPath[] configuredRoots = new IPath[0];

    public WorkspaceResourceManager(IProject context) {
        this.contextProject = context;
    }

    public XtendResource loadXtendResource(IFile file) throws CoreException, IOException, ParserException {
        if (file == null) {
            return null;
        }
        assert (file.getProject() == this.contextProject);
        Reader r = null;
        try {
            r = new StreamConverter().toContentsReader(file);
            XtendResource xtendResource = super.loadXtendResource(r, this.toFullyQualifiedName(file));
            return xtendResource;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public XpandResource loadXpandResource(IFile file) throws CoreException, IOException, ParserException {
        if (file == null) {
            return null;
        }
        assert (file.getProject() == this.contextProject);
        Reader r = null;
        try {
            r = new StreamConverter().toContentsReader(file);
            XpandResource xpandResource = super.loadXpandResource(r, this.toFullyQualifiedName(file));
            return xpandResource;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    protected boolean shouldCache() {
        return false;
    }

    public void forget(IFile resource) {
    }

    protected Reader resolve(String fqn, String ext) throws IOException {
        IPath fp = new Path(fqn.replaceAll("::", "/")).addFileExtension(ext);
        IResource r = null;
        IPath[] iPathArray = this.getResolutions(fp);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            r = this.contextProject.findMember(p);
            if (r != null) break;
            ++n2;
        }
        if (!(r instanceof IFile)) {
            throw new FileNotFoundException(fp.toString());
        }
        try {
            return new StreamConverter().toContentsReader((IFile)r);
        }
        catch (CoreException ex) {
            IOException wrap = new IOException(ex.getStatus().getMessage());
            wrap.initCause(ex);
            throw wrap;
        }
    }

    private IPath[] getResolutions(IPath p) {
        IPath[] configured = this.getConfiguredRoots();
        IPath[] rv = new IPath[configured.length + 1];
        rv[0] = p;
        int i = 0;
        while (i < configured.length) {
            rv[i + 1] = configured[i].append(p);
            ++i;
        }
        return rv;
    }

    /*
     * Unable to fully structure code
     */
    private IPath[] getConfiguredRoots() {
        config = this.contextProject.getFile(".xpand-root");
        if (!config.exists()) {
            return new IPath[]{new Path("templates/")};
        }
        if (config.getModificationStamp() != this.configStamp) {
            block20: {
                this.configuredRoots = new IPath[0];
                read = new ArrayList<Path>();
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(config.getContents(), config.getCharset()));
                    while ((line = in.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                        read.add(new Path(line));
                    }
                }
                catch (CoreException v0) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException v1) {}
                    }
                    break block20;
                }
                catch (IOException v2) {
                    try {
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var5_5) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException v4) {}
                        }
                        throw var5_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            in.close();
                        }
                        catch (IOException v3) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block20;
                    }
                }
                if (in == null) break block20;
                try {
                    in.close();
                }
                catch (IOException v5) {}
            }
            this.configuredRoots = read.toArray(new IPath[read.size()]);
            this.configStamp = config.getModificationStamp();
        }
        return this.configuredRoots;
    }

    protected ResourceManager[] getDependenies() {
        LinkedList<ResourceManager> rv = new LinkedList<ResourceManager>();
        try {
            IProject[] referencedProjects;
            IProject[] iProjectArray = referencedProjects = this.contextProject.getReferencedProjects();
            int n = referencedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject next = iProjectArray[n2];
                if (next.isAccessible() && WorkspaceResourceManager.hasXpandBuilder(next)) {
                    rv.add(Activator.getResourceManager(next));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return rv.toArray(new ResourceManager[rv.size()]);
    }

    private static boolean hasXpandBuilder(IProject p) throws CoreException {
        ICommand[] iCommandArray = p.getDescription().getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand c = iCommandArray[n2];
            if (OawBuilder.getBUILDER_ID().equals(c.getBuilderName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String toFullyQualifiedName(IFile file) {
        return file.getProjectRelativePath().toString().replaceAll("/", "::");
    }
}

