/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfStatement
extends Statement {
    private final Expression condition;
    private final Statement[] thenPart;
    private IfStatement elseIf;

    public IfStatement(int start, int end, int line, int startOffset, int endOffset, Expression condition, Statement[] thenPart, IfStatement elseIf) {
        super(start, end, line, startOffset, endOffset);
        this.condition = condition;
        this.thenPart = thenPart;
        this.elseIf = elseIf;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public IfStatement getElseIf() {
        return this.elseIf;
    }

    public void setElseIf(IfStatement elseIf) {
        this.elseIf = elseIf;
    }

    public Statement[] getThenPart() {
        return this.thenPart;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.condition != null) {
            EClassifier conType = this.getCondition().analyze(ctx, issues);
            if (conType != null && !BuiltinMetaModel.isAssignableFrom((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), conType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean expected!", this.getCondition()));
            }
            this.createAnalyzeTrace(ctx, new ExpressionAnalyzeTrace(conType));
        }
        int i = 0;
        while (i < this.getThenPart().length) {
            this.getThenPart()[i].analyze(ctx, issues);
            ++i;
        }
        if (this.getElseIf() != null) {
            this.getElseIf().analyze(ctx, issues);
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        block6: {
            block4: {
                block5: {
                    if (this.condition == null) break block4;
                    Object result = this.getCondition().evaluate(ctx);
                    if (result == null) {
                        throw new EvaluationException("Nullevaluation!", (SyntaxElement)this.getCondition());
                    }
                    if (!(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected!", (SyntaxElement)this.getCondition());
                    }
                    if (!((Boolean)result).booleanValue()) break block5;
                    int i = 0;
                    while (i < this.getThenPart().length) {
                        this.getThenPart()[i].evaluate(ctx);
                        ++i;
                    }
                    break block6;
                }
                if (this.getElseIf() == null) break block6;
                this.getElseIf().evaluate(ctx);
                break block6;
            }
            int i = 0;
            while (i < this.getThenPart().length) {
                this.getThenPart()[i].evaluate(ctx);
                ++i;
            }
        }
    }
}

