/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.gef.AbstractDiagramEditorTest;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditorTest
extends AbstractDiagramEditorTest {
    public DiagramEditorTest(String name) {
        super(name);
    }

    public void testSaveDiagramChanges() {
        IEditorPart editorPart = this.getEditor();
        DiagramEditorTest.assertFalse((String)"Created Editor is dirty", (boolean)editorPart.isDirty());
        Diagram diagram = this.getDiagram();
        Command setNameCommand = this.getViewerConfiguration().getSetNotationalElementStructuralFeature((View)diagram, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name(), this.getUniqueString());
        this.checkEditorDirtyState(setNameCommand, editorPart, this.getViewerConfiguration().getViewer());
    }

    private void checkEditorDirtyState(Command setNameCommand, IEditorPart editorPart, EditPartViewer viewer) {
        viewer.getEditDomain().getCommandStack().execute(setNameCommand);
        DiagramEditorTest.assertTrue((String)"Editor was not marked as dirty", (boolean)editorPart.isDirty());
        editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
        DiagramEditorTest.assertFalse((String)"Editor was not saved", (boolean)editorPart.isDirty());
    }

    public void testSaveNotaitonElementChanges() {
        IEditorPart editorPart = this.getEditor();
        GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getViewerConfiguration();
        Diagram diagram = this.getDiagram();
        Node nodeA = this.createNodeA(diagram, editorPart);
        DiagramEditorTest.assertTrue((String)"Created node invisible", (boolean)nodeA.isVisible());
        Command setNameCommand = viewerConfiguration.getSetNotationalElementStructuralFeature((View)nodeA, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), Boolean.FALSE);
        this.checkEditorDirtyState(setNameCommand, editorPart, this.getViewerConfiguration().getViewer());
    }

    private Node createNodeA(Diagram diagram, IEditorPart editorPart) {
        Node result = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)diagram);
        editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
        DiagramEditorTest.assertFalse((String)"Editor was not saved", (boolean)editorPart.isDirty());
        return result;
    }

    public void testSaveDomainElementChangesSeparateFiles() {
        this.checkSaveDomainElementChanges(false);
    }

    public void testSaveDomainElementChangesSameFile() {
        this.checkSaveDomainElementChanges(true);
    }

    private void checkSaveDomainElementChanges(boolean sameFile) {
        IEditorPart editorPart = this.setupCustomEditorPart(sameFile);
        try {
            GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getViewerConfiguration();
            EditPartViewer viewer = viewerConfiguration.getViewer();
            Diagram diagram = this.getDiagram();
            Node nodeA = this.createNodeA(diagram, editorPart);
            Command setLabelCommand = viewerConfiguration.getSetBusinessElementStructuralFeatureCommand((View)nodeA, "label", this.getUniqueString());
            this.checkEditorDirtyState(setLabelCommand, editorPart, viewer);
        }
        finally {
            editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
            this.closeEditor(editorPart);
        }
    }

    private IEditorPart setupCustomEditorPart(boolean sameFileForModel) {
        try {
            IFile diagramFile = this.createDiagram(sameFileForModel);
            IEditorPart editorPart = this.openEditor(diagramFile);
            GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.createViewerConfiguration(editorPart);
            this.setViewerConfiguration(viewerConfiguration);
            return editorPart;
        }
        catch (Exception e) {
            DiagramEditorTest.fail((String)e.getMessage());
            return null;
        }
    }

    public void testSaveWithUnloadedResource() {
        IEditorPart editorPart = this.getEditor();
        GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getViewerConfiguration();
        EditPartViewer viewer = viewerConfiguration.getViewer();
        Diagram diagram = this.getDiagram();
        URI anotherResourceURI = diagram.eResource().getURI().trimFileExtension().appendFileExtension("additional." + this.getSetup().getGenModel().getGenDiagram().getEditorGen().getDomainFileExtension());
        this.createAdditionalModelResource(anotherResourceURI);
        Resource anotherResource = diagram.eResource().getResourceSet().getResource(anotherResourceURI, true);
        anotherResource.unload();
        Command setNameCommand = viewerConfiguration.getSetNotationalElementStructuralFeature((View)diagram, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name(), this.getUniqueString());
        this.checkEditorDirtyState(setNameCommand, editorPart, viewer);
        this.checkAdditionalModelResource(anotherResourceURI);
    }

    public void testUnspecifiedTypeRequest() {
        EditPartViewer viewer = this.getViewerConfiguration().getViewer();
        Diagram diagram = this.getDiagram();
        CreationTool creationTool = this.getNodeCreationTool(viewer);
        GenNode genNodeA = this.getSetup().getGenModel().getNodeA();
        Node aNode = this.checkCreateNode(viewer, (View)diagram, creationTool, genNodeA.getVisualID());
        DiagramEditorTest.assertTrue((String)"Incorrect setup passed", (genNodeA.getCompartments().size() > 0 ? 1 : 0) != 0);
        GenCompartment genCompartment = (GenCompartment)genNodeA.getCompartments().get(0);
        DiagramEditorTest.assertTrue((String)"Incorrect setup passed", (genCompartment.getChildNodes().size() > 0 ? 1 : 0) != 0);
        GenNode childNode = (GenNode)genCompartment.getChildNodes().get(0);
        DiagramEditorTest.assertNotNull((String)"Incorrect setup passed", (Object)childNode);
        Node compartment = this.findChildnode(aNode, (GenCommonBase)genCompartment);
        this.checkCreateNode(viewer, (View)compartment, creationTool, childNode.getVisualID());
    }

    private Node findChildnode(Node parentNode, GenCommonBase genElement) {
        String visualID = String.valueOf(genElement.getVisualID());
        for (View nextView : parentNode.getChildren()) {
            if (!nextView.getType().equals(visualID)) continue;
            DiagramEditorTest.assertTrue((boolean)(nextView instanceof Node));
            return (Node)nextView;
        }
        DiagramEditorTest.fail((String)("Node not found" + visualID));
        return null;
    }

    private Node checkCreateNode(EditPartViewer viewer, View parentView, CreationTool creationTool, int newNodeVisualID) {
        Request request = creationTool.createCreateRequest();
        EditPart parentEP = (EditPart)viewer.getEditPartRegistry().get(parentView);
        DiagramEditorTest.assertNotNull((Object)parentEP);
        Command createANodeCommand = parentEP.getCommand(request);
        viewer.getEditDomain().getCommandStack().execute(createANodeCommand);
        DiagramEditorTest.assertTrue((parentView.getChildren().size() == 1 ? 1 : 0) != 0);
        Node aNode = (Node)parentView.getChildren().get(0);
        DiagramEditorTest.assertEquals((String)"Node with incorrect visual ID was created.", (String)aNode.getType(), (String)String.valueOf(newNodeVisualID));
        return aNode;
    }

    private CreationTool getNodeCreationTool(EditPartViewer viewer) {
        PaletteRoot paletteRoot = viewer.getEditDomain().getPaletteViewer().getPaletteRoot();
        DiagramEditorTest.assertNotNull((String)"Palette root absent", (Object)paletteRoot);
        PaletteContainer container = this.findPaletteContainer(paletteRoot, "Default");
        DiagramEditorTest.assertTrue((String)"Incorrect palette was created", (container.getChildren().size() > 0 ? 1 : 0) != 0);
        DiagramEditorTest.assertTrue((String)"Incorrect palette was created", (boolean)(container.getChildren().get(0) instanceof ToolEntry));
        ToolEntry toolEntry = (ToolEntry)container.getChildren().get(0);
        Tool tool = toolEntry.createTool();
        DiagramEditorTest.assertTrue((String)"Incorrect palette was created", (boolean)(tool instanceof CreationTool));
        CreationTool creationTool = (CreationTool)tool;
        creationTool.setViewer(viewer);
        creationTool.setEditDomain(viewer.getEditDomain());
        return creationTool;
    }

    private PaletteContainer findPaletteContainer(PaletteRoot paletteRoot, String groupName) {
        for (PaletteContainer nextContainer : paletteRoot.getChildren()) {
            if (!groupName.equals(nextContainer.getLabel())) continue;
            return nextContainer;
        }
        DiagramEditorTest.fail((String)("No palette container " + groupName + " fourn in the palette"));
        return null;
    }

    private void checkAdditionalModelResource(URI anotherResourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(anotherResourceURI, true);
        DiagramEditorTest.assertTrue((String)"Unloaded resource was changed while saving editor", (resource.getContents().size() == 1 ? 1 : 0) != 0);
    }

    private void createAdditionalModelResource(URI anotherResourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(anotherResourceURI, "");
        try {
            EObject domainDiagramElement = this.createDiagramDomainObject();
            resource.getContents().add((Object)domainDiagramElement);
        }
        catch (Exception e) {
            DiagramEditorTest.fail((String)e.getMessage());
        }
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            DiagramEditorTest.fail((String)e.getMessage());
        }
    }

    public void donottestDiagramAndModelExternalModificationSameResource() {
        this.checkDiagramAndModelExternalModification(true);
    }

    public void testDiagramAndModelExternalModificationSeparateResources() {
        this.checkDiagramAndModelExternalModification(false);
    }

    private void checkDiagramAndModelExternalModification(boolean sameFile) {
        IEditorPart editorPart = this.setupCustomEditorPart(false);
        try {
            Diagram diagram = this.getDiagram();
            DiagramEditorTest.assertTrue((String)"Not empty diagram created", (diagram.getChildren().size() == 0 ? 1 : 0) != 0);
            DiagramEditorTest.assertTrue((String)"Not empty domain model element created", (diagram.getElement().eContents().size() == 0 ? 1 : 0) != 0);
            Diagram diagramCopy = this.reloadInSeparateResoruceSet(diagram);
            DiagramEditorTest.assertTrue((String)"Passed diagram is not empty", (diagramCopy.getChildren().size() == 0 ? 1 : 0) != 0);
            try {
                GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getSetup().getGeneratorConfiguration().createViewerConfiguration((Composite)new Shell(0), this.getSetup(), diagramCopy);
                Command command = viewerConfiguration.getCreateNodeCommand((View)diagramCopy, (GenCommonBase)this.getSetup().getGenModel().getNodeA());
                viewerConfiguration.getViewer().getEditDomain().getCommandStack().execute(command);
            }
            catch (Exception e) {
                DiagramEditorTest.fail((String)e.getMessage());
            }
            DiagramEditorTest.assertFalse((String)"Diagram node was not created", (diagramCopy.getChildren().size() == 0 ? 1 : 0) != 0);
            this.saveResources((List<Resource>)diagramCopy.eResource().getResourceSet().getResources());
            this.redispatchEvents();
            diagram = this.getDiagram();
            DiagramEditorTest.assertFalse((String)"Editor is dirty", (boolean)editorPart.isDirty());
            DiagramEditorTest.assertTrue((String)"Diagram content was not refreshed", (diagram.getChildren().size() > 0 ? 1 : 0) != 0);
            DiagramEditorTest.assertTrue((String)"Domain model content was not refreshed", (diagram.getElement().eContents().size() > 0 ? 1 : 0) != 0);
        }
        finally {
            this.closeEditor(editorPart);
        }
    }

    public void testDiagramResorceExternalModification() {
        Diagram diagram = this.getDiagram();
        String newDiagramName = this.getUniqueString();
        Diagram diagramCopy = this.reloadInSeparateResoruceSet(diagram);
        try {
            GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getSetup().getGeneratorConfiguration().createViewerConfiguration((Composite)new Shell(0), this.getSetup(), diagramCopy);
            Command command = viewerConfiguration.getSetNotationalElementStructuralFeature((View)diagramCopy, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name(), newDiagramName);
            viewerConfiguration.getViewer().getEditDomain().getCommandStack().execute(command);
        }
        catch (Exception e) {
            DiagramEditorTest.fail((String)e.getMessage());
        }
        DiagramEditorTest.assertEquals((String)"Diagram name was not set", (String)newDiagramName, (String)diagramCopy.getName());
        this.saveResources(Collections.singletonList(diagramCopy.eResource()));
        this.redispatchEvents();
        diagram = this.getDiagram();
        DiagramEditorTest.assertFalse((String)"Editor is dirty", (boolean)this.getEditor().isDirty());
        DiagramEditorTest.assertEquals((String)"Diagram name was not updated", (String)newDiagramName, (String)diagram.getName());
    }

    public void testModelResorceExternalModification() {
        Diagram diagram = this.getDiagram();
        Diagram diagramCopy = this.reloadInSeparateResoruceSet(diagram);
        String newName = this.getUniqueString();
        try {
            GeneratorConfiguration.ViewerConfiguration viewerConfiguration = this.getSetup().getGeneratorConfiguration().createViewerConfiguration((Composite)new Shell(0), this.getSetup(), diagramCopy);
            Command command = viewerConfiguration.getSetBusinessElementStructuralFeatureCommand((View)diagramCopy, "diagramAttribute", newName);
            viewerConfiguration.getViewer().getEditDomain().getCommandStack().execute(command);
        }
        catch (Exception e) {
            DiagramEditorTest.fail((String)e.getMessage());
        }
        this.saveResources(Collections.singletonList(diagramCopy.getElement().eResource()));
        this.redispatchEvents();
        diagram = this.getDiagram();
        DiagramEditorTest.assertFalse((String)"Editor is dirty", (boolean)this.getEditor().isDirty());
        EObject diagramModel = diagram.getElement();
        EStructuralFeature stFeature = diagramModel.eClass().getEStructuralFeature("diagramAttribute");
        DiagramEditorTest.assertNotNull((String)"Name feature not found", (Object)stFeature);
        String nodeAName = (String)diagramModel.eGet(stFeature);
        DiagramEditorTest.assertEquals((String)"Name was not refreshed", (String)newName, (String)nodeAName);
    }

    private void saveResources(final List<Resource> resources) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (Resource nextResource : resources) {
                    try {
                        nextResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        DiagramEditorTest.fail((String)e.getMessage());
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.getProject(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            DiagramEditorTest.fail((String)e.getMessage());
        }
    }

    private Diagram reloadInSeparateResoruceSet(Diagram diagram) {
        TransactionalEditingDomain editingDoman = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        editingDoman.setID(this.getSetup().getGenModel().getGenDiagram().getEditingDomainID());
        AdapterFactoryEditingDomain oldEditingDomain = (AdapterFactoryEditingDomain)TransactionUtil.getEditingDomain((EObject)diagram);
        ((AdapterFactoryEditingDomain)editingDoman).setResourceToReadOnlyMap(oldEditingDomain.getResourceToReadOnlyMap());
        ResourceSet resourceSet = editingDoman.getResourceSet();
        Resource newDiagramResource = resourceSet.getResource(diagram.eResource().getURI(), true);
        EObject newDiagram = newDiagramResource.getEObject(diagram.eResource().getURIFragment((EObject)diagram));
        DiagramEditorTest.assertTrue((String)"Unable to reload the diagram into another ResourceSet", (boolean)(newDiagram instanceof Diagram));
        return (Diagram)newDiagram;
    }
}

