/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.lang.reflect.Field;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.NoUpdateViewer;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public abstract class AbstractGeneratorConfiguration
implements GeneratorConfiguration {
    public GeneratorConfiguration.ViewerConfiguration createViewerConfiguration(Composite parent, SessionSetup sessionSetup, Diagram canvas) throws Exception {
        EditPartViewer viewer = this.createViewer(parent, sessionSetup, canvas);
        return this.createViewerConfiguration(viewer, sessionSetup.getGenModel().getGenDiagram(), sessionSetup.getGenProject().getBundle());
    }

    public EditPartViewer createViewer(Composite parent, SessionSetup sessionSetup, Diagram canvas) throws Exception {
        Display.getDefault();
        EditPartViewer gv = this.createViewerInstance();
        gv.createControl(parent);
        DiagramEditDomain ded = new DiagramEditDomain(null);
        gv.setEditDomain((EditDomain)ded);
        gv.getEditDomain().setCommandStack((CommandStack)new DiagramCommandStack((IDiagramEditDomain)ded));
        String epFactoryClassName = sessionSetup.getGenModel().getGenDiagram().getEditPartFactoryQualifiedClassName();
        Class<?> epFactory = sessionSetup.loadGeneratedClass(epFactoryClassName);
        assert (EditPartFactory.class.isAssignableFrom(epFactory));
        gv.setEditPartFactory((EditPartFactory)epFactory.newInstance());
        gv.setContents((Object)canvas);
        return gv;
    }

    protected abstract EditPartViewer createViewerInstance();

    protected static abstract class AbstractFakeViewer
    extends NoUpdateViewer {
        protected AbstractFakeViewer() {
        }

        protected void createDefaultRoot() {
            this.setRootEditPart((RootEditPart)new ScalableRootEditPart(){

                protected ScalableLayeredPane createScaledLayers() {
                    class LayeredPane
                    extends ScalableLayeredPane
                    implements IMapMode {
                        LayeredPane() {
                        }

                        public int DPtoLP(int deviceUnit) {
                            return deviceUnit;
                        }

                        public Translatable DPtoLP(Translatable t) {
                            t.performScale(1.0);
                            return t;
                        }

                        public int LPtoDP(int logicalUnit) {
                            return logicalUnit;
                        }

                        public Translatable LPtoDP(Translatable t) {
                            t.performScale(1.0);
                            return t;
                        }
                    }
                    LayeredPane layers = new LayeredPane();
                    layers.add((IFigure)this.createGridLayer(), "Grid Layer");
                    layers.add((IFigure)this.getPrintableLayers(), "Printable Layers");
                    FreeformLayer feedbackLayer = new FreeformLayer();
                    feedbackLayer.setEnabled(false);
                    layers.add((IFigure)feedbackLayer, "Scaled Feedback Layer");
                    return layers;
                }
            });
            LayerManager root = (LayerManager)this.getRootEditPart();
            LayeredPane printableLayers = (LayeredPane)root.getLayer((Object)"Printable Layers");
            FreeformLayer extLabelsLayer = new FreeformLayer();
            extLabelsLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
            printableLayers.addLayerAfter((Layer)extLabelsLayer, (Object)"External Node Labels", (Object)"Primary Layer");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractViewerConfiguration
    implements GeneratorConfiguration.ViewerConfiguration {
        private final EditPartViewer myViewer;
        private final GenDiagram myDiagramModel;
        private final Bundle myGenProject;
        private PreferencesHint myDefaultPreferences;

        public AbstractViewerConfiguration(EditPartViewer viewer, GenDiagram model, Bundle genPlugin) {
            this.myViewer = viewer;
            this.myDiagramModel = model;
            this.myGenProject = genPlugin;
        }

        @Override
        public EditPartViewer getViewer() {
            return this.myViewer;
        }

        @Override
        public EditPart findEditPart(View notationElement) {
            return (EditPart)this.myViewer.getEditPartRegistry().get(notationElement);
        }

        @Override
        public Font getDefaultFont() {
            BasicFont result = GMFGraphFactory.eINSTANCE.createBasicFont();
            FontData defaultFontData = PreferenceConverter.getDefaultFontData((IPreferenceStore)this.getDefaultPreferences(), (String)"Appearance.defaultFont");
            result.setFaceName(defaultFontData.getName());
            result.setHeight(defaultFontData.getHeight());
            result.setStyle(FontStyle.get((int)defaultFontData.getStyle()));
            return result;
        }

        protected final Class<?> loadGeneratedClass(String qualifiedClassName) throws ClassNotFoundException {
            return this.myGenProject.loadClass(qualifiedClassName);
        }

        protected GenDiagram getGenModel() {
            return this.myDiagramModel;
        }

        protected IPreferenceStore getDefaultPreferences() {
            return (IPreferenceStore)this.getDefaultPreferencesHint().getPreferenceStore();
        }

        protected PreferencesHint getDefaultPreferencesHint() {
            if (this.myDefaultPreferences == null) {
                try {
                    Class<?> activatorClazz = this.loadGeneratedClass(this.myDiagramModel.getEditorGen().getPlugin().getActivatorQualifiedClassName());
                    Field field = activatorClazz.getField("DIAGRAM_PREFERENCES_HINT");
                    this.myDefaultPreferences = (PreferencesHint)field.get(null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.myDefaultPreferences = PreferencesHint.USE_DEFAULTS;
                }
                catch (SecurityException securityException) {
                    this.myDefaultPreferences = PreferencesHint.USE_DEFAULTS;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    this.myDefaultPreferences = PreferencesHint.USE_DEFAULTS;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.myDefaultPreferences = PreferencesHint.USE_DEFAULTS;
                }
            }
            return this.myDefaultPreferences;
        }
    }
}

