/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.osgi.framework.BundleException;

public class SessionSetup
implements TestConfiguration {
    private DomainModelSource myDomainModel;
    private DiaGenSource myGenModel;
    private GenProjectSetup myProject;
    private MapDefSource myMapModel;
    private DiaDefSource myGraphDefModel;
    private int myUses;
    private static RuntimeWorkspaceSetup myRuntimeWorkspaceSetup;
    protected static boolean factoryClosed;
    private GeneratorConfiguration myGeneratorConfiguration;

    static {
        factoryClosed = false;
    }

    protected SessionSetup() {
    }

    public static void disallowSingleTestCaseUse() {
        factoryClosed = true;
    }

    public static SessionSetup newInstance() {
        if (factoryClosed) {
            return null;
        }
        return new SessionSetup();
    }

    public DomainModelSource getDomainModel() {
        if (this.myDomainModel == null) {
            this.myDomainModel = this.createDomainModel();
        }
        return this.myDomainModel;
    }

    protected DomainModelSource createDomainModel() {
        return new DomainModelSetup().init();
    }

    public DiaGenSource getGenModel() {
        if (this.myGenModel == null) {
            this.myGenModel = this.createGenModel();
        }
        return this.myGenModel;
    }

    protected DiaGenSource createGenModel() {
        return new DiaGenSetup().init(this.getDomainModel());
    }

    public GenProjectSetup getGenProject() throws Exception {
        if (this.myProject == null) {
            this.myProject = this.createGenProject();
        }
        return this.myProject;
    }

    protected GenProjectSetup createGenProject() throws BundleException, Exception {
        return new GenProjectSetup(this.getGeneratorConfiguration()).init(SessionSetup.getRuntimeWorkspaceSetup(), this.getGenModel());
    }

    public GeneratorConfiguration getGeneratorConfiguration() {
        if (this.myGeneratorConfiguration == null) {
            this.myGeneratorConfiguration = this.createGeneratorConfiguration();
        }
        return this.myGeneratorConfiguration;
    }

    protected GeneratorConfiguration createGeneratorConfiguration() {
        return new RuntimeBasedGeneratorConfiguration();
    }

    public MapDefSource getMapModel() {
        if (this.myMapModel == null) {
            this.myMapModel = this.createMapModel();
        }
        return this.myMapModel;
    }

    protected MapDefSource createMapModel() {
        return new MapSetup().init(this.getGraphDefModel(), this.getDomainModel(), new ToolDefSetup());
    }

    public DiaDefSource getGraphDefModel() {
        if (this.myGraphDefModel == null) {
            this.myGraphDefModel = this.createGraphDefModel();
        }
        return this.myGraphDefModel;
    }

    protected DiaDefSource createGraphDefModel() {
        return new DiaDefSetup();
    }

    public static RuntimeWorkspaceSetup getRuntimeWorkspaceSetup() throws Exception {
        if (myRuntimeWorkspaceSetup == null) {
            myRuntimeWorkspaceSetup = new RuntimeWorkspaceSetup();
            myRuntimeWorkspaceSetup.init();
        }
        return myRuntimeWorkspaceSetup;
    }

    public void cleanup() throws Exception {
        System.err.println(String.valueOf(this.getClass().getName()) + ":uses:" + this.myUses);
        if (this.myProject != null) {
            this.myProject.uninstall();
        }
    }

    public void oneUp() {
        ++this.myUses;
    }

    public void oneDown() {
        --this.myUses;
    }
}

