/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.gmf.tests.setup.DomainModelSource;

public class MultiplePackagesDomainModelSetup
implements DomainModelSource {
    private EPackage myPrimaryPackage;
    private DomainModelSource.NodeData myNodeFirstPackage;
    private DomainModelSource.NodeData myNodeSecondPackage;
    private EClass myDiagramElement;
    private DomainModelSource.LinkData myLinkThirdPackage;
    private EReference myLinkFromFirstToSecond;

    public MultiplePackagesDomainModelSetup init() {
        this.myPrimaryPackage = MultiplePackagesDomainModelSetup.createPackage("prim");
        EClass iElement = MultiplePackagesDomainModelSetup.createEClass("IElement", null, false, true);
        this.myPrimaryPackage.getEClassifiers().add((Object)iElement);
        EClass iDiagramContainer = MultiplePackagesDomainModelSetup.createEClass("IDiagramContainer", null, true, false);
        EReference cr = MultiplePackagesDomainModelSetup.createERef("all", true, iElement);
        iDiagramContainer.getEStructuralFeatures().add((Object)cr);
        this.myPrimaryPackage.getEClassifiers().add((Object)iDiagramContainer);
        EPackage p2 = MultiplePackagesDomainModelSetup.createPackage("first");
        EClass node1 = MultiplePackagesDomainModelSetup.createEClass("Node1", iElement);
        p2.getEClassifiers().add((Object)node1);
        EPackage p3 = MultiplePackagesDomainModelSetup.createPackage("second");
        EClass node2 = MultiplePackagesDomainModelSetup.createEClass("Node2", iElement);
        p3.getEClassifiers().add((Object)node2);
        EPackage p4 = MultiplePackagesDomainModelSetup.createPackage("third");
        EClass link = MultiplePackagesDomainModelSetup.createEClass("Link", null);
        EReference target = MultiplePackagesDomainModelSetup.createERef("targetToN1", false, node1);
        link.getEStructuralFeatures().add((Object)target);
        EClass someShitToContain = MultiplePackagesDomainModelSetup.createEClass("SomeShitToContain", null, false, true);
        EClass diagramContainerImpl = MultiplePackagesDomainModelSetup.createEClass("DiagramContainerImpl", iDiagramContainer, false, false);
        p4.getEClassifiers().add((Object)link);
        p4.getEClassifiers().add((Object)someShitToContain);
        p4.getEClassifiers().add((Object)diagramContainerImpl);
        EReference linkCont = MultiplePackagesDomainModelSetup.createERef("links", true, link);
        node2.getEStructuralFeatures().add((Object)linkCont);
        node1.getEStructuralFeatures().add((Object)MultiplePackagesDomainModelSetup.createERef("someShit", true, someShitToContain));
        EReference lnkNode2 = MultiplePackagesDomainModelSetup.createERef("lnkNode2", false, node2);
        node1.getEStructuralFeatures().add((Object)lnkNode2);
        iDiagramContainer.getEStructuralFeatures().add((Object)MultiplePackagesDomainModelSetup.createERef("anotherShit", true, someShitToContain));
        this.myNodeFirstPackage = new DomainModelSource.NodeData(node1, null, cr);
        this.myNodeSecondPackage = new DomainModelSource.NodeData(node2, null, cr);
        this.myLinkFromFirstToSecond = lnkNode2;
        this.myLinkThirdPackage = new DomainModelSource.LinkData(link, (EStructuralFeature)target, linkCont);
        this.myDiagramElement = diagramContainerImpl;
        this.confineInResource("r1", Collections.singletonList(this.myPrimaryPackage));
        this.confineInResource("r2", Arrays.asList(p2, p3, p4));
        return this;
    }

    private static EClass createEClass(String name, EClass superClass) {
        return MultiplePackagesDomainModelSetup.createEClass(name, superClass, false, false);
    }

    private static EClass createEClass(String name, EClass superClass, boolean isA, boolean isI) {
        EClass rv = EcoreFactory.eINSTANCE.createEClass();
        rv.setInterface(isI);
        rv.setAbstract(isA);
        rv.setName(name);
        if (superClass != null) {
            rv.getESuperTypes().add((Object)superClass);
        }
        return rv;
    }

    private static EPackage createPackage(String name) {
        EPackage p = EcoreFactory.eINSTANCE.createEPackage();
        p.setName(name);
        p.setNsPrefix("ns" + name);
        p.setNsURI("uri:/gmf/tests/multi/" + name);
        return p;
    }

    private static EReference createERef(String name, boolean isCont, EClass toContain) {
        EReference cr = EcoreFactory.eINSTANCE.createEReference();
        cr.setContainment(isCont);
        cr.setName(name);
        cr.setEType((EClassifier)toContain);
        return cr;
    }

    private void confineInResource(String name, List toConfine) {
        new ResourceImpl(URI.createURI((String)("uri://org.eclipse.gmf/tests/MultiPackSetup/" + name))).getContents().addAll((Collection)toConfine);
    }

    public EPackage getModel() {
        return this.myPrimaryPackage;
    }

    public DomainModelSource.NodeData getNodeA() {
        return this.myNodeSecondPackage;
    }

    public DomainModelSource.NodeData getNodeB() {
        return this.myNodeFirstPackage;
    }

    public DomainModelSource.LinkData getLinkAsClass() {
        return this.myLinkThirdPackage;
    }

    public EReference getLinkAsRef() {
        return this.myLinkFromFirstToSecond;
    }

    public EClass getDiagramElement() {
        return this.myDiagramElement;
    }
}

