/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xtend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.util.ClassLoadContext;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.tests.expression.ast.ATypeModel;
import org.eclipse.gmf.tests.xtend.AbstractXtendTest;
import org.eclipse.gmf.tests.xtend.Helper;

public class ExtensionEvaluationTest
extends AbstractXtendTest {
    private ExecutionContextImpl ec;
    private static int magic = 0;

    protected void setUp() throws Exception {
        this.ec = new ExecutionContextImpl(null, new EPackage[0]);
        this.ec.setContextClassLoader((ClassLoadContext)new ClassLoadContext.Naive(new ClassLoader[]{((Object)((Object)this)).getClass().getClassLoader()}));
    }

    public final void testWithEverything() {
        ExtensionFile file = this.parse("String toUpperCase(String str) : JAVA " + Helper.class.getName() + ".toUpperCase(java.lang.String) ; \n" + "\n" + "String privateHelper(String str) : JAVA " + Helper.class.getName() + ".privateHelper(java.lang.String) ; \n" + "\n" + "String nonStaticHelper(String str) : JAVA " + Helper.class.getName() + ".nonStaticHelper(java.lang.String) ; \n" + "\n" + "/* \n" + " * Meine Funktion \n" + " */ \n" + "myExtension(Object val) : {val} ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Object[] params = new Object[]{"test"};
        Extension ext = this.ec.getExtension("toUpperCase", this.detectTypes(params));
        ExtensionEvaluationTest.assertEquals((Object)"TEST", (Object)ext.evaluate(params, (ExecutionContext)this.ec));
        ext = this.ec.getExtension("myExtension", this.detectTypes(params));
        ExtensionEvaluationTest.assertEquals(Collections.singletonList("test"), (Object)ext.evaluate(params, (ExecutionContext)this.ec));
    }

    public final void testJavaExtension2() {
        ExtensionFile file = this.parse("Collection[Object] union(Collection[Object] c1,Collection[Object] c2) : JAVA org.eclipse.gmf.tests.xtend.Helper.union(java.util.Collection,java.util.Collection) ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Object[] params = new Object[]{Collections.singleton("1"), Collections.singleton("2")};
        Extension ext = this.ec.getExtension("union", this.detectTypes(params));
        Collection result = (Collection)ext.evaluate(params, (ExecutionContext)this.ec);
        ExtensionEvaluationTest.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        ExtensionEvaluationTest.assertTrue((boolean)result.contains("1"));
        ExtensionEvaluationTest.assertTrue((boolean)result.contains("2"));
    }

    public final void testPolymorphism() {
        ExtensionFile file = this.parse("ext(Object val) : 'Object' ; \next(List[Object] val) : 'List' ; \next(Collection[Object] val) : 'Collection' ; \next(Integer val) : 'Integer' ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Extension ext = this.ec.getExtension("ext", this.detectTypes(new Object[]{"test"}));
        ExtensionEvaluationTest.assertEquals((Object)"Object", (Object)ext.evaluate(new Object[]{"test"}, (ExecutionContext)this.ec));
        ext = this.ec.getExtension("ext", this.detectTypes(new Object[]{Collections.EMPTY_SET}));
        ExtensionEvaluationTest.assertEquals((Object)"Collection", (Object)ext.evaluate(new Object[]{Collections.EMPTY_SET}, (ExecutionContext)this.ec));
        ext = this.ec.getExtension("ext", this.detectTypes(new Object[]{Collections.EMPTY_LIST}));
        ExtensionEvaluationTest.assertEquals((Object)"List", (Object)ext.evaluate(new Object[]{Collections.EMPTY_LIST}, (ExecutionContext)this.ec));
        ext = this.ec.getExtension("ext", this.detectTypes(new Object[]{new Integer(2)}));
        ExtensionEvaluationTest.assertEquals((Object)"Integer", (Object)ext.evaluate(new Object[]{new Integer(2)}, (ExecutionContext)this.ec));
    }

    public final void testRecursion() {
        ExtensionFile file = this.parse("List[Integer] recExtension(Integer von,Integer bis) : von>=bis ? {von} : recExtension(von,bis-1).add(bis) ; \n");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Extension ext = this.ec.getExtension("recExtension", this.detectTypes(new Object[]{new Long(5L), new Long(10L)}));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int i = 5;
        while (i <= 10) {
            expected.add(new Integer(i));
            ++i;
        }
        Object evalResult = ext.evaluate(new Object[]{new Integer(5), new Integer(10)}, (ExecutionContext)this.ec);
        ExtensionEvaluationTest.assertEquals(expected, (Object)evalResult);
    }

    public final void testMemberPosition() {
        ExtensionFile file = this.parse("ext1(String txt) : 'test'+txt ;ext2(String txt) : txt.ext1() ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Extension ext = this.ec.getExtension("ext2", this.detectTypes(new Object[]{"fall"}));
        Object evalResult = ext.evaluate(new Object[]{"fall"}, (ExecutionContext)this.ec);
        ExtensionEvaluationTest.assertEquals((Object)"testfall", (Object)evalResult);
    }

    public final void testCachedExtension() {
        ExtensionFile file = this.parse("cached String ext(String txt) : JAVA " + ExtensionEvaluationTest.class.getName() + ".testMethod(java.lang.String);");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        Extension ext = this.ec.getExtension("ext", this.detectTypes(new Object[]{"test"}));
        ExtensionEvaluationTest.assertEquals((Object)"test0", (Object)ext.evaluate(new Object[]{"test"}, (ExecutionContext)this.ec));
        ExtensionEvaluationTest.assertEquals((Object)"test0", (Object)ext.evaluate(new Object[]{"test"}, (ExecutionContext)this.ec));
        ExtensionEvaluationTest.assertEquals((Object)"test0", (Object)ext.evaluate(new Object[]{"test"}, (ExecutionContext)this.ec));
        ExtensionEvaluationTest.assertEquals((Object)"test0", (Object)ext.evaluate(new Object[]{"test"}, (ExecutionContext)this.ec));
    }

    private EClassifier[] detectTypes(Object[] objects) {
        EClassifier[] rv = new EClassifier[objects.length];
        int i = 0;
        while (i < objects.length) {
            rv[i] = BuiltinMetaModel.getType((Object)objects[i]);
            ++i;
        }
        return rv;
    }

    public static final String testMethod(String s) {
        return String.valueOf(s) + magic++;
    }

    public final void testCreateExtension() {
        ExtensionFile file = this.parse("create List[String] l test(String s) : l.add(s) ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        List l = (List)((Extension)file.getExtensions().get(0)).evaluate((Object[])new String[]{"test"}, (ExecutionContext)this.ec);
        ExtensionEvaluationTest.assertEquals(Collections.singletonList("test"), (Object)l);
    }

    public final void testCreateExtension1() {
        ExtensionFile file = this.parse("create List[String] test(String s) : add(s) ;");
        this.ec = (ExecutionContextImpl)this.ec.cloneWithResource((ResourceMarker)file);
        List l = (List)((Extension)file.getExtensions().get(0)).evaluate((Object[])new String[]{"test"}, (ExecutionContext)this.ec);
        ExtensionEvaluationTest.assertEquals(Collections.singletonList("test"), (Object)l);
    }

    public final void testAmbigous() {
        ATypeModel aType = new ATypeModel();
        ExtensionFile file = this.parse("import '" + aType.getMetaType().getEPackage().getName() + "';" + "doStuff(" + aType.getMetaType().getName() + " this) : true; " + "doStuff(" + aType.getMetaTypeC().getName() + " this) : false;");
        ExecutionContext ctx = aType.newContext((ResourceMarker)file);
        ExtensionEvaluationTest.assertNotNull((Object)ctx.getExtension("doStuff", new EClassifier[]{aType.getMetaType()}));
        try {
            ctx.getExtension("doStuff", new EClassifier[]{aType.getMetaTypeB()});
            ExtensionEvaluationTest.fail((String)"Ambigous operation exception expected");
        }
        catch (RuntimeException re) {
            System.out.println(re.getMessage());
        }
    }
}

