/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.TreeRouter;

public abstract class AbstractForestRouterTest
extends TestCase {
    private ForestRouter forestRouter;
    private TreeConnection conn1;
    private TreeConnection conn2;
    private TreeConnection conn3;
    private TreeConnection conn4;

    public AbstractForestRouterTest(String name) {
        super(name);
    }

    protected TreeConnection getConnection1() {
        return this.conn1;
    }

    protected TreeConnection getConnection2() {
        return this.conn2;
    }

    protected TreeConnection getConnection3() {
        return this.conn3;
    }

    protected TreeConnection getConnection4() {
        return this.conn4;
    }

    protected ForestRouter getForestRouter() {
        return this.forestRouter;
    }

    protected void setUp() {
        try {
            this.forestRouter = new ForestRouter();
            RectangleFigure node1 = new RectangleFigure();
            RectangleFigure node2 = new RectangleFigure();
            RectangleFigure node3 = new RectangleFigure();
            node1.setSize(40, 40);
            node2.setSize(40, 40);
            node3.setSize(40, 40);
            ChopboxAnchor anchor = new ChopboxAnchor((IFigure)node3);
            this.conn1 = new TreeConnection();
            this.conn1.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
            this.conn1.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn1.setHint("tree1");
            this.conn1.setConnectionRouter((ConnectionRouter)this.forestRouter);
            this.conn2 = new TreeConnection();
            this.conn2.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node2));
            this.conn2.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn2.setHint("tree1");
            this.conn2.setConnectionRouter((ConnectionRouter)this.forestRouter);
            RectangleFigure node4 = new RectangleFigure();
            RectangleFigure node5 = new RectangleFigure();
            node4.setSize(40, 40);
            node5.setSize(40, 40);
            this.conn3 = new TreeConnection();
            this.conn3.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node4));
            this.conn3.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn3.setHint("tree2");
            this.conn3.setConnectionRouter((ConnectionRouter)this.forestRouter);
            this.conn4 = new TreeConnection();
            this.conn4.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node5));
            this.conn4.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn4.setHint("tree2");
            this.conn4.setConnectionRouter((ConnectionRouter)this.forestRouter);
        }
        catch (Exception e) {
            AbstractForestRouterTest.fail((String)("The ForestRouterTest.setUp method caught an exception - " + e));
        }
    }

    public void testInvalidate() {
        this.getForestRouter().invalidate((Connection)this.getConnection1());
        this.getForestRouter().invalidate((Connection)this.getConnection2());
    }

    public void testRemove() {
        this.getForestRouter().route((Connection)this.getConnection1());
        this.getForestRouter().remove((Connection)this.getConnection1());
    }

    protected void routeConnections(String testDesc) {
        this.getForestRouter().route((Connection)this.getConnection1());
        this.getForestRouter().route((Connection)this.getConnection2());
        this.updateConstraint((Connection)this.getConnection1());
        this.updateConstraint((Connection)this.getConnection2());
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection1 trunk not equal to Connection2 trunk"), (boolean)this.getConnection1().getPoints().getPoint(2).equals((Object)this.getConnection2().getPoints().getPoint(2)));
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection1 isOrthogonalTreeBranch"), (boolean)AbstractForestRouterTest.isOrthogonalTreeBranch((Connection)this.getConnection1()));
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection2 isOrthogonalTreeBranch"), (boolean)AbstractForestRouterTest.isOrthogonalTreeBranch((Connection)this.getConnection2()));
    }

    private void updateConstraint(Connection conn) {
        PointList pts = conn.getPoints();
        ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>(pts.size());
        int i = 0;
        while (i < pts.size()) {
            AbsoluteBendpoint abp = new AbsoluteBendpoint(pts.getPoint(i));
            newConstraint.add(abp);
            ++i;
        }
        this.getForestRouter().setConstraint(conn, newConstraint);
    }

    public static boolean isOrthogonalTreeBranch(Connection conn) {
        TreeRouter treeRouter = new TreeRouter();
        return treeRouter.isOrthogonalTreeBranch(conn, conn.getPoints());
    }

    protected void routeMultiTreeConnections(String testDesc) {
        this.routeConnections(testDesc);
        this.getForestRouter().route((Connection)this.getConnection3());
        this.getForestRouter().route((Connection)this.getConnection4());
        this.updateConstraint((Connection)this.getConnection1());
        this.updateConstraint((Connection)this.getConnection2());
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection3 trunk not equal to Connection4 trunk"), (boolean)this.getConnection3().getPoints().getPoint(2).equals((Object)this.getConnection4().getPoints().getPoint(2)));
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection3 isOrthogonalTreeBranch"), (boolean)AbstractForestRouterTest.isOrthogonalTreeBranch((Connection)this.getConnection3()));
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " Connection4 isOrthogonalTreeBranch"), (boolean)AbstractForestRouterTest.isOrthogonalTreeBranch((Connection)this.getConnection4()));
        AbstractForestRouterTest.assertTrue((String)(String.valueOf(testDesc) + " tree1 trunk not equal to tree2 trunk"), (!this.getConnection1().getPoints().getPoint(2).equals((Object)this.getConnection3().getPoints().getPoint(2)) ? 1 : 0) != 0);
    }

    public static class TreeConnection
    extends PolylineConnection
    implements ITreeConnection {
        String hint;
        ITreeConnection.Orientation orientation;

        public String getHint() {
            return this.hint;
        }

        public ITreeConnection.Orientation getOrientation() {
            return this.orientation;
        }

        public void setHint(String hint) {
            this.hint = hint;
        }

        public void setOrientation(ITreeConnection.Orientation orient) {
            this.orientation = orient;
        }
    }
}

