/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.TreeRouter;
import org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers.AbstractForestRouterTest;

public class TreeRouterTest
extends TestCase {
    private TreeRouter treeRouter;
    private AbstractForestRouterTest.TreeConnection conn1;
    private AbstractForestRouterTest.TreeConnection conn2;
    Rectangle test1Other = new Rectangle(3900, 4906, 2200, 1300);
    Rectangle test1Start = new Rectangle(9986, 5250, 2200, 1300);
    Rectangle test1End = new Rectangle(6440, 831, 2200, 1300);
    Dimension[] test1 = new Dimension[]{new Dimension(-265, -635), new Dimension(3281, 3784), new Dimension(-265, -2196), new Dimension(3281, 2223), new Dimension(-3440, -2196), new Dimension(106, 2223), new Dimension(-3440, -3784), new Dimension(106, 635)};
    Rectangle test2Start = new Rectangle(3995, 4974, 2593, 1246);
    Rectangle test2End = new Rectangle(6535, 899, 2169, 1246);
    Rectangle test2Other = new Rectangle(9986, 5250, 2200, 1300);
    Dimension[] test2 = new Dimension[]{new Dimension(-238, -635), new Dimension(-2778, 3440), new Dimension(-238, -1852), new Dimension(-2778, 2223), new Dimension(2434, -1852), new Dimension(-106, 2223), new Dimension(2434, -3440), new Dimension(-106, 635)};

    public TreeRouterTest(String name) {
        super(name);
    }

    protected AbstractForestRouterTest.TreeConnection getConnection1() {
        return this.conn1;
    }

    protected AbstractForestRouterTest.TreeConnection getConnection2() {
        return this.conn2;
    }

    protected TreeRouter getTreeRouter() {
        return this.treeRouter;
    }

    protected void setUp() {
        try {
            this.treeRouter = new TreeRouter();
            RectangleFigure node1 = new RectangleFigure();
            RectangleFigure node2 = new RectangleFigure();
            RectangleFigure node3 = new RectangleFigure();
            ChopboxAnchor anchor = new ChopboxAnchor((IFigure)node2);
            this.conn1 = new AbstractForestRouterTest.TreeConnection();
            this.conn1.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
            this.conn1.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn1.setHint("tree1");
            this.conn1.setConnectionRouter((ConnectionRouter)this.treeRouter);
            this.conn2 = new AbstractForestRouterTest.TreeConnection();
            this.conn2.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node3));
            this.conn2.setTargetAnchor((ConnectionAnchor)anchor);
            this.conn2.setHint("tree1");
            this.conn2.setConnectionRouter((ConnectionRouter)this.treeRouter);
            this.getConnection1().setOrientation(ITreeConnection.Orientation.VERTICAL);
            this.getConnection2().setOrientation(ITreeConnection.Orientation.VERTICAL);
        }
        catch (Exception e) {
            TreeRouterTest.fail((String)("The ForestRouterTest.setUp method caught an exception - " + e));
        }
    }

    public void testOrthogonalConstraint() {
        List newConstraint = this.initializeConstraint(this.test1, this.test1Start, this.test1End, this.test1Other);
        this.validateConstraint(newConstraint);
    }

    public void testRATLC00531806() {
        List newConstraint = this.initializeConstraint(this.test2, this.test2Start, this.test2End, this.test2Other);
        this.validateConstraint(newConstraint);
    }

    public void testRATLC00534189() {
        List newConstraint = this.initializeConstraint(this.test1, this.test1Start, this.test1End, this.test1Other);
        this.getConnection1().setSourceAnchor((ConnectionAnchor)new XYAnchor(new Point(100, 100)));
        this.getTreeRouter().setConstraint((Connection)this.getConnection1(), (Object)newConstraint);
        this.getTreeRouter().route((Connection)this.getConnection2());
        this.getTreeRouter().route((Connection)this.getConnection1());
        this.getTreeRouter().invalidate((Connection)this.getConnection1());
        this.getTreeRouter().invalidate((Connection)this.getConnection2());
    }

    public void testMoveShape() {
        List newConstraint = this.initializeConstraint(this.test1, this.test1Start, this.test1End, this.test1Other);
        this.getTreeRouter().setConstraint((Connection)this.getConnection1(), (Object)newConstraint);
        this.getTreeRouter().route((Connection)this.getConnection2());
        this.getTreeRouter().route((Connection)this.getConnection1());
        Rectangle newBounds = new Rectangle(this.test1Start);
        newBounds.translate(4000, 4000);
        this.getConnection1().getSourceAnchor().getOwner().setBounds(newBounds);
        this.getTreeRouter().route((Connection)this.getConnection1());
        this.getConnection2().validate();
        PointList c1Pts = this.getConnection1().getPoints();
        PointList c2Pts = this.getConnection2().getPoints();
        TreeRouterTest.assertTrue((String)"Trunk values don't match after tree routing", (boolean)c1Pts.getPoint(2).equals((Object)c2Pts.getPoint(2)));
    }

    private void validateConstraint(List newConstraint) {
        this.getTreeRouter().setConstraint((Connection)this.getConnection1(), (Object)newConstraint);
        PointList ptl1 = this.getTreeRouter().getPointsFromConstraint((Connection)this.getConnection1());
        this.getTreeRouter().route((Connection)this.getConnection2());
        this.getTreeRouter().route((Connection)this.getConnection1());
        TreeRouterTest.assertTrue((String)"Connection1 points aren't orthogonal", (boolean)this.getTreeRouter().isOrthogonalTreeBranch((Connection)this.getConnection1(), ptl1));
        PointList c1Pts = this.getConnection1().getPoints();
        PointList c2Pts = this.getConnection2().getPoints();
        TreeRouterTest.assertTrue((String)"Connection2 points aren't orthogonal", (boolean)this.getTreeRouter().isOrthogonalTreeBranch((Connection)this.getConnection2(), c2Pts));
        TreeRouterTest.assertTrue((String)"Trunk values don't match after tree routing", (boolean)c1Pts.getPoint(2).equals((Object)c2Pts.getPoint(2)));
    }

    private List initializeConstraint(Dimension[] testData, Rectangle start, Rectangle end, Rectangle other) {
        ArrayList<RelativeBendpoint> newConstraint = new ArrayList<RelativeBendpoint>(this.getConnection1().getPoints().size());
        this.getConnection1().getSourceAnchor().getOwner().setBounds(start);
        this.getConnection1().getTargetAnchor().getOwner().setBounds(end);
        this.getConnection2().getSourceAnchor().getOwner().setBounds(other);
        RelativeBendpoint rbp1 = new RelativeBendpoint((Connection)this.getConnection1());
        rbp1.setRelativeDimensions(testData[0], testData[1]);
        rbp1.setWeight(0.2f);
        newConstraint.add(rbp1);
        RelativeBendpoint rbp2 = new RelativeBendpoint((Connection)this.getConnection1());
        rbp2.setRelativeDimensions(testData[2], testData[3]);
        rbp2.setWeight(0.4f);
        newConstraint.add(rbp2);
        RelativeBendpoint rbp3 = new RelativeBendpoint((Connection)this.getConnection1());
        rbp3.setRelativeDimensions(testData[4], testData[5]);
        rbp3.setWeight(0.6f);
        newConstraint.add(rbp3);
        RelativeBendpoint rbp4 = new RelativeBendpoint((Connection)this.getConnection1());
        rbp4.setRelativeDimensions(testData[6], testData[7]);
        rbp4.setWeight(0.8f);
        newConstraint.add(rbp4);
        return newConstraint;
    }
}

