/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.svg;

import java.awt.geom.Rectangle2D;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.lite.svg.SVGFigure;
import org.eclipse.gmf.tests.lite.svg.AbstractSVGFigureTest;
import org.eclipse.swt.graphics.RGB;

public class SVGFigureTest
extends AbstractSVGFigureTest {
    public SVGFigureTest(String name) {
        super(name);
    }

    public void testCanvasSetup() {
        this.paintImage();
        Dimension size = this.getParentFigure().getSize();
        SVGFigureTest.assertEquals((int)size.width, (int)200);
        SVGFigureTest.assertEquals((int)size.height, (int)200);
        this.assertColor(0, 0, ColorConstants.green.getRGB());
        this.assertColor(1, 1, ColorConstants.yellow.getRGB());
        this.assertColor(100, 100, ColorConstants.yellow.getRGB());
        this.assertColor(198, 198, ColorConstants.yellow.getRGB());
        this.assertColor(199, 199, ColorConstants.green.getRGB());
    }

    public void testDocumentLoading() {
        SVGFigure f = new SVGFigure();
        f.setURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        SVGFigureTest.assertTrue((boolean)f.checkContentAvailable());
    }

    public void testRendering() {
        SVGFigure f = new SVGFigure();
        f.setURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        f.setPreferredSize(50, 50);
        this.getParentFigure().add((IFigure)f);
        this.paintImage();
        this.assertColor(0, 0, new RGB(0, 0, 0));
        this.assertColor(1, 1, new RGB(102, 51, 0));
        this.assertColor(48, 48, new RGB(102, 51, 0));
        this.assertColor(49, 49, new RGB(0, 0, 0));
        this.assertColor(25, 50, ColorConstants.yellow.getRGB());
        this.assertColor(50, 25, ColorConstants.yellow.getRGB());
    }

    public void testClientArea() {
        SVGFigure f = new SVGFigure();
        f.setURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/box.svg");
        f.setPreferredSize(90, 90);
        f.setBorder((Border)new MarginBorder(20));
        this.getParentFigure().add((IFigure)f);
        this.paintImage();
        this.assertColor(19, 19, ColorConstants.yellow.getRGB());
        this.assertColor(20, 20, new RGB(0, 0, 0));
        this.assertColor(21, 21, new RGB(102, 51, 0));
    }

    public void testAreaOfInterest() {
        SVGFigure f = new SVGFigure();
        f.setURI("platform:/plugin/org.eclipse.gmf.tests.lite/images/group.svg");
        f.setAreaOfInterest((Rectangle2D)new Rectangle2D.Float(20.0f, 20.0f, 20.0f, 20.0f));
        f.setPreferredSize(20, 20);
        this.getParentFigure().add((IFigure)f);
        this.paintImage();
        this.assertColor(0, 0, new RGB(0, 0, 255));
        this.assertColor(1, 1, new RGB(255, 0, 0));
        this.assertColor(18, 18, new RGB(255, 0, 0));
        this.assertColor(19, 19, new RGB(0, 0, 255));
        this.assertColor(19, 20, ColorConstants.yellow.getRGB());
        this.assertColor(20, 19, ColorConstants.yellow.getRGB());
    }
}

